/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.util.Map;
import org.apache.hadoop.mapred.StatisticsCollector;
import org.junit.Assert;
import org.junit.Test;

public class TestStatisticsCollector {
    @Test(timeout=20000L)
    public void testMovingWindow() throws Exception {
        StatisticsCollector collector = new StatisticsCollector(1);
        StatisticsCollector.TimeWindow window = new StatisticsCollector.TimeWindow("test", 6, 2);
        StatisticsCollector.TimeWindow sincStart = StatisticsCollector.SINCE_START;
        StatisticsCollector.TimeWindow[] windows = new StatisticsCollector.TimeWindow[]{sincStart, window};
        StatisticsCollector.Stat stat = collector.createStat("m1", windows);
        stat.inc(3);
        collector.update();
        Assert.assertEquals((long)0L, (long)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(window)).getValue());
        Assert.assertEquals((long)3L, (long)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(sincStart)).getValue());
        stat.inc(3);
        collector.update();
        Assert.assertEquals((long)6L, (long)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(window)).getValue());
        Assert.assertEquals((long)6L, (long)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(sincStart)).getValue());
        stat.inc(10);
        collector.update();
        Assert.assertEquals((long)6L, (long)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(window)).getValue());
        Assert.assertEquals((long)16L, (long)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(sincStart)).getValue());
        stat.inc(10);
        collector.update();
        Assert.assertEquals((long)26L, (long)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(window)).getValue());
        Assert.assertEquals((long)26L, (long)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(sincStart)).getValue());
        stat.inc(10);
        collector.update();
        stat.inc(10);
        collector.update();
        Assert.assertEquals((long)46L, (long)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(window)).getValue());
        Assert.assertEquals((long)46L, (long)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(sincStart)).getValue());
        stat.inc(10);
        collector.update();
        Assert.assertEquals((long)46L, (long)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(window)).getValue());
        Assert.assertEquals((long)56L, (long)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(sincStart)).getValue());
        stat.inc(12);
        collector.update();
        Assert.assertEquals((long)62L, (long)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(window)).getValue());
        Assert.assertEquals((long)68L, (long)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(sincStart)).getValue());
        stat.inc(13);
        collector.update();
        Assert.assertEquals((long)62L, (long)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(window)).getValue());
        Assert.assertEquals((long)81L, (long)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(sincStart)).getValue());
        stat.inc(14);
        collector.update();
        Assert.assertEquals((long)69L, (long)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(window)).getValue());
        Assert.assertEquals((long)95L, (long)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(sincStart)).getValue());
        Map updaters = collector.getUpdaters();
        Assert.assertEquals((long)updaters.size(), (long)2L);
        Map ststistics = collector.getStatistics();
        Assert.assertNotNull(ststistics.get("m1"));
        StatisticsCollector.Stat newStat = collector.createStat("m2");
        Assert.assertEquals((Object)newStat.name, (Object)"m2");
        StatisticsCollector.Stat st = collector.removeStat("m1");
        Assert.assertEquals((Object)st.name, (Object)"m1");
        Assert.assertEquals((long)69L, (long)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(window)).getValue());
        Assert.assertEquals((long)95L, (long)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(sincStart)).getValue());
        st = collector.removeStat("m1");
        Assert.assertNull((Object)st);
        collector.start();
        Thread.sleep(2500L);
        Assert.assertEquals((long)69L, (long)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(window)).getValue());
        Assert.assertEquals((long)95L, (long)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(sincStart)).getValue());
    }
}

