/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.mapreduce.security.TestBinaryTokenFile;
import org.apache.hadoop.mapreduce.v2.MiniMRYarnCluster;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestBinaryTokenFile {
    private static final String KEY_SECURITY_TOKEN_FILE_NAME = "key-security-token-file";
    private static final String DELEGATION_TOKEN_KEY = "Hdfs";
    private static MiniMRYarnCluster mrCluster;
    private static MiniDFSCluster dfsCluster;
    private static final Path TEST_DIR;
    private static final Path binaryTokenFileName;
    private static final int numSlaves = 1;
    private static final int noOfNMs = 1;
    private static Path p1;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = new Configuration();
        conf.set("mapreduce.framework.name", "yarn");
        conf.set("yarn.resourcemanager.principal", "jt_id/_HOST@APACHE.ORG");
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(conf);
        builder.checkExitOnShutdown(true);
        builder.numDataNodes(1);
        builder.format(true);
        builder.racks(null);
        dfsCluster = builder.build();
        mrCluster = new MiniMRYarnCluster(TestBinaryTokenFile.class.getName(), 1);
        mrCluster.init(conf);
        mrCluster.start();
        NameNodeAdapter.getDtSecretManager((FSNamesystem)dfsCluster.getNamesystem()).startThreads();
        FileSystem fs = dfsCluster.getFileSystem();
        p1 = new Path("file1");
        p1 = fs.makeQualified(p1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (mrCluster != null) {
            mrCluster.stop();
            mrCluster = null;
        }
        if (dfsCluster != null) {
            dfsCluster.shutdown();
            dfsCluster = null;
        }
    }

    @Test
    public void testBinaryTokenFile() throws IOException {
        Configuration conf = mrCluster.getConfig();
        String nnUri = dfsCluster.getURI(0).toString();
        conf.set("mapreduce.job.hdfs-servers", nnUri + "," + nnUri);
        String[] args = new String[]{"-m", "1", "-r", "1", "-mt", "1", "-rt", "1"};
        int res = -1;
        try {
            res = ToolRunner.run((Configuration)conf, (Tool)new MySleepJob(this), (String[])args);
        }
        catch (Exception e) {
            System.out.println("Job failed with " + e.getLocalizedMessage());
            e.printStackTrace(System.out);
            Assert.fail((String)"Job failed");
        }
        Assert.assertEquals((String)"dist job res is not 0:", (long)0L, (long)res);
    }

    static /* synthetic */ Path access$000() {
        return p1;
    }

    static /* synthetic */ Path access$100() {
        return binaryTokenFileName;
    }

    static {
        TEST_DIR = new Path(System.getProperty("test.build.data", "/tmp"));
        binaryTokenFileName = new Path(TEST_DIR, "tokenFile.binary");
    }
}

