/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.LocalContainerLauncher;
import org.apache.hadoop.mapred.ShuffleHandler;
import org.apache.hadoop.mapreduce.v2.MiniMRYarnCluster;
import org.apache.hadoop.mapreduce.v2.hs.JobHistoryServer;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils;
import org.apache.hadoop.util.JarFinder;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.DefaultContainerExecutor;
import org.apache.hadoop.yarn.service.Service;

public class MiniMRYarnCluster
extends MiniYARNCluster {
    public static final String APPJAR = JarFinder.getJar(LocalContainerLauncher.class);
    private static final Log LOG = LogFactory.getLog(MiniMRYarnCluster.class);
    private JobHistoryServer historyServer;
    private JobHistoryServerWrapper historyServerWrapper = new JobHistoryServerWrapper(this);

    public MiniMRYarnCluster(String testName) {
        this(testName, 1);
    }

    public MiniMRYarnCluster(String testName, int noOfNMs) {
        super(testName, noOfNMs, 4, 4);
        this.addService((Service)this.historyServerWrapper);
    }

    public void init(Configuration conf) {
        conf.set("mapreduce.framework.name", "yarn");
        if (conf.get("yarn.app.mapreduce.am.staging-dir") == null) {
            conf.set("yarn.app.mapreduce.am.staging-dir", new File(this.getTestWorkDir(), "apps_staging_dir/").getAbsolutePath());
        }
        conf.set("fs.permissions.umask-mode", "000");
        try {
            Path stagingPath = FileContext.getFileContext((Configuration)conf).makeQualified(new Path(conf.get("yarn.app.mapreduce.am.staging-dir")));
            FileContext fc = FileContext.getFileContext((URI)stagingPath.toUri(), (Configuration)conf);
            if (fc.util().exists(stagingPath)) {
                LOG.info((Object)(stagingPath + " exists! deleting..."));
                fc.delete(stagingPath, true);
            }
            LOG.info((Object)("mkdir: " + stagingPath));
            fc.mkdir(stagingPath, null, true);
            String doneDir = JobHistoryUtils.getConfiguredHistoryServerDoneDirPrefix((Configuration)conf);
            Path doneDirPath = fc.makeQualified(new Path(doneDir));
            fc.mkdir(doneDirPath, null, true);
        }
        catch (IOException e) {
            throw new YarnException("Could not create staging directory. ", (Throwable)e);
        }
        conf.set("mapreduce.jobtracker.address", "test");
        conf.setStrings("yarn.nodemanager.aux-services", new String[]{"mapreduce.shuffle"});
        conf.setClass(String.format("yarn.nodemanager.aux-services.%s.class", "mapreduce.shuffle"), ShuffleHandler.class, Service.class);
        conf.setInt("mapreduce.shuffle.port", 0);
        conf.setClass("yarn.nodemanager.container-executor.class", DefaultContainerExecutor.class, ContainerExecutor.class);
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        super.init(conf);
    }

    public JobHistoryServer getHistoryServer() {
        return this.historyServer;
    }

    static /* synthetic */ JobHistoryServer access$002(MiniMRYarnCluster x0, JobHistoryServer x1) {
        x0.historyServer = x1;
        return x0.historyServer;
    }

    static /* synthetic */ JobHistoryServer access$000(MiniMRYarnCluster x0) {
        return x0.historyServer;
    }

    static /* synthetic */ Log access$100() {
        return LOG;
    }
}

