/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import org.apache.hadoop.mapred.JobConf;
import org.junit.Assert;
import org.junit.Test;

public class TestJobConf {
    @Test
    public void testProfileParamsDefaults() {
        JobConf configuration = new JobConf();
        Assert.assertNull((Object)configuration.get("mapreduce.task.profile.params"));
        String result = configuration.getProfileParams();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.contains("file=%s"));
        Assert.assertTrue((boolean)result.startsWith("-agentlib:hprof"));
    }

    @Test
    public void testProfileParamsSetter() {
        JobConf configuration = new JobConf();
        configuration.setProfileParams("test");
        Assert.assertEquals((Object)"test", (Object)configuration.get("mapreduce.task.profile.params"));
    }

    @Test
    public void testProfileParamsGetter() {
        JobConf configuration = new JobConf();
        configuration.set("mapreduce.task.profile.params", "test");
        Assert.assertEquals((Object)"test", (Object)configuration.getProfileParams());
    }

    @Test
    public void testMemoryConfigForMapOrReduceTask() {
        JobConf configuration = new JobConf();
        configuration.set("mapreduce.map.memory.mb", String.valueOf(300));
        configuration.set("mapreduce.reduce.memory.mb", String.valueOf(300));
        Assert.assertEquals((long)configuration.getMemoryForMapTask(), (long)300L);
        Assert.assertEquals((long)configuration.getMemoryForReduceTask(), (long)300L);
        configuration.set("mapred.task.maxvmem", String.valueOf(0x200000));
        configuration.set("mapreduce.map.memory.mb", String.valueOf(300));
        configuration.set("mapreduce.reduce.memory.mb", String.valueOf(300));
        Assert.assertEquals((long)configuration.getMemoryForMapTask(), (long)2L);
        Assert.assertEquals((long)configuration.getMemoryForReduceTask(), (long)2L);
        configuration = new JobConf();
        configuration.set("mapred.task.maxvmem", "-1");
        configuration.set("mapreduce.map.memory.mb", String.valueOf(300));
        configuration.set("mapreduce.reduce.memory.mb", String.valueOf(400));
        Assert.assertEquals((long)configuration.getMemoryForMapTask(), (long)300L);
        Assert.assertEquals((long)configuration.getMemoryForReduceTask(), (long)400L);
        configuration = new JobConf();
        configuration.set("mapred.task.maxvmem", String.valueOf(0x200000));
        configuration.set("mapreduce.map.memory.mb", "-1");
        configuration.set("mapreduce.reduce.memory.mb", "-1");
        Assert.assertEquals((long)configuration.getMemoryForMapTask(), (long)2L);
        Assert.assertEquals((long)configuration.getMemoryForReduceTask(), (long)2L);
        configuration = new JobConf();
        configuration.set("mapred.task.maxvmem", String.valueOf(-1));
        configuration.set("mapreduce.map.memory.mb", "-1");
        configuration.set("mapreduce.reduce.memory.mb", "-1");
        Assert.assertEquals((long)configuration.getMemoryForMapTask(), (long)-1L);
        Assert.assertEquals((long)configuration.getMemoryForReduceTask(), (long)-1L);
        configuration = new JobConf();
        configuration.set("mapred.task.maxvmem", String.valueOf(0x200000));
        configuration.set("mapreduce.map.memory.mb", "3");
        configuration.set("mapreduce.reduce.memory.mb", "3");
        Assert.assertEquals((long)configuration.getMemoryForMapTask(), (long)2L);
        Assert.assertEquals((long)configuration.getMemoryForReduceTask(), (long)2L);
    }

    @Test
    public void testNegativeValueForTaskVmem() {
        JobConf configuration = new JobConf();
        configuration.set("mapred.task.maxvmem", "-3");
        configuration.set("mapreduce.map.memory.mb", "4");
        configuration.set("mapreduce.reduce.memory.mb", "5");
        Assert.assertEquals((long)4L, (long)configuration.getMemoryForMapTask());
        Assert.assertEquals((long)5L, (long)configuration.getMemoryForReduceTask());
    }

    @Test
    public void testNegativeValuesForMemoryParams() {
        JobConf configuration = new JobConf();
        configuration.set("mapred.task.maxvmem", "-4");
        configuration.set("mapreduce.map.memory.mb", "-5");
        configuration.set("mapreduce.reduce.memory.mb", "-6");
        Assert.assertEquals((long)-1L, (long)configuration.getMemoryForMapTask());
        Assert.assertEquals((long)-1L, (long)configuration.getMemoryForReduceTask());
        Assert.assertEquals((long)-1L, (long)configuration.getMaxVirtualMemoryForTask());
    }

    @Test
    public void testMaxVirtualMemoryForTask() {
        JobConf configuration = new JobConf();
        configuration.set("mapreduce.map.memory.mb", String.valueOf(300));
        configuration.set("mapreduce.reduce.memory.mb", String.valueOf(-1));
        Assert.assertEquals((long)configuration.getMaxVirtualMemoryForTask(), (long)314572800L);
        configuration = new JobConf();
        configuration.set("mapreduce.map.memory.mb", String.valueOf(-1));
        configuration.set("mapreduce.reduce.memory.mb", String.valueOf(200));
        Assert.assertEquals((long)configuration.getMaxVirtualMemoryForTask(), (long)0xC800000L);
        configuration = new JobConf();
        configuration.set("mapreduce.map.memory.mb", String.valueOf(-1));
        configuration.set("mapreduce.reduce.memory.mb", String.valueOf(-1));
        configuration.set("mapred.task.maxvmem", String.valueOf(0x100000));
        Assert.assertEquals((long)configuration.getMaxVirtualMemoryForTask(), (long)0x100000L);
        configuration = new JobConf();
        configuration.set("mapred.task.maxvmem", String.valueOf(0x100000));
        Assert.assertEquals((long)configuration.getMaxVirtualMemoryForTask(), (long)0x100000L);
        configuration = new JobConf();
        configuration.setMaxVirtualMemoryForTask(0x200000L);
        Assert.assertEquals((long)configuration.getMemoryForMapTask(), (long)2L);
        Assert.assertEquals((long)configuration.getMemoryForReduceTask(), (long)2L);
        configuration = new JobConf();
        configuration.set("mapreduce.map.memory.mb", String.valueOf(300));
        configuration.set("mapreduce.reduce.memory.mb", String.valueOf(400));
        configuration.setMaxVirtualMemoryForTask(0x200000L);
        Assert.assertEquals((long)configuration.getMemoryForMapTask(), (long)2L);
        Assert.assertEquals((long)configuration.getMemoryForReduceTask(), (long)2L);
    }
}

