/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.slive.ConfigExtractor;
import org.apache.hadoop.fs.slive.Operation;
import org.apache.hadoop.fs.slive.OperationOutput;
import org.apache.hadoop.fs.slive.Range;
import org.apache.hadoop.fs.slive.SleepOp;
import org.apache.hadoop.fs.slive.Timer;
import org.apache.hadoop.fs.slive.WeightSelector;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.StringUtils;

public class SliveMapper
extends MapReduceBase
implements Mapper<Object, Object, Text, Text> {
    private static final Log LOG = LogFactory.getLog(SliveMapper.class);
    private static final String OP_TYPE = SliveMapper.class.getSimpleName();
    private FileSystem filesystem;
    private ConfigExtractor config;
    private WeightSelector selector;
    private Random rnd;

    public void configure(JobConf conf) {
        try {
            this.filesystem = FileSystem.get((Configuration)conf);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get the filesystem from provided configuration", e);
        }
        try {
            this.config = new ConfigExtractor((Configuration)conf);
            Long rndSeed = this.config.getRandomSeed();
            this.rnd = rndSeed != null ? new Random(rndSeed) : new Random();
            this.selector = new WeightSelector(this.config, this.rnd);
            ConfigExtractor.dumpOptions((ConfigExtractor)this.config);
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to setup slive " + StringUtils.stringifyException((Throwable)e)));
            throw new RuntimeException("Unable to setup slive configuration", e);
        }
    }

    private ConfigExtractor getConfig() {
        return this.config;
    }

    private WeightSelector getSelector() {
        return this.selector;
    }

    private void logAndSetStatus(Reporter r, String msg) {
        r.setStatus(msg);
        LOG.info((Object)msg);
    }

    private void runOperation(Operation op, Reporter reporter, OutputCollector<Text, Text> output, long opNum) throws IOException {
        if (op == null) {
            return;
        }
        this.logAndSetStatus(reporter, "Running operation #" + opNum + " (" + op + ")");
        List opOut = op.run(this.filesystem);
        this.logAndSetStatus(reporter, "Finished operation #" + opNum + " (" + op + ")");
        if (opOut != null && !opOut.isEmpty()) {
            for (OperationOutput outData : opOut) {
                output.collect((Object)outData.getKey(), (Object)outData.getOutputValue());
            }
        }
    }

    public void map(Object key, Object value, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
        this.logAndSetStatus(reporter, "Running slive mapper for dummy key " + key + " and dummy value " + value);
        long startTime = Timer.now();
        long opAm = 0L;
        long sleepOps = 0L;
        int duration = this.getConfig().getDurationMilliseconds();
        Range sleepRange = this.getConfig().getSleepRange();
        SleepOp sleeper = null;
        if (sleepRange != null) {
            sleeper = new SleepOp(this.getConfig(), this.rnd);
        }
        WeightSelector selector = this.getSelector();
        while (Timer.elapsed((long)startTime) < (long)duration) {
            try {
                this.logAndSetStatus(reporter, "Attempting to select operation #" + (opAm + 1L));
                int currElapsed = (int)Timer.elapsed((long)startTime);
                Operation op = selector.select(currElapsed, duration);
                if (op == null) break;
                this.runOperation(op, reporter, output, ++opAm);
                if (sleeper == null) continue;
                this.runOperation((Operation)sleeper, reporter, output, ++sleepOps);
            }
            catch (Exception e) {
                this.logAndSetStatus(reporter, "Failed at running due to " + StringUtils.stringifyException((Throwable)e));
                if (!this.getConfig().shouldExitOnFirstError()) continue;
                break;
            }
        }
        long timeTaken = Timer.elapsed((long)startTime);
        OperationOutput opCount = new OperationOutput(OperationOutput.OutputType.LONG, OP_TYPE, "op_count", (Object)opAm);
        output.collect((Object)opCount.getKey(), (Object)opCount.getOutputValue());
        OperationOutput overallTime = new OperationOutput(OperationOutput.OutputType.LONG, OP_TYPE, "milliseconds_taken", (Object)timeTaken);
        output.collect((Object)overallTime.getKey(), (Object)overallTime.getOutputValue());
        this.logAndSetStatus(reporter, "Finished " + opAm + " operations in " + timeTaken + " milliseconds");
    }
}

