/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.ClientServiceDelegate;
import org.apache.hadoop.mapred.ResourceMgrDelegate;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.v2.api.MRClientProtocol;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.ipc.YarnRPC;

public class ClientCache {
    private final Configuration conf;
    private final ResourceMgrDelegate rm;
    private static final Log LOG = LogFactory.getLog(ClientCache.class);
    private Map<JobID, ClientServiceDelegate> cache = new HashMap();
    private MRClientProtocol hsProxy;

    public ClientCache(Configuration conf, ResourceMgrDelegate rm) {
        this.conf = conf;
        this.rm = rm;
    }

    public synchronized ClientServiceDelegate getClient(JobID jobId) {
        ClientServiceDelegate client;
        if (this.hsProxy == null) {
            try {
                this.hsProxy = this.instantiateHistoryProxy();
            }
            catch (IOException e) {
                LOG.warn((Object)"Could not connect to History server.", (Throwable)e);
                throw new YarnException("Could not connect to History server.", (Throwable)e);
            }
        }
        if ((client = (ClientServiceDelegate)this.cache.get(jobId)) == null) {
            client = new ClientServiceDelegate(this.conf, this.rm, jobId, this.hsProxy);
            this.cache.put(jobId, client);
        }
        return client;
    }

    protected synchronized MRClientProtocol getInitializedHSProxy() throws IOException {
        if (this.hsProxy == null) {
            this.hsProxy = this.instantiateHistoryProxy();
        }
        return this.hsProxy;
    }

    protected MRClientProtocol instantiateHistoryProxy() throws IOException {
        String serviceAddr = this.conf.get("mapreduce.jobhistory.address");
        if (StringUtils.isEmpty((String)serviceAddr)) {
            return null;
        }
        LOG.debug((Object)("Connecting to HistoryServer at: " + serviceAddr));
        YarnRPC rpc = YarnRPC.create((Configuration)this.conf);
        LOG.debug((Object)("Connected to HistoryServer at: " + serviceAddr));
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        return (MRClientProtocol)currentUser.doAs((PrivilegedAction)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ Configuration access$000(ClientCache x0) {
        return x0.conf;
    }
}

