/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MRCaching;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapreduce.filecache.DistributedCache;
import org.apache.hadoop.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class MRCaching {
    static String testStr = "This is a test file used for testing caching jars, zip and normal files.";

    static void setupCache(String cacheDir, FileSystem fs) throws IOException {
        Path localPath = new Path(System.getProperty("test.cache.data", "build/test/cache"));
        Path txtPath = new Path(localPath, new Path("test.txt"));
        Path jarPath = new Path(localPath, new Path("test.jar"));
        Path zipPath = new Path(localPath, new Path("test.zip"));
        Path tarPath = new Path(localPath, new Path("test.tgz"));
        Path tarPath1 = new Path(localPath, new Path("test.tar.gz"));
        Path tarPath2 = new Path(localPath, new Path("test.tar"));
        Path cachePath = new Path(cacheDir);
        fs.delete(cachePath, true);
        if (!fs.mkdirs(cachePath)) {
            throw new IOException("Mkdirs failed to create " + cachePath.toString());
        }
        fs.copyFromLocalFile(txtPath, cachePath);
        fs.copyFromLocalFile(jarPath, cachePath);
        fs.copyFromLocalFile(zipPath, cachePath);
        fs.copyFromLocalFile(tarPath, cachePath);
        fs.copyFromLocalFile(tarPath1, cachePath);
        fs.copyFromLocalFile(tarPath2, cachePath);
    }

    public static TestResult launchMRCache(String indir, String outdir, String cacheDir, JobConf conf, String input) throws IOException {
        MRCaching.setupCache((String)cacheDir, (FileSystem)FileSystem.get((Configuration)conf));
        return MRCaching.launchMRCache((String)indir, (String)outdir, (String)cacheDir, (JobConf)conf, (String)input, (boolean)false);
    }

    public static TestResult launchMRCache(String indir, String outdir, String cacheDir, JobConf conf, String input, boolean withSymlink) throws IOException {
        String TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp")).toString().replace(' ', '+');
        conf.set("test.build.data", TEST_ROOT_DIR);
        Path inDir = new Path(indir);
        Path outDir = new Path(outdir);
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(outDir, true);
        if (!fs.mkdirs(inDir)) {
            throw new IOException("Mkdirs failed to create " + inDir.toString());
        }
        System.out.println("HERE:" + inDir);
        FSDataOutputStream file = fs.create(new Path(inDir, "part-0"));
        file.writeBytes(input);
        file.close();
        conf.setJobName("cachetest");
        conf.setOutputKeyClass(Text.class);
        conf.setOutputValueClass(IntWritable.class);
        conf.setCombinerClass(ReduceClass.class);
        conf.setReducerClass(ReduceClass.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        conf.setNumMapTasks(1);
        conf.setNumReduceTasks(1);
        conf.setSpeculativeExecution(false);
        URI[] uris = new URI[6];
        if (!withSymlink) {
            conf.setMapperClass(MapClass.class);
            uris[0] = fs.getUri().resolve(cacheDir + "/test.txt");
            uris[1] = fs.getUri().resolve(cacheDir + "/test.jar");
            uris[2] = fs.getUri().resolve(cacheDir + "/test.zip");
            uris[3] = fs.getUri().resolve(cacheDir + "/test.tgz");
            uris[4] = fs.getUri().resolve(cacheDir + "/test.tar.gz");
            uris[5] = fs.getUri().resolve(cacheDir + "/test.tar");
        } else {
            DistributedCache.createSymlink((Configuration)conf);
            conf.setMapperClass(MapClass2.class);
            uris[0] = fs.getUri().resolve(cacheDir + "/test.txt#" + "test.txt");
            uris[1] = fs.getUri().resolve(cacheDir + "/test.jar#" + "testjar");
            uris[2] = fs.getUri().resolve(cacheDir + "/test.zip#" + "testzip");
            uris[3] = fs.getUri().resolve(cacheDir + "/test.tgz#" + "testtgz");
            uris[4] = fs.getUri().resolve(cacheDir + "/test.tar.gz#" + "testtargz");
            uris[5] = fs.getUri().resolve(cacheDir + "/test.tar#" + "testtar");
        }
        DistributedCache.addCacheFile((URI)uris[0], (Configuration)conf);
        long[] fileSizes = new long[]{fs.getFileStatus(new Path(uris[0].getPath())).getLen()};
        long[] archiveSizes = new long[5];
        for (int i = 1; i < 6; ++i) {
            DistributedCache.addCacheArchive((URI)uris[i], (Configuration)conf);
            archiveSizes[i - 1] = fs.getFileStatus(new Path(uris[i].getPath())).getLen();
        }
        RunningJob job = JobClient.runJob((JobConf)conf);
        int count = 0;
        Path result = new Path(TEST_ROOT_DIR + "/test.txt");
        BufferedReader file2 = new BufferedReader(new InputStreamReader((InputStream)FileSystem.getLocal((Configuration)conf).open(result)));
        String line = file2.readLine();
        while (line != null) {
            if (!testStr.equals(line)) {
                return new TestResult(job, false);
            }
            ++count;
            line = file2.readLine();
        }
        file2.close();
        if (count != 6) {
            return new TestResult(job, false);
        }
        MRCaching.validateCacheFileSizes((Configuration)job.getConfiguration(), (long[])fileSizes, (String)"mapreduce.job.cache.files.filesizes");
        MRCaching.validateCacheFileSizes((Configuration)job.getConfiguration(), (long[])archiveSizes, (String)"mapreduce.job.cache.archives.filesizes");
        return new TestResult(job, true);
    }

    private static void validateCacheFileSizes(Configuration job, long[] expectedSizes, String configKey) throws IOException {
        String configValues = job.get(configKey, "");
        System.out.println(configKey + " -> " + configValues);
        String[] realSizes = StringUtils.getStrings((String)configValues);
        Assert.assertEquals((String)("Number of files for " + configKey), (int)expectedSizes.length, (int)realSizes.length);
        for (int i = 0; i < expectedSizes.length; ++i) {
            long actual = Long.valueOf(realSizes[i]);
            long expected = expectedSizes[i];
            Assert.assertEquals((String)("File " + i + " for " + configKey), (long)expected, (long)actual);
        }
    }
}

