/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.IndexCache;
import org.apache.hadoop.mapred.IndexRecord;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TestIndexCache;
import org.apache.hadoop.security.UserGroupInformation;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestIndexCache
extends TestCase {
    public void testLRCPolicy() throws Exception {
        int totalsize;
        Random r = new Random();
        long seed = r.nextLong();
        r.setSeed(seed);
        System.out.println("seed: " + seed);
        JobConf conf = new JobConf();
        FileSystem fs = FileSystem.getLocal((Configuration)conf).getRaw();
        Path p = new Path(System.getProperty("test.build.data", "/tmp"), "cache").makeQualified(fs);
        fs.delete(p, true);
        conf.setInt("mapreduce.tasktracker.indexcache.mb", 1);
        int partsPerMap = 1000;
        int bytesPerFile = 24000;
        IndexCache cache = new IndexCache(conf);
        for (totalsize = 24000; totalsize < 0x100000; totalsize += 24000) {
            Path f = new Path(p, Integer.toString(totalsize, 36));
            TestIndexCache.writeFile((FileSystem)fs, (Path)f, (long)totalsize, (int)1000);
            IndexRecord rec = cache.getIndexInformation(Integer.toString(totalsize, 36), r.nextInt(1000), f, UserGroupInformation.getCurrentUser().getShortUserName());
            TestIndexCache.checkRecord((IndexRecord)rec, (long)totalsize);
        }
        for (FileStatus stat : fs.listStatus(p)) {
            fs.delete(stat.getPath(), true);
        }
        for (int i = 24000; i < 0x100000; i += 24000) {
            Path f = new Path(p, Integer.toString(i, 36));
            IndexRecord rec = cache.getIndexInformation(Integer.toString(i, 36), r.nextInt(1000), f, UserGroupInformation.getCurrentUser().getShortUserName());
            TestIndexCache.checkRecord((IndexRecord)rec, (long)i);
        }
        Path f = new Path(p, Integer.toString(totalsize, 36));
        TestIndexCache.writeFile((FileSystem)fs, (Path)f, (long)totalsize, (int)1000);
        cache.getIndexInformation(Integer.toString(totalsize, 36), r.nextInt(1000), f, UserGroupInformation.getCurrentUser().getShortUserName());
        fs.delete(f, false);
        boolean fnf = false;
        try {
            cache.getIndexInformation(Integer.toString(24000, 36), r.nextInt(1000), new Path(p, Integer.toString(24000)), UserGroupInformation.getCurrentUser().getShortUserName());
        }
        catch (IOException e) {
            if (e.getCause() == null || !(e.getCause() instanceof FileNotFoundException)) {
                throw e;
            }
            fnf = true;
        }
        if (!fnf) {
            TestIndexCache.fail((String)"Failed to push out last entry");
        }
        for (int i = 48000; i < 0x100000; i += 24000) {
            IndexRecord rec = cache.getIndexInformation(Integer.toString(i, 36), r.nextInt(1000), new Path(p, Integer.toString(i, 36)), UserGroupInformation.getCurrentUser().getShortUserName());
            TestIndexCache.checkRecord((IndexRecord)rec, (long)i);
        }
        IndexRecord rec = cache.getIndexInformation(Integer.toString(totalsize, 36), r.nextInt(1000), f, UserGroupInformation.getCurrentUser().getShortUserName());
        TestIndexCache.checkRecord((IndexRecord)rec, (long)totalsize);
    }

    public void testBadIndex() throws Exception {
        block5: {
            int parts = 30;
            JobConf conf = new JobConf();
            FileSystem fs = FileSystem.getLocal((Configuration)conf).getRaw();
            Path p = new Path(System.getProperty("test.build.data", "/tmp"), "cache").makeQualified(fs);
            fs.delete(p, true);
            conf.setInt("mapreduce.tasktracker.indexcache.mb", 1);
            IndexCache cache = new IndexCache(conf);
            Path f = new Path(p, "badindex");
            FSDataOutputStream out = fs.create(f, false);
            CheckedOutputStream iout = new CheckedOutputStream((OutputStream)out, new CRC32());
            DataOutputStream dout = new DataOutputStream(iout);
            for (int i = 0; i < 30; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (0 == i % 3) {
                        dout.writeLong(i);
                        continue;
                    }
                    out.writeLong((long)i);
                }
            }
            out.writeLong(iout.getChecksum().getValue());
            dout.close();
            try {
                cache.getIndexInformation("badindex", 7, f, UserGroupInformation.getCurrentUser().getShortUserName());
                TestIndexCache.fail((String)"Did not detect bad checksum");
            }
            catch (IOException e) {
                if (e.getCause() instanceof ChecksumException) break block5;
                throw e;
            }
        }
    }

    public void testInvalidReduceNumberOrLength() throws Exception {
        block5: {
            Path feq;
            IndexCache cache;
            block4: {
                JobConf conf = new JobConf();
                FileSystem fs = FileSystem.getLocal((Configuration)conf).getRaw();
                Path p = new Path(System.getProperty("test.build.data", "/tmp"), "cache").makeQualified(fs);
                fs.delete(p, true);
                conf.setInt("mapreduce.tasktracker.indexcache.mb", 1);
                int partsPerMap = 1000;
                int bytesPerFile = 24000;
                cache = new IndexCache(conf);
                feq = new Path(p, "invalidReduceOrPartsPerMap");
                TestIndexCache.writeFile((FileSystem)fs, (Path)feq, (long)24000L, (int)1000);
                try {
                    cache.getIndexInformation("reduceEqualPartsPerMap", 1000, feq, UserGroupInformation.getCurrentUser().getShortUserName());
                    TestIndexCache.fail((String)"Number of reducers equal to partsPerMap did not fail");
                }
                catch (Exception e) {
                    if (e instanceof IOException) break block4;
                    throw e;
                }
            }
            try {
                cache.getIndexInformation("reduceMorePartsPerMap", 1001, feq, UserGroupInformation.getCurrentUser().getShortUserName());
                TestIndexCache.fail((String)"Number of reducers more than partsPerMap did not fail");
            }
            catch (Exception e) {
                if (e instanceof IOException) break block5;
                throw e;
            }
        }
    }

    public void testRemoveMap() throws Exception {
        JobConf conf = new JobConf();
        FileSystem fs = FileSystem.getLocal((Configuration)conf).getRaw();
        Path p = new Path(System.getProperty("test.build.data", "/tmp"), "cache").makeQualified(fs);
        fs.delete(p, true);
        conf.setInt("mapreduce.tasktracker.indexcache.mb", 10);
        int partsPerMap = 100000;
        int bytesPerFile = 2400000;
        IndexCache cache = new IndexCache(conf);
        Path big = new Path(p, "bigIndex");
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        TestIndexCache.writeFile((FileSystem)fs, (Path)big, (long)2400000L, (int)100000);
        for (int i = 0; i < 20; ++i) {
            1 getInfoThread = new /* Unavailable Anonymous Inner Class!! */;
            2 removeMapThread = new /* Unavailable Anonymous Inner Class!! */;
            if (i % 2 == 0) {
                getInfoThread.start();
                removeMapThread.start();
            } else {
                removeMapThread.start();
                getInfoThread.start();
            }
            getInfoThread.join();
            removeMapThread.join();
            TestIndexCache.assertEquals((boolean)true, (boolean)cache.checkTotalMemoryUsed());
        }
    }

    private static void checkRecord(IndexRecord rec, long fill) {
        TestIndexCache.assertEquals((long)fill, (long)rec.startOffset);
        TestIndexCache.assertEquals((long)fill, (long)rec.rawLength);
        TestIndexCache.assertEquals((long)fill, (long)rec.partLength);
    }

    private static void writeFile(FileSystem fs, Path f, long fill, int parts) throws IOException {
        FSDataOutputStream out = fs.create(f, false);
        CheckedOutputStream iout = new CheckedOutputStream((OutputStream)out, new CRC32());
        DataOutputStream dout = new DataOutputStream(iout);
        for (int i = 0; i < parts; ++i) {
            for (int j = 0; j < 3; ++j) {
                dout.writeLong(fill);
            }
        }
        out.writeLong(iout.getChecksum().getValue());
        dout.close();
    }
}

