/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.util.Progressable;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestTextOutputFormat
extends TestCase {
    private static JobConf defaultConf = new JobConf();
    private static FileSystem localFs = null;
    private static String attempt;
    private static Path workDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFormat() throws Exception {
        JobConf job = new JobConf();
        job.set("mapreduce.task.attempt.id", attempt);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)workDir.getParent().getParent());
        FileOutputFormat.setWorkOutputPath((JobConf)job, (Path)workDir);
        FileSystem fs = workDir.getFileSystem((Configuration)job);
        if (!fs.mkdirs(workDir)) {
            TestTextOutputFormat.fail((String)"Failed to create output directory");
        }
        String file = "test.txt";
        Reporter reporter = Reporter.NULL;
        TextOutputFormat theOutputFormat = new TextOutputFormat();
        RecordWriter theRecordWriter = theOutputFormat.getRecordWriter(localFs, job, file, (Progressable)reporter);
        Text key1 = new Text("key1");
        Text key2 = new Text("key2");
        Text val1 = new Text("val1");
        Text val2 = new Text("val2");
        NullWritable nullWritable = NullWritable.get();
        try {
            theRecordWriter.write((Object)key1, (Object)val1);
            theRecordWriter.write(null, (Object)nullWritable);
            theRecordWriter.write(null, (Object)val1);
            theRecordWriter.write((Object)nullWritable, (Object)val2);
            theRecordWriter.write((Object)key2, (Object)nullWritable);
            theRecordWriter.write((Object)key1, null);
            theRecordWriter.write(null, null);
            theRecordWriter.write((Object)key2, (Object)val2);
        }
        finally {
            theRecordWriter.close(reporter);
        }
        File expectedFile = new File(new Path(workDir, file).toString());
        StringBuffer expectedOutput = new StringBuffer();
        expectedOutput.append(key1).append('\t').append(val1).append("\n");
        expectedOutput.append(val1).append("\n");
        expectedOutput.append(val2).append("\n");
        expectedOutput.append(key2).append("\n");
        expectedOutput.append(key1).append("\n");
        expectedOutput.append(key2).append('\t').append(val2).append("\n");
        String output = UtilsForTests.slurp((File)expectedFile);
        TestTextOutputFormat.assertEquals((String)output, (String)expectedOutput.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFormatWithCustomSeparator() throws Exception {
        JobConf job = new JobConf();
        String separator = "\u0001";
        job.set("mapreduce.output.textoutputformat.separator", separator);
        job.set("mapreduce.task.attempt.id", attempt);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)workDir.getParent().getParent());
        FileOutputFormat.setWorkOutputPath((JobConf)job, (Path)workDir);
        FileSystem fs = workDir.getFileSystem((Configuration)job);
        if (!fs.mkdirs(workDir)) {
            TestTextOutputFormat.fail((String)"Failed to create output directory");
        }
        String file = "test.txt";
        Reporter reporter = Reporter.NULL;
        TextOutputFormat theOutputFormat = new TextOutputFormat();
        RecordWriter theRecordWriter = theOutputFormat.getRecordWriter(localFs, job, file, (Progressable)reporter);
        Text key1 = new Text("key1");
        Text key2 = new Text("key2");
        Text val1 = new Text("val1");
        Text val2 = new Text("val2");
        NullWritable nullWritable = NullWritable.get();
        try {
            theRecordWriter.write((Object)key1, (Object)val1);
            theRecordWriter.write(null, (Object)nullWritable);
            theRecordWriter.write(null, (Object)val1);
            theRecordWriter.write((Object)nullWritable, (Object)val2);
            theRecordWriter.write((Object)key2, (Object)nullWritable);
            theRecordWriter.write((Object)key1, null);
            theRecordWriter.write(null, null);
            theRecordWriter.write((Object)key2, (Object)val2);
        }
        finally {
            theRecordWriter.close(reporter);
        }
        File expectedFile = new File(new Path(workDir, file).toString());
        StringBuffer expectedOutput = new StringBuffer();
        expectedOutput.append(key1).append(separator).append(val1).append("\n");
        expectedOutput.append(val1).append("\n");
        expectedOutput.append(val2).append("\n");
        expectedOutput.append(key2).append("\n");
        expectedOutput.append(key1).append("\n");
        expectedOutput.append(key2).append(separator).append(val2).append("\n");
        String output = UtilsForTests.slurp((File)expectedFile);
        TestTextOutputFormat.assertEquals((String)output, (String)expectedOutput.toString());
    }

    public static void main(String[] args) throws Exception {
        new TestTextOutputFormat().testFormat();
    }

    static {
        try {
            localFs = FileSystem.getLocal((Configuration)defaultConf);
        }
        catch (IOException e) {
            throw new RuntimeException("init failure", e);
        }
        attempt = "attempt_200707121733_0001_m_000000_0";
        workDir = new Path(new Path(new Path(System.getProperty("test.build.data", "."), "data"), "_temporary"), "_" + attempt);
    }
}

