/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.partition;

import java.util.Arrays;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.partition.InputSampler;
import org.apache.hadoop.mapreduce.lib.partition.TestInputSampler;
import org.junit.Assert;
import org.junit.Test;

public class TestInputSampler {
    @Test
    public void testSplitSampler() throws Exception {
        int TOT_SPLITS = 15;
        int NUM_SPLITS = 5;
        int STEP_SAMPLE = 5;
        int NUM_SAMPLES = 25;
        InputSampler.SplitSampler sampler = new InputSampler.SplitSampler(25, 5);
        int[] inits = new int[15];
        for (int i = 0; i < 15; ++i) {
            inits[i] = i * 5;
        }
        Job ignored = Job.getInstance();
        Object[] samples = sampler.getSample((InputFormat)new TestInputSamplerIF(100000, 15, inits), ignored);
        Assert.assertEquals((long)25L, (long)samples.length);
        Arrays.sort(samples, new IntWritable.Comparator());
        for (int i = 0; i < 25; ++i) {
            Assert.assertEquals((long)i, (long)((IntWritable)samples[i]).get());
        }
    }

    @Test
    public void testIntervalSampler() throws Exception {
        int TOT_SPLITS = 16;
        int PER_SPLIT_SAMPLE = 4;
        int NUM_SAMPLES = 64;
        double FREQ = 0.0625;
        InputSampler.IntervalSampler sampler = new InputSampler.IntervalSampler(0.0625, 64);
        int[] inits = new int[16];
        for (int i = 0; i < 16; ++i) {
            inits[i] = i;
        }
        Job ignored = Job.getInstance();
        Object[] samples = sampler.getSample((InputFormat)new TestInputSamplerIF(64, 16, inits), ignored);
        Assert.assertEquals((long)64L, (long)samples.length);
        Arrays.sort(samples, new IntWritable.Comparator());
        for (int i = 0; i < 64; ++i) {
            Assert.assertEquals((long)i, (long)((IntWritable)samples[i]).get());
        }
    }
}

