/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;

class TimelineEntityConverterV1 {
    private static final Log LOG = LogFactory.getLog(TimelineEntityConverterV1.class);
    static final String JOB = "MAPREDUCE_JOB";
    static final String TASK = "MAPREDUCE_TASK";
    static final String TASK_ATTEMPT = "MAPREDUCE_TASK_ATTEMPT";

    TimelineEntityConverterV1() {
    }

    public Set<TimelineEntity> createTimelineEntities(JobHistoryParser.JobInfo jobInfo, Configuration conf) {
        HashSet<TimelineEntity> entities = new HashSet<TimelineEntity>();
        TimelineEntity job = this.createJobEntity(jobInfo, conf);
        entities.add(job);
        Set<TimelineEntity> tasksAndAttempts = this.createTaskAndTaskAttemptEntities(jobInfo);
        entities.addAll(tasksAndAttempts);
        return entities;
    }

    private TimelineEntity createJobEntity(JobHistoryParser.JobInfo jobInfo, Configuration conf) {
        TimelineEntity job = new TimelineEntity();
        job.setEntityType(JOB);
        job.setEntityId(jobInfo.getJobId().toString());
        job.setStartTime(Long.valueOf(jobInfo.getSubmitTime()));
        job.addPrimaryFilter("JOBNAME", (Object)jobInfo.getJobname());
        job.addPrimaryFilter("USERNAME", (Object)jobInfo.getUsername());
        job.addOtherInfo("JOB_QUEUE_NAME", (Object)jobInfo.getJobQueueName());
        job.addOtherInfo("SUBMIT_TIME", (Object)jobInfo.getSubmitTime());
        job.addOtherInfo("LAUNCH_TIME", (Object)jobInfo.getLaunchTime());
        job.addOtherInfo("FINISH_TIME", (Object)jobInfo.getFinishTime());
        job.addOtherInfo("JOB_STATUS", (Object)jobInfo.getJobStatus());
        job.addOtherInfo("PRIORITY", (Object)jobInfo.getPriority());
        job.addOtherInfo("TOTAL_MAPS", (Object)jobInfo.getTotalMaps());
        job.addOtherInfo("TOTAL_REDUCES", (Object)jobInfo.getTotalReduces());
        job.addOtherInfo("UBERIZED", (Object)jobInfo.getUberized());
        job.addOtherInfo("ERROR_INFO", (Object)jobInfo.getErrorInfo());
        LOG.info((Object)("converted job " + jobInfo.getJobId() + " to a timeline entity"));
        return job;
    }

    private Set<TimelineEntity> createTaskAndTaskAttemptEntities(JobHistoryParser.JobInfo jobInfo) {
        HashSet<TimelineEntity> entities = new HashSet<TimelineEntity>();
        Map taskInfoMap = jobInfo.getAllTasks();
        LOG.info((Object)("job " + jobInfo.getJobId() + " has " + taskInfoMap.size() + " tasks"));
        for (JobHistoryParser.TaskInfo taskInfo : taskInfoMap.values()) {
            TimelineEntity task = this.createTaskEntity(taskInfo);
            entities.add(task);
            Set<TimelineEntity> taskAttempts = this.createTaskAttemptEntities(taskInfo);
            entities.addAll(taskAttempts);
        }
        return entities;
    }

    private TimelineEntity createTaskEntity(JobHistoryParser.TaskInfo taskInfo) {
        TimelineEntity task = new TimelineEntity();
        task.setEntityType(TASK);
        task.setEntityId(taskInfo.getTaskId().toString());
        task.setStartTime(Long.valueOf(taskInfo.getStartTime()));
        task.addOtherInfo("START_TIME", (Object)taskInfo.getStartTime());
        task.addOtherInfo("FINISH_TIME", (Object)taskInfo.getFinishTime());
        task.addOtherInfo("TASK_TYPE", (Object)taskInfo.getTaskType());
        task.addOtherInfo("TASK_STATUS", (Object)taskInfo.getTaskStatus());
        task.addOtherInfo("ERROR_INFO", (Object)taskInfo.getError());
        LOG.info((Object)("converted task " + taskInfo.getTaskId() + " to a timeline entity"));
        return task;
    }

    private Set<TimelineEntity> createTaskAttemptEntities(JobHistoryParser.TaskInfo taskInfo) {
        HashSet<TimelineEntity> taskAttempts = new HashSet<TimelineEntity>();
        Map taskAttemptInfoMap = taskInfo.getAllTaskAttempts();
        LOG.info((Object)("task " + taskInfo.getTaskId() + " has " + taskAttemptInfoMap.size() + " task attempts"));
        for (JobHistoryParser.TaskAttemptInfo taskAttemptInfo : taskAttemptInfoMap.values()) {
            TimelineEntity taskAttempt = this.createTaskAttemptEntity(taskAttemptInfo);
            taskAttempts.add(taskAttempt);
        }
        return taskAttempts;
    }

    private TimelineEntity createTaskAttemptEntity(JobHistoryParser.TaskAttemptInfo taskAttemptInfo) {
        TimelineEntity taskAttempt = new TimelineEntity();
        taskAttempt.setEntityType(TASK_ATTEMPT);
        taskAttempt.setEntityId(taskAttemptInfo.getAttemptId().toString());
        taskAttempt.setStartTime(Long.valueOf(taskAttemptInfo.getStartTime()));
        taskAttempt.addOtherInfo("START_TIME", (Object)taskAttemptInfo.getStartTime());
        taskAttempt.addOtherInfo("FINISH_TIME", (Object)taskAttemptInfo.getFinishTime());
        taskAttempt.addOtherInfo("MAP_FINISH_TIME", (Object)taskAttemptInfo.getMapFinishTime());
        taskAttempt.addOtherInfo("SHUFFLE_FINISH_TIME", (Object)taskAttemptInfo.getShuffleFinishTime());
        taskAttempt.addOtherInfo("SORT_FINISH_TIME", (Object)taskAttemptInfo.getSortFinishTime());
        taskAttempt.addOtherInfo("TASK_STATUS", (Object)taskAttemptInfo.getTaskStatus());
        taskAttempt.addOtherInfo("STATE", (Object)taskAttemptInfo.getState());
        taskAttempt.addOtherInfo("ERROR", (Object)taskAttemptInfo.getError());
        taskAttempt.addOtherInfo("CONTAINER_ID", (Object)taskAttemptInfo.getContainerId().toString());
        LOG.info((Object)("converted task attempt " + taskAttemptInfo.getAttemptId() + " to a timeline entity"));
        return taskAttempt;
    }
}

