/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.jobcontrol;

import java.util.ArrayList;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.jobcontrol.Job;
import org.apache.hadoop.mapred.jobcontrol.JobControl;
import org.apache.hadoop.mapred.jobcontrol.JobControlTestUtils;
import org.apache.hadoop.mapreduce.lib.jobcontrol.ControlledJob;
import org.junit.Test;
import org.mockito.Mockito;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestJobControl
extends TestCase {
    public static void doJobControlTest() throws Exception {
        Configuration defaults = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)defaults);
        Path rootDataDir = new Path(System.getProperty("test.build.data", "."), "TestJobControlData");
        Path indir = new Path(rootDataDir, "indir");
        Path outdir_1 = new Path(rootDataDir, "outdir_1");
        Path outdir_2 = new Path(rootDataDir, "outdir_2");
        Path outdir_3 = new Path(rootDataDir, "outdir_3");
        Path outdir_4 = new Path(rootDataDir, "outdir_4");
        JobControlTestUtils.cleanData((FileSystem)fs, (Path)indir);
        JobControlTestUtils.generateData((FileSystem)fs, (Path)indir);
        JobControlTestUtils.cleanData((FileSystem)fs, (Path)outdir_1);
        JobControlTestUtils.cleanData((FileSystem)fs, (Path)outdir_2);
        JobControlTestUtils.cleanData((FileSystem)fs, (Path)outdir_3);
        JobControlTestUtils.cleanData((FileSystem)fs, (Path)outdir_4);
        ArrayList<Job> dependingJobs = null;
        ArrayList<Path> inPaths_1 = new ArrayList<Path>();
        inPaths_1.add(indir);
        JobConf jobConf_1 = JobControlTestUtils.createCopyJob(inPaths_1, (Path)outdir_1);
        Job job_1 = new Job(jobConf_1, dependingJobs);
        ArrayList<Path> inPaths_2 = new ArrayList<Path>();
        inPaths_2.add(indir);
        JobConf jobConf_2 = JobControlTestUtils.createCopyJob(inPaths_2, (Path)outdir_2);
        Job job_2 = new Job(jobConf_2, dependingJobs);
        ArrayList<Path> inPaths_3 = new ArrayList<Path>();
        inPaths_3.add(outdir_1);
        inPaths_3.add(outdir_2);
        JobConf jobConf_3 = JobControlTestUtils.createCopyJob(inPaths_3, (Path)outdir_3);
        dependingJobs = new ArrayList<Job>();
        dependingJobs.add(job_1);
        dependingJobs.add(job_2);
        Job job_3 = new Job(jobConf_3, dependingJobs);
        ArrayList<Path> inPaths_4 = new ArrayList<Path>();
        inPaths_4.add(outdir_3);
        JobConf jobConf_4 = JobControlTestUtils.createCopyJob(inPaths_4, (Path)outdir_4);
        dependingJobs = new ArrayList();
        dependingJobs.add(job_3);
        Job job_4 = new Job(jobConf_4, dependingJobs);
        JobControl theControl = new JobControl("Test");
        theControl.addJob((ControlledJob)job_1);
        theControl.addJob((ControlledJob)job_2);
        theControl.addJob(job_3);
        theControl.addJob(job_4);
        Thread theController = new Thread((Runnable)theControl);
        theController.start();
        while (!theControl.allFinished()) {
            System.out.println("Jobs in waiting state: " + theControl.getWaitingJobs().size());
            System.out.println("Jobs in ready state: " + theControl.getReadyJobs().size());
            System.out.println("Jobs in running state: " + theControl.getRunningJobs().size());
            System.out.println("Jobs in success state: " + theControl.getSuccessfulJobs().size());
            System.out.println("Jobs in failed state: " + theControl.getFailedJobs().size());
            System.out.println("\n");
            try {
                Thread.sleep(5000L);
            }
            catch (Exception e) {}
        }
        System.out.println("Jobs are all done???");
        System.out.println("Jobs in waiting state: " + theControl.getWaitingJobs().size());
        System.out.println("Jobs in ready state: " + theControl.getReadyJobs().size());
        System.out.println("Jobs in running state: " + theControl.getRunningJobs().size());
        System.out.println("Jobs in success state: " + theControl.getSuccessfulJobs().size());
        System.out.println("Jobs in failed state: " + theControl.getFailedJobs().size());
        System.out.println("\n");
        if (job_1.getState() != 4 && job_1.getState() != 5 && job_1.getState() != 0) {
            String states = "job_1:  " + job_1.getState() + "\n";
            throw new Exception("The state of job_1 is not in a complete state\n" + states);
        }
        if (job_2.getState() != 4 && job_2.getState() != 5 && job_2.getState() != 0) {
            String states = "job_2:  " + job_2.getState() + "\n";
            throw new Exception("The state of job_2 is not in a complete state\n" + states);
        }
        if (job_3.getState() != 4 && job_3.getState() != 5 && job_3.getState() != 0) {
            String states = "job_3:  " + job_3.getState() + "\n";
            throw new Exception("The state of job_3 is not in a complete state\n" + states);
        }
        if (job_4.getState() != 4 && job_4.getState() != 5 && job_4.getState() != 0) {
            String states = "job_4:  " + job_4.getState() + "\n";
            throw new Exception("The state of job_4 is not in a complete state\n" + states);
        }
        if ((job_1.getState() == 4 || job_2.getState() == 4 || job_1.getState() == 5 || job_2.getState() == 5) && job_3.getState() != 5) {
            String states = "job_1:  " + job_1.getState() + "\n";
            states = "job_2:  " + job_2.getState() + "\n";
            states = "job_3:  " + job_3.getState() + "\n";
            states = "job_4:  " + job_4.getState() + "\n";
            throw new Exception("The states of jobs 1, 2, 3, 4 are not consistent\n" + states);
        }
        if ((job_3.getState() == 4 || job_3.getState() == 5) && job_4.getState() != 5) {
            String states = "job_3:  " + job_3.getState() + "\n";
            states = "job_4:  " + job_4.getState() + "\n";
            throw new Exception("The states of jobs 3, 4 are not consistent\n" + states);
        }
        theControl.stop();
    }

    @Test(timeout=30000L)
    public void testJobState() throws Exception {
        Job job_1 = this.getCopyJob();
        JobControl jc = new JobControl("Test");
        jc.addJob(job_1);
        Assert.assertEquals((int)1, (int)job_1.getState());
        job_1.setState(0);
        Assert.assertEquals((int)1, (int)job_1.getState());
        org.apache.hadoop.mapreduce.Job mockjob = (org.apache.hadoop.mapreduce.Job)Mockito.mock(org.apache.hadoop.mapreduce.Job.class);
        org.apache.hadoop.mapreduce.JobID jid = new org.apache.hadoop.mapreduce.JobID("test", 0);
        Mockito.when((Object)mockjob.getJobID()).thenReturn((Object)jid);
        job_1.setJob(mockjob);
        Assert.assertEquals((String)"job_test_0000", (String)job_1.getMapredJobID());
        job_1.setMapredJobID("job_test_0001");
        Assert.assertEquals((String)"job_test_0000", (String)job_1.getMapredJobID());
        jc.stop();
    }

    @Test(timeout=30000L)
    public void testAddingDependingJob() throws Exception {
        Job job_1 = this.getCopyJob();
        ArrayList dependingJobs = new ArrayList();
        JobControl jc = new JobControl("Test");
        jc.addJob(job_1);
        Assert.assertEquals((int)1, (int)job_1.getState());
        Assert.assertTrue((boolean)job_1.addDependingJob(new Job(job_1.getJobConf(), dependingJobs)));
    }

    public Job getCopyJob() throws Exception {
        Configuration defaults = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)defaults);
        Path rootDataDir = new Path(System.getProperty("test.build.data", "."), "TestJobControlData");
        Path indir = new Path(rootDataDir, "indir");
        Path outdir_1 = new Path(rootDataDir, "outdir_1");
        JobControlTestUtils.cleanData((FileSystem)fs, (Path)indir);
        JobControlTestUtils.generateData((FileSystem)fs, (Path)indir);
        JobControlTestUtils.cleanData((FileSystem)fs, (Path)outdir_1);
        ArrayList dependingJobs = null;
        ArrayList<Path> inPaths_1 = new ArrayList<Path>();
        inPaths_1.add(indir);
        JobConf jobConf_1 = JobControlTestUtils.createCopyJob(inPaths_1, (Path)outdir_1);
        Job job_1 = new Job(jobConf_1, dependingJobs);
        return job_1;
    }

    @Test(timeout=30000L)
    public void testJobControl() throws Exception {
        TestJobControl.doJobControlTest();
    }

    @Test(timeout=30000L)
    public void testGetAssignedJobId() throws Exception {
        JobConf jc = new JobConf();
        Job j = new Job(jc);
        TestJobControl.assertNull((Object)j.getAssignedJobID());
        org.apache.hadoop.mapreduce.Job mockjob = (org.apache.hadoop.mapreduce.Job)Mockito.mock(org.apache.hadoop.mapreduce.Job.class);
        org.apache.hadoop.mapreduce.JobID jid = new org.apache.hadoop.mapreduce.JobID("test", 0);
        Mockito.when((Object)mockjob.getJobID()).thenReturn((Object)jid);
        j.setJob(mockjob);
        JobID expected = new JobID("test", 0);
        TestJobControl.assertEquals((Object)expected, (Object)j.getAssignedJobID());
        ((org.apache.hadoop.mapreduce.Job)Mockito.verify((Object)mockjob)).getJobID();
    }

    public static void main(String[] args) {
        TestJobControl test = new TestJobControl();
        try {
            test.testJobControl();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

