/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import java.io.IOException;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.KeyValueTextInputFormat;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.lib.MultipleInputs;

public class TestMultipleInputs
extends TestCase {
    public void testAddInputPathWithFormat() {
        JobConf conf = new JobConf();
        MultipleInputs.addInputPath((JobConf)conf, (Path)new Path("/foo"), TextInputFormat.class);
        MultipleInputs.addInputPath((JobConf)conf, (Path)new Path("/bar"), KeyValueTextInputFormat.class);
        Map inputs = MultipleInputs.getInputFormatMap((JobConf)conf);
        TestMultipleInputs.assertEquals(TextInputFormat.class, ((InputFormat)inputs.get(new Path("/foo"))).getClass());
        TestMultipleInputs.assertEquals(KeyValueTextInputFormat.class, ((InputFormat)inputs.get(new Path("/bar"))).getClass());
    }

    public void testAddInputPathWithMapper() {
        JobConf conf = new JobConf();
        MultipleInputs.addInputPath((JobConf)conf, (Path)new Path("/foo"), TextInputFormat.class, MapClass.class);
        MultipleInputs.addInputPath((JobConf)conf, (Path)new Path("/bar"), KeyValueTextInputFormat.class, MapClass2.class);
        Map inputs = MultipleInputs.getInputFormatMap((JobConf)conf);
        Map maps = MultipleInputs.getMapperTypeMap((JobConf)conf);
        TestMultipleInputs.assertEquals(TextInputFormat.class, ((InputFormat)inputs.get(new Path("/foo"))).getClass());
        TestMultipleInputs.assertEquals(KeyValueTextInputFormat.class, ((InputFormat)inputs.get(new Path("/bar"))).getClass());
        TestMultipleInputs.assertEquals(MapClass.class, maps.get(new Path("/foo")));
        TestMultipleInputs.assertEquals(MapClass2.class, maps.get(new Path("/bar")));
    }

    static class MapClass2
    extends MapClass {
        MapClass2() {
        }
    }

    static class MapClass
    implements Mapper<String, String, String, String> {
        MapClass() {
        }

        public void map(String key, String value, OutputCollector<String, String> output, Reporter reporter) throws IOException {
        }

        public void configure(JobConf job) {
        }

        public void close() throws IOException {
        }
    }
}

