/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.ClientCache;
import org.apache.hadoop.mapred.ClientServiceDelegate;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Master;
import org.apache.hadoop.mapred.ResourceMgrDelegate;
import org.apache.hadoop.mapred.YARNRunner;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobPriority;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.MRClientProtocol;
import org.apache.hadoop.mapreduce.v2.api.MRDelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.client.api.impl.YarnClientImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.util.Records;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.WriterAppender;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestYARNRunner
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestYARNRunner.class);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private YARNRunner yarnRunner;
    private ResourceMgrDelegate resourceMgrDelegate;
    private YarnConfiguration conf;
    private ClientCache clientCache;
    private ApplicationId appId;
    private JobID jobId;
    private File testWorkDir = new File("target", TestYARNRunner.class.getName());
    private ApplicationSubmissionContext submissionContext;
    private ClientServiceDelegate clientDelegate;
    private static final String failString = "Rejected job";

    @Before
    public void setUp() throws Exception {
        this.resourceMgrDelegate = (ResourceMgrDelegate)Mockito.mock(ResourceMgrDelegate.class);
        this.conf = new YarnConfiguration();
        this.conf.set("yarn.resourcemanager.principal", "mapred/host@REALM");
        this.clientCache = new ClientCache((Configuration)this.conf, this.resourceMgrDelegate);
        this.clientCache = (ClientCache)Mockito.spy((Object)this.clientCache);
        this.yarnRunner = new YARNRunner((Configuration)this.conf, this.resourceMgrDelegate, this.clientCache);
        this.yarnRunner = (YARNRunner)Mockito.spy((Object)this.yarnRunner);
        this.submissionContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        ((YARNRunner)Mockito.doAnswer((Answer)new Answer<ApplicationSubmissionContext>(){

            public ApplicationSubmissionContext answer(InvocationOnMock invocation) throws Throwable {
                return TestYARNRunner.this.submissionContext;
            }
        }).when((Object)this.yarnRunner)).createApplicationSubmissionContext((Configuration)Matchers.any(Configuration.class), (String)Matchers.any(String.class), (Credentials)Matchers.any(Credentials.class));
        this.appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        this.jobId = TypeConverter.fromYarn((ApplicationId)this.appId);
        if (this.testWorkDir.exists()) {
            FileContext.getLocalFSFileContext().delete(new Path(this.testWorkDir.toString()), true);
        }
        this.testWorkDir.mkdirs();
    }

    @Test(timeout=20000L)
    public void testJobKill() throws Exception {
        this.clientDelegate = (ClientServiceDelegate)Mockito.mock(ClientServiceDelegate.class);
        Mockito.when((Object)this.clientDelegate.getJobStatus((JobID)Matchers.any(JobID.class))).thenReturn((Object)new JobStatus(this.jobId, 0.0f, 0.0f, 0.0f, 0.0f, JobStatus.State.PREP, JobPriority.HIGH, "tmp", "tmp", "tmp", "tmp"));
        Mockito.when((Object)this.clientDelegate.killJob((JobID)Matchers.any(JobID.class))).thenReturn((Object)true);
        ((ClientCache)Mockito.doAnswer((Answer)new Answer<ClientServiceDelegate>(){

            public ClientServiceDelegate answer(InvocationOnMock invocation) throws Throwable {
                return TestYARNRunner.this.clientDelegate;
            }
        }).when((Object)this.clientCache)).getClient((JobID)Matchers.any(JobID.class));
        this.yarnRunner.killJob(this.jobId);
        ((ResourceMgrDelegate)Mockito.verify((Object)this.resourceMgrDelegate)).killApplication(this.appId);
        Mockito.when((Object)this.clientDelegate.getJobStatus((JobID)Matchers.any(JobID.class))).thenReturn((Object)new JobStatus(this.jobId, 0.0f, 0.0f, 0.0f, 0.0f, JobStatus.State.RUNNING, JobPriority.HIGH, "tmp", "tmp", "tmp", "tmp"));
        this.yarnRunner.killJob(this.jobId);
        ((ClientServiceDelegate)Mockito.verify((Object)this.clientDelegate)).killJob(this.jobId);
    }

    @Test(timeout=20000L)
    public void testJobSubmissionFailure() throws Exception {
        Mockito.when((Object)this.resourceMgrDelegate.submitApplication((ApplicationSubmissionContext)Matchers.any(ApplicationSubmissionContext.class))).thenReturn((Object)this.appId);
        ApplicationReport report = (ApplicationReport)Mockito.mock(ApplicationReport.class);
        Mockito.when((Object)report.getApplicationId()).thenReturn((Object)this.appId);
        Mockito.when((Object)report.getDiagnostics()).thenReturn((Object)failString);
        Mockito.when((Object)report.getYarnApplicationState()).thenReturn((Object)YarnApplicationState.FAILED);
        Mockito.when((Object)this.resourceMgrDelegate.getApplicationReport(this.appId)).thenReturn((Object)report);
        Credentials credentials = new Credentials();
        File jobxml = new File(this.testWorkDir, "job.xml");
        FileOutputStream out = new FileOutputStream(jobxml);
        this.conf.writeXml((OutputStream)out);
        ((OutputStream)out).close();
        try {
            this.yarnRunner.submitJob(this.jobId, this.testWorkDir.getAbsolutePath().toString(), credentials);
        }
        catch (IOException io) {
            LOG.info((Object)"Logging exception:", (Throwable)io);
            TestYARNRunner.assertTrue((boolean)io.getLocalizedMessage().contains(failString));
        }
    }

    @Test(timeout=20000L)
    public void testResourceMgrDelegate() throws Exception {
        final ApplicationClientProtocol clientRMProtocol = (ApplicationClientProtocol)Mockito.mock(ApplicationClientProtocol.class);
        ResourceMgrDelegate delegate = new ResourceMgrDelegate(this.conf){

            protected void serviceStart() throws Exception {
                TestCase.assertTrue((boolean)(this.client instanceof YarnClientImpl));
                ((YarnClientImpl)this.client).setRMClient(clientRMProtocol);
            }
        };
        Mockito.when((Object)clientRMProtocol.forceKillApplication((KillApplicationRequest)Matchers.any(KillApplicationRequest.class))).thenReturn((Object)KillApplicationResponse.newInstance((boolean)true));
        delegate.killApplication(this.appId);
        ((ApplicationClientProtocol)Mockito.verify((Object)clientRMProtocol)).forceKillApplication((KillApplicationRequest)Matchers.any(KillApplicationRequest.class));
        Mockito.when((Object)clientRMProtocol.getApplications((GetApplicationsRequest)Matchers.any(GetApplicationsRequest.class))).thenReturn(recordFactory.newRecordInstance(GetApplicationsResponse.class));
        delegate.getAllJobs();
        ((ApplicationClientProtocol)Mockito.verify((Object)clientRMProtocol)).getApplications((GetApplicationsRequest)Matchers.any(GetApplicationsRequest.class));
        Mockito.when((Object)clientRMProtocol.getApplicationReport((GetApplicationReportRequest)Matchers.any(GetApplicationReportRequest.class))).thenReturn(recordFactory.newRecordInstance(GetApplicationReportResponse.class));
        delegate.getApplicationReport(this.appId);
        ((ApplicationClientProtocol)Mockito.verify((Object)clientRMProtocol)).getApplicationReport((GetApplicationReportRequest)Matchers.any(GetApplicationReportRequest.class));
        GetClusterMetricsResponse clusterMetricsResponse = (GetClusterMetricsResponse)recordFactory.newRecordInstance(GetClusterMetricsResponse.class);
        clusterMetricsResponse.setClusterMetrics((YarnClusterMetrics)recordFactory.newRecordInstance(YarnClusterMetrics.class));
        Mockito.when((Object)clientRMProtocol.getClusterMetrics((GetClusterMetricsRequest)Matchers.any(GetClusterMetricsRequest.class))).thenReturn((Object)clusterMetricsResponse);
        delegate.getClusterMetrics();
        ((ApplicationClientProtocol)Mockito.verify((Object)clientRMProtocol)).getClusterMetrics((GetClusterMetricsRequest)Matchers.any(GetClusterMetricsRequest.class));
        Mockito.when((Object)clientRMProtocol.getClusterNodes((GetClusterNodesRequest)Matchers.any(GetClusterNodesRequest.class))).thenReturn(recordFactory.newRecordInstance(GetClusterNodesResponse.class));
        delegate.getActiveTrackers();
        ((ApplicationClientProtocol)Mockito.verify((Object)clientRMProtocol)).getClusterNodes((GetClusterNodesRequest)Matchers.any(GetClusterNodesRequest.class));
        GetNewApplicationResponse newAppResponse = (GetNewApplicationResponse)recordFactory.newRecordInstance(GetNewApplicationResponse.class);
        newAppResponse.setApplicationId(this.appId);
        Mockito.when((Object)clientRMProtocol.getNewApplication((GetNewApplicationRequest)Matchers.any(GetNewApplicationRequest.class))).thenReturn((Object)newAppResponse);
        delegate.getNewJobID();
        ((ApplicationClientProtocol)Mockito.verify((Object)clientRMProtocol)).getNewApplication((GetNewApplicationRequest)Matchers.any(GetNewApplicationRequest.class));
        GetQueueInfoResponse queueInfoResponse = (GetQueueInfoResponse)recordFactory.newRecordInstance(GetQueueInfoResponse.class);
        queueInfoResponse.setQueueInfo((QueueInfo)recordFactory.newRecordInstance(QueueInfo.class));
        Mockito.when((Object)clientRMProtocol.getQueueInfo((GetQueueInfoRequest)Matchers.any(GetQueueInfoRequest.class))).thenReturn((Object)queueInfoResponse);
        delegate.getQueues();
        ((ApplicationClientProtocol)Mockito.verify((Object)clientRMProtocol)).getQueueInfo((GetQueueInfoRequest)Matchers.any(GetQueueInfoRequest.class));
        GetQueueUserAclsInfoResponse aclResponse = (GetQueueUserAclsInfoResponse)recordFactory.newRecordInstance(GetQueueUserAclsInfoResponse.class);
        Mockito.when((Object)clientRMProtocol.getQueueUserAcls((GetQueueUserAclsInfoRequest)Matchers.any(GetQueueUserAclsInfoRequest.class))).thenReturn((Object)aclResponse);
        delegate.getQueueAclsForCurrentUser();
        ((ApplicationClientProtocol)Mockito.verify((Object)clientRMProtocol)).getQueueUserAcls((GetQueueUserAclsInfoRequest)Matchers.any(GetQueueUserAclsInfoRequest.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testGetHSDelegationToken() throws Exception {
        try {
            Configuration conf = new Configuration();
            InetSocketAddress mockRmAddress = new InetSocketAddress("localhost", 4444);
            Text rmTokenSevice = SecurityUtil.buildTokenService((InetSocketAddress)mockRmAddress);
            InetSocketAddress mockHsAddress = new InetSocketAddress("localhost", 9200);
            Text hsTokenSevice = SecurityUtil.buildTokenService((InetSocketAddress)mockHsAddress);
            RMDelegationTokenIdentifier tokenIdentifier = new RMDelegationTokenIdentifier(new Text("owner"), new Text("renewer"), new Text("real"));
            Token token = new Token(new byte[0], new byte[0], tokenIdentifier.getKind(), rmTokenSevice);
            token.setKind(RMDelegationTokenIdentifier.KIND_NAME);
            org.apache.hadoop.yarn.api.records.Token historyToken = org.apache.hadoop.yarn.api.records.Token.newInstance((byte[])new byte[0], (String)MRDelegationTokenIdentifier.KIND_NAME.toString(), (byte[])new byte[0], (String)hsTokenSevice.toString());
            GetDelegationTokenResponse getDtResponse = (GetDelegationTokenResponse)Records.newRecord(GetDelegationTokenResponse.class);
            getDtResponse.setDelegationToken(historyToken);
            MRClientProtocol mockHsProxy = (MRClientProtocol)Mockito.mock(MRClientProtocol.class);
            ((MRClientProtocol)Mockito.doReturn((Object)mockHsAddress).when((Object)mockHsProxy)).getConnectAddress();
            ((MRClientProtocol)Mockito.doReturn((Object)getDtResponse).when((Object)mockHsProxy)).getDelegationToken((GetDelegationTokenRequest)Matchers.any(GetDelegationTokenRequest.class));
            ResourceMgrDelegate rmDelegate = (ResourceMgrDelegate)Mockito.mock(ResourceMgrDelegate.class);
            ((ResourceMgrDelegate)Mockito.doReturn((Object)rmTokenSevice).when((Object)rmDelegate)).getRMDelegationTokenService();
            ClientCache clientCache = (ClientCache)Mockito.mock(ClientCache.class);
            ((ClientCache)Mockito.doReturn((Object)mockHsProxy).when((Object)clientCache)).getInitializedHSProxy();
            Credentials creds = new Credentials();
            YARNRunner yarnRunner = new YARNRunner(conf, rmDelegate, clientCache);
            yarnRunner.addHistoryToken(creds);
            ((MRClientProtocol)Mockito.verify((Object)mockHsProxy, (VerificationMode)Mockito.times((int)0))).getDelegationToken((GetDelegationTokenRequest)Matchers.any(GetDelegationTokenRequest.class));
            creds.addToken(new Text("rmdt"), token);
            yarnRunner.addHistoryToken(creds);
            ((MRClientProtocol)Mockito.verify((Object)mockHsProxy, (VerificationMode)Mockito.times((int)0))).getDelegationToken((GetDelegationTokenRequest)Matchers.any(GetDelegationTokenRequest.class));
            conf.set("hadoop.security.authentication", "kerberos");
            UserGroupInformation.setConfiguration((Configuration)conf);
            creds = new Credentials();
            yarnRunner.addHistoryToken(creds);
            ((MRClientProtocol)Mockito.verify((Object)mockHsProxy, (VerificationMode)Mockito.times((int)0))).getDelegationToken((GetDelegationTokenRequest)Matchers.any(GetDelegationTokenRequest.class));
            creds.addToken(new Text("rmdt"), token);
            yarnRunner.addHistoryToken(creds);
            ((MRClientProtocol)Mockito.verify((Object)mockHsProxy, (VerificationMode)Mockito.times((int)1))).getDelegationToken((GetDelegationTokenRequest)Matchers.any(GetDelegationTokenRequest.class));
            yarnRunner.addHistoryToken(creds);
            ((MRClientProtocol)Mockito.verify((Object)mockHsProxy, (VerificationMode)Mockito.times((int)1))).getDelegationToken((GetDelegationTokenRequest)Matchers.any(GetDelegationTokenRequest.class));
        }
        finally {
            UserGroupInformation.setConfiguration((Configuration)new Configuration());
        }
    }

    @Test(timeout=20000L)
    public void testHistoryServerToken() throws Exception {
        this.conf.set("yarn.resourcemanager.principal", "foo@LOCAL");
        final String masterPrincipal = Master.getMasterPrincipal((Configuration)this.conf);
        final MRClientProtocol hsProxy = (MRClientProtocol)Mockito.mock(MRClientProtocol.class);
        Mockito.when((Object)hsProxy.getDelegationToken((GetDelegationTokenRequest)Matchers.any(GetDelegationTokenRequest.class))).thenAnswer((Answer)new Answer<GetDelegationTokenResponse>(){

            public GetDelegationTokenResponse answer(InvocationOnMock invocation) {
                GetDelegationTokenRequest request = (GetDelegationTokenRequest)invocation.getArguments()[0];
                TestCase.assertEquals((String)masterPrincipal, (String)request.getRenewer());
                org.apache.hadoop.yarn.api.records.Token token = (org.apache.hadoop.yarn.api.records.Token)recordFactory.newRecordInstance(org.apache.hadoop.yarn.api.records.Token.class);
                token.setKind("");
                token.setService("");
                token.setIdentifier(ByteBuffer.allocate(0));
                token.setPassword(ByteBuffer.allocate(0));
                GetDelegationTokenResponse tokenResponse = (GetDelegationTokenResponse)recordFactory.newRecordInstance(GetDelegationTokenResponse.class);
                tokenResponse.setDelegationToken(token);
                return tokenResponse;
            }
        });
        UserGroupInformation.createRemoteUser((String)"someone").doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TestYARNRunner.this.yarnRunner = new YARNRunner((Configuration)TestYARNRunner.this.conf, null, null);
                TestYARNRunner.this.yarnRunner.getDelegationTokenFromHS(hsProxy);
                ((MRClientProtocol)Mockito.verify((Object)hsProxy)).getDelegationToken((GetDelegationTokenRequest)Matchers.any(GetDelegationTokenRequest.class));
                return null;
            }
        });
    }

    @Test(timeout=20000L)
    public void testAMAdminCommandOpts() throws Exception {
        JobConf jobConf = new JobConf();
        jobConf.set("yarn.app.mapreduce.am.admin-command-opts", "-Djava.net.preferIPv4Stack=true");
        jobConf.set("yarn.app.mapreduce.am.command-opts", "-Xmx1024m");
        YARNRunner yarnRunner = new YARNRunner((Configuration)jobConf);
        File jobxml = new File(this.testWorkDir, "job.xml");
        FileOutputStream out = new FileOutputStream(jobxml);
        this.conf.writeXml((OutputStream)out);
        ((OutputStream)out).close();
        File jobsplit = new File(this.testWorkDir, "job.split");
        out = new FileOutputStream(jobsplit);
        ((OutputStream)out).close();
        File jobsplitmetainfo = new File(this.testWorkDir, "job.splitmetainfo");
        out = new FileOutputStream(jobsplitmetainfo);
        ((OutputStream)out).close();
        ApplicationSubmissionContext submissionContext = yarnRunner.createApplicationSubmissionContext((Configuration)jobConf, this.testWorkDir.toString(), new Credentials());
        ContainerLaunchContext containerSpec = submissionContext.getAMContainerSpec();
        List commands = containerSpec.getCommands();
        int index = 0;
        int adminIndex = 0;
        int adminPos = -1;
        int userIndex = 0;
        int userPos = -1;
        for (String command : commands) {
            if (command != null) {
                adminPos = command.indexOf("-Djava.net.preferIPv4Stack=true");
                if (adminPos >= 0) {
                    adminIndex = index;
                }
                if ((userPos = command.indexOf("-Xmx1024m")) >= 0) {
                    userIndex = index;
                }
            }
            ++index;
        }
        TestYARNRunner.assertTrue((String)"AM admin command opts not in the commands.", (adminPos > 0 ? 1 : 0) != 0);
        TestYARNRunner.assertTrue((String)"AM user command opts not in the commands.", (userPos > 0 ? 1 : 0) != 0);
        if (adminIndex == userIndex) {
            TestYARNRunner.assertTrue((String)"AM admin command opts is after user command opts.", (adminPos < userPos ? 1 : 0) != 0);
        } else {
            TestYARNRunner.assertTrue((String)"AM admin command opts is after user command opts.", (adminIndex < userIndex ? 1 : 0) != 0);
        }
    }

    @Test(timeout=20000L)
    public void testWarnCommandOpts() throws Exception {
        Logger logger = Logger.getLogger(YARNRunner.class);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        SimpleLayout layout = new SimpleLayout();
        WriterAppender appender = new WriterAppender((Layout)layout, (OutputStream)bout);
        logger.addAppender((Appender)appender);
        JobConf jobConf = new JobConf();
        jobConf.set("yarn.app.mapreduce.am.admin-command-opts", "-Djava.net.preferIPv4Stack=true -Djava.library.path=foo");
        jobConf.set("yarn.app.mapreduce.am.command-opts", "-Xmx1024m -Djava.library.path=bar");
        YARNRunner yarnRunner = new YARNRunner((Configuration)jobConf);
        File jobxml = new File(this.testWorkDir, "job.xml");
        FileOutputStream out = new FileOutputStream(jobxml);
        this.conf.writeXml((OutputStream)out);
        ((OutputStream)out).close();
        File jobsplit = new File(this.testWorkDir, "job.split");
        out = new FileOutputStream(jobsplit);
        ((OutputStream)out).close();
        File jobsplitmetainfo = new File(this.testWorkDir, "job.splitmetainfo");
        out = new FileOutputStream(jobsplitmetainfo);
        ((OutputStream)out).close();
        ApplicationSubmissionContext submissionContext = yarnRunner.createApplicationSubmissionContext((Configuration)jobConf, this.testWorkDir.toString(), new Credentials());
        String logMsg = bout.toString();
        TestYARNRunner.assertTrue((boolean)logMsg.contains("WARN - Usage of -Djava.library.path in yarn.app.mapreduce.am.admin-command-opts can cause programs to no longer function if hadoop native libraries are used. These values should be set as part of the LD_LIBRARY_PATH in the app master JVM env using yarn.app.mapreduce.am.admin.user.env config settings."));
        TestYARNRunner.assertTrue((boolean)logMsg.contains("WARN - Usage of -Djava.library.path in yarn.app.mapreduce.am.command-opts can cause programs to no longer function if hadoop native libraries are used. These values should be set as part of the LD_LIBRARY_PATH in the app master JVM env using yarn.app.mapreduce.am.env config settings."));
    }
}

