/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.aggregate;

import java.text.NumberFormat;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.lib.aggregate.ValueAggregatorCombiner;
import org.apache.hadoop.mapreduce.lib.aggregate.ValueAggregatorMapper;
import org.apache.hadoop.mapreduce.lib.aggregate.ValueAggregatorReducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;

public class TestMapReduceAggregates
extends TestCase {
    private static NumberFormat idFormat = NumberFormat.getInstance();

    public void testAggregates() throws Exception {
        TestMapReduceAggregates.launch();
    }

    public static void launch() throws Exception {
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        int numOfInputLines = 20;
        Path OUTPUT_DIR = new Path("build/test/output_for_aggregates_test");
        Path INPUT_DIR = new Path("build/test/input_for_aggregates_test");
        String inputFile = "input.txt";
        fs.delete(INPUT_DIR, true);
        fs.mkdirs(INPUT_DIR);
        fs.delete(OUTPUT_DIR, true);
        StringBuffer inputData = new StringBuffer();
        StringBuffer expectedOutput = new StringBuffer();
        expectedOutput.append("max\t19\n");
        expectedOutput.append("min\t1\n");
        FSDataOutputStream fileOut = fs.create(new Path(INPUT_DIR, inputFile));
        for (int i = 1; i < numOfInputLines; ++i) {
            expectedOutput.append("count_").append(idFormat.format(i));
            expectedOutput.append("\t").append(i).append("\n");
            inputData.append(idFormat.format(i));
            for (int j = 1; j < i; ++j) {
                inputData.append(" ").append(idFormat.format(i));
            }
            inputData.append("\n");
        }
        expectedOutput.append("value_as_string_max\t9\n");
        expectedOutput.append("value_as_string_min\t1\n");
        expectedOutput.append("uniq_count\t15\n");
        fileOut.write(inputData.toString().getBytes("utf-8"));
        fileOut.close();
        System.out.println("inputData:");
        System.out.println(inputData.toString());
        conf.setInt("mapreduce.aggregate.descriptor.num", 1);
        conf.set("mapreduce.aggregate.descriptor.0", "UserDefined,org.apache.hadoop.mapreduce.lib.aggregate.AggregatorTests");
        conf.setLong("mapreduce.aggregate.max.num.unique.values", 14L);
        Job job = Job.getInstance((Configuration)conf);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{INPUT_DIR});
        job.setInputFormatClass(TextInputFormat.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)OUTPUT_DIR);
        job.setOutputFormatClass(TextOutputFormat.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Text.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setNumReduceTasks(1);
        job.setMapperClass(ValueAggregatorMapper.class);
        job.setReducerClass(ValueAggregatorReducer.class);
        job.setCombinerClass(ValueAggregatorCombiner.class);
        job.waitForCompletion(true);
        TestMapReduceAggregates.assertTrue((boolean)job.isSuccessful());
        String outdata = MapReduceTestUtil.readOutput(OUTPUT_DIR, conf);
        System.out.println("full out data:");
        System.out.println(outdata.toString());
        outdata = outdata.substring(0, expectedOutput.toString().length());
        TestMapReduceAggregates.assertEquals((String)expectedOutput.toString(), (String)outdata);
        fs.delete(OUTPUT_DIR, true);
        fs.delete(INPUT_DIR, true);
    }

    public static void main(String[] argv) throws Exception {
        TestMapReduceAggregates.launch();
    }

    static {
        idFormat.setMinimumIntegerDigits(4);
        idFormat.setGroupingUsed(false);
    }
}

