/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TestJobSysDirWithDFS;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.WordCount;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestJobSysDirWithDFS
extends TestCase {
    private static final Log LOG = LogFactory.getLog((String)TestJobSysDirWithDFS.class.getName());
    static final int NUM_MAPS = 10;
    static final int NUM_SAMPLES = 100000;

    public static TestResult launchWordCount(JobConf conf, Path inDir, Path outDir, String input, int numMaps, int numReduces, String sysDir) throws IOException {
        FileSystem inFs = inDir.getFileSystem((Configuration)conf);
        FileSystem outFs = outDir.getFileSystem((Configuration)conf);
        outFs.delete(outDir, true);
        if (!inFs.mkdirs(inDir)) {
            throw new IOException("Mkdirs failed to create " + inDir.toString());
        }
        FSDataOutputStream file = inFs.create(new Path(inDir, "part-0"));
        file.writeBytes(input);
        file.close();
        conf.setJobName("wordcount");
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputKeyClass(Text.class);
        conf.setOutputValueClass(IntWritable.class);
        conf.setMapperClass(WordCount.MapClass.class);
        conf.setCombinerClass(WordCount.Reduce.class);
        conf.setReducerClass(WordCount.Reduce.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        conf.setNumMapTasks(numMaps);
        conf.setNumReduceTasks(numReduces);
        conf.set("mapreduce.jobtracker.system.dir", "/tmp/subru/mapred/system");
        JobClient jobClient = new JobClient(conf);
        RunningJob job = JobClient.runJob((JobConf)conf);
        TestJobSysDirWithDFS.assertFalse((boolean)FileSystem.get((Configuration)conf).exists(new Path(conf.get("mapreduce.jobtracker.system.dir"))));
        TestJobSysDirWithDFS.assertFalse((boolean)sysDir.contains("/tmp/subru/mapred/system"));
        TestJobSysDirWithDFS.assertTrue((boolean)sysDir.contains("custom"));
        return new TestResult(job, MapReduceTestUtil.readOutput((Path)outDir, (Configuration)conf));
    }

    static void runWordCount(MiniMRCluster mr, JobConf jobConf, String sysDir) throws IOException {
        LOG.info((Object)"runWordCount");
        Path inDir = new Path("./wc/input");
        Path outDir = new Path("./wc/output");
        TestResult result = TestJobSysDirWithDFS.launchWordCount((JobConf)jobConf, (Path)inDir, (Path)outDir, (String)"The quick brown fox\nhas many silly\nred fox sox\n", (int)3, (int)1, (String)sysDir);
        TestJobSysDirWithDFS.assertEquals((String)"The\t1\nbrown\t1\nfox\t2\nhas\t1\nmany\t1\nquick\t1\nred\t1\nsilly\t1\nsox\t1\n", (String)result.output);
        TestJobSysDirWithDFS.assertTrue((boolean)result.job.isSuccessful());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWithDFS() throws IOException {
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        DistributedFileSystem fileSys = null;
        try {
            int taskTrackers = 4;
            JobConf conf = new JobConf();
            conf.set("mapreduce.jobtracker.system.dir", "/tmp/custom/mapred/system");
            dfs = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).build();
            fileSys = dfs.getFileSystem();
            mr = new MiniMRCluster(4, fileSys.getUri().toString(), 1, null, null, conf);
            TestJobSysDirWithDFS.runWordCount((MiniMRCluster)mr, (JobConf)mr.createJobConf(), (String)conf.get("mapred.system.dir"));
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
    }
}

