/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.TestMultipleTextOutputFormat;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapred.lib.MultipleTextOutputFormat;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestMultipleTextOutputFormat
extends TestCase {
    private static JobConf defaultConf = new JobConf();
    private static FileSystem localFs = null;
    private static String attempt;
    private static Path workDir;

    private static void writeData(RecordWriter<Text, Text> rw) throws IOException {
        for (int i = 10; i < 40; ++i) {
            String k = "" + i;
            String v = "" + i;
            rw.write((Object)new Text(k), (Object)new Text(v));
        }
    }

    private static void test1(JobConf job) throws IOException {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)job);
        String name = "part-00000";
        KeyBasedMultipleTextOutputFormat theOutputFormat = new KeyBasedMultipleTextOutputFormat();
        RecordWriter rw = theOutputFormat.getRecordWriter((FileSystem)fs, job, name, null);
        TestMultipleTextOutputFormat.writeData((RecordWriter)rw);
        rw.close(null);
    }

    private static void test2(JobConf job) throws IOException {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)job);
        String name = "part-00000";
        job.set("mapreduce.map.input.file", "1/2/3");
        job.set("mapred.outputformat.numOfTrailingLegs", "2");
        MultipleTextOutputFormat theOutputFormat = new MultipleTextOutputFormat();
        RecordWriter rw = theOutputFormat.getRecordWriter((FileSystem)fs, job, name, null);
        TestMultipleTextOutputFormat.writeData((RecordWriter)rw);
        rw.close(null);
    }

    public void testFormat() throws Exception {
        JobConf job = new JobConf();
        job.set("mapreduce.task.attempt.id", attempt);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)workDir.getParent().getParent());
        FileOutputFormat.setWorkOutputPath((JobConf)job, (Path)workDir);
        FileSystem fs = workDir.getFileSystem((Configuration)job);
        if (!fs.mkdirs(workDir)) {
            TestMultipleTextOutputFormat.fail((String)"Failed to create output directory");
        }
        TestMultipleTextOutputFormat.test1((JobConf)job);
        TestMultipleTextOutputFormat.test2((JobConf)job);
        String file_11 = "1-part-00000";
        File expectedFile_11 = new File(new Path(workDir, file_11).toString());
        StringBuffer expectedOutput = new StringBuffer();
        for (int i = 10; i < 20; ++i) {
            expectedOutput.append("" + i).append('\t').append("" + i).append("\n");
        }
        String output = UtilsForTests.slurp((File)expectedFile_11);
        TestMultipleTextOutputFormat.assertEquals((String)output, (String)expectedOutput.toString());
        String file_12 = "2-part-00000";
        File expectedFile_12 = new File(new Path(workDir, file_12).toString());
        expectedOutput = new StringBuffer();
        for (int i = 20; i < 30; ++i) {
            expectedOutput.append("" + i).append('\t').append("" + i).append("\n");
        }
        output = UtilsForTests.slurp((File)expectedFile_12);
        TestMultipleTextOutputFormat.assertEquals((String)output, (String)expectedOutput.toString());
        String file_13 = "3-part-00000";
        File expectedFile_13 = new File(new Path(workDir, file_13).toString());
        expectedOutput = new StringBuffer();
        for (int i = 30; i < 40; ++i) {
            expectedOutput.append("" + i).append('\t').append("" + i).append("\n");
        }
        output = UtilsForTests.slurp((File)expectedFile_13);
        TestMultipleTextOutputFormat.assertEquals((String)output, (String)expectedOutput.toString());
        String file_2 = "2/3";
        File expectedFile_2 = new File(new Path(workDir, file_2).toString());
        expectedOutput = new StringBuffer();
        for (int i = 10; i < 40; ++i) {
            expectedOutput.append("" + i).append('\t').append("" + i).append("\n");
        }
        output = UtilsForTests.slurp((File)expectedFile_2);
        TestMultipleTextOutputFormat.assertEquals((String)output, (String)expectedOutput.toString());
    }

    public static void main(String[] args) throws Exception {
        new TestMultipleTextOutputFormat().testFormat();
    }

    static {
        try {
            localFs = FileSystem.getLocal((Configuration)defaultConf);
        }
        catch (IOException e) {
            throw new RuntimeException("init failure", e);
        }
        attempt = "attempt_200707121733_0001_m_000000_0";
        workDir = new Path(new Path(new Path(System.getProperty("test.build.data", "."), "data"), "_temporary"), "_" + attempt);
    }
}

