/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.db;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.mapreduce.lib.db.TextSplitter;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestTextSplitter
extends TestCase {
    public String formatArray(Object[] ar) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (Object val : ar) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(val.toString());
            first = false;
        }
        sb.append("]");
        return sb.toString();
    }

    public void assertArrayEquals(Object[] expected, Object[] actual) {
        for (int i = 0; i < expected.length; ++i) {
            try {
                TestTextSplitter.assertEquals((String)("Failure at position " + i + "; got " + actual[i] + " instead of " + expected[i] + "; actual array is " + this.formatArray(actual)), (Object)expected[i], (Object)actual[i]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException oob) {
                TestTextSplitter.fail((String)("Expected array with " + expected.length + " elements; got " + actual.length + ". Actual array is " + this.formatArray(actual)));
            }
        }
        if (actual.length > expected.length) {
            TestTextSplitter.fail((String)("Actual array has " + actual.length + " elements; expected " + expected.length + ". Actual array is " + this.formatArray(actual)));
        }
    }

    public void testStringConvertEmpty() {
        TextSplitter splitter = new TextSplitter();
        BigDecimal emptyBigDec = splitter.stringToBigDecimal("");
        TestTextSplitter.assertEquals((Object)BigDecimal.ZERO, (Object)emptyBigDec);
    }

    public void testBigDecConvertEmpty() {
        TextSplitter splitter = new TextSplitter();
        String emptyStr = splitter.bigDecimalToString(BigDecimal.ZERO);
        TestTextSplitter.assertEquals((String)"", (String)emptyStr);
    }

    public void testConvertA() {
        TextSplitter splitter = new TextSplitter();
        String out = splitter.bigDecimalToString(splitter.stringToBigDecimal("A"));
        TestTextSplitter.assertEquals((String)"A", (String)out);
    }

    public void testConvertZ() {
        TextSplitter splitter = new TextSplitter();
        String out = splitter.bigDecimalToString(splitter.stringToBigDecimal("Z"));
        TestTextSplitter.assertEquals((String)"Z", (String)out);
    }

    public void testConvertThreeChars() {
        TextSplitter splitter = new TextSplitter();
        String out = splitter.bigDecimalToString(splitter.stringToBigDecimal("abc"));
        TestTextSplitter.assertEquals((String)"abc", (String)out);
    }

    public void testConvertStr() {
        TextSplitter splitter = new TextSplitter();
        String out = splitter.bigDecimalToString(splitter.stringToBigDecimal("big str"));
        TestTextSplitter.assertEquals((String)"big str", (String)out);
    }

    public void testConvertChomped() {
        TextSplitter splitter = new TextSplitter();
        String out = splitter.bigDecimalToString(splitter.stringToBigDecimal("AVeryLongStringIndeed"));
        TestTextSplitter.assertEquals((String)"AVeryLon", (String)out);
    }

    public void testAlphabetSplit() throws SQLException {
        TextSplitter splitter = new TextSplitter();
        List splits = splitter.split(25, "A", "Z", "");
        Object[] expected = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        this.assertArrayEquals(expected, (Object[])splits.toArray(new String[0]));
    }

    public void testCommonPrefix() throws SQLException {
        TextSplitter splitter = new TextSplitter();
        List splits = splitter.split(5, "nd", "rdy", "Ha");
        TestTextSplitter.assertEquals((String)"Hand", (String)((String)splits.get(0)));
        TestTextSplitter.assertEquals((String)"Hardy", (String)((String)splits.get(splits.size() - 1)));
        TestTextSplitter.assertEquals((int)6, (int)splits.size());
    }
}

