/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.DataInput;
import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileAsBinaryInputFormat;
import org.apache.hadoop.mapreduce.task.MapContextImpl;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestMRSequenceFileAsBinaryInputFormat
extends TestCase {
    private static final int RECORDS = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBinary() throws IOException, InterruptedException {
        Job job = Job.getInstance();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)job.getConfiguration());
        Path dir = new Path(System.getProperty("test.build.data", ".") + "/mapred");
        Path file = new Path(dir, "testbinary.seq");
        Random r = new Random();
        long seed = r.nextLong();
        r.setSeed(seed);
        fs.delete(dir, true);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{dir});
        Text tkey = new Text();
        Text tval = new Text();
        SequenceFile.Writer writer = new SequenceFile.Writer((FileSystem)fs, job.getConfiguration(), file, Text.class, Text.class);
        try {
            for (int i = 0; i < 10000; ++i) {
                tkey.set(Integer.toString(r.nextInt(), 36));
                tval.set(Long.toString(r.nextLong(), 36));
                writer.append((Writable)tkey, (Writable)tval);
            }
        }
        finally {
            writer.close();
        }
        TaskAttemptContext context = MapReduceTestUtil.createDummyMapTaskAttemptContext((Configuration)job.getConfiguration());
        SequenceFileAsBinaryInputFormat bformat = new SequenceFileAsBinaryInputFormat();
        int count = 0;
        r.setSeed(seed);
        BytesWritable bkey = new BytesWritable();
        BytesWritable bval = new BytesWritable();
        Text cmpkey = new Text();
        Text cmpval = new Text();
        DataInputBuffer buf = new DataInputBuffer();
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{file});
        for (InputSplit split : bformat.getSplits((JobContext)job)) {
            RecordReader reader = bformat.createRecordReader(split, context);
            MapContextImpl mcontext = new MapContextImpl(job.getConfiguration(), context.getTaskAttemptID(), reader, null, null, MapReduceTestUtil.createDummyReporter(), split);
            reader.initialize(split, (TaskAttemptContext)mcontext);
            try {
                while (reader.nextKeyValue()) {
                    bkey = (BytesWritable)reader.getCurrentKey();
                    bval = (BytesWritable)reader.getCurrentValue();
                    tkey.set(Integer.toString(r.nextInt(), 36));
                    tval.set(Long.toString(r.nextLong(), 36));
                    buf.reset(bkey.getBytes(), bkey.getLength());
                    cmpkey.readFields((DataInput)buf);
                    buf.reset(bval.getBytes(), bval.getLength());
                    cmpval.readFields((DataInput)buf);
                    TestMRSequenceFileAsBinaryInputFormat.assertTrue((String)("Keys don't match: *" + cmpkey.toString() + ":" + tkey.toString() + "*"), (boolean)cmpkey.toString().equals(tkey.toString()));
                    TestMRSequenceFileAsBinaryInputFormat.assertTrue((String)("Vals don't match: *" + cmpval.toString() + ":" + tval.toString() + "*"), (boolean)cmpval.toString().equals(tval.toString()));
                    ++count;
                }
            }
            finally {
                reader.close();
            }
        }
        TestMRSequenceFileAsBinaryInputFormat.assertEquals((String)"Some records not found", (int)10000, (int)count);
    }
}

