/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestSequenceFileMergeProgress
extends TestCase {
    private static final Log LOG = FileInputFormat.LOG;
    private static final int RECORDS = 10000;

    public void testMergeProgressWithNoCompression() throws IOException {
        this.runTest(SequenceFile.CompressionType.NONE);
    }

    public void testMergeProgressWithRecordCompression() throws IOException {
        this.runTest(SequenceFile.CompressionType.RECORD);
    }

    public void testMergeProgressWithBlockCompression() throws IOException {
        this.runTest(SequenceFile.CompressionType.BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(SequenceFile.CompressionType compressionType) throws IOException {
        JobConf job = new JobConf();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)job);
        Path dir = new Path(System.getProperty("test.build.data", ".") + "/mapred");
        Path file = new Path(dir, "test.seq");
        Path tempDir = new Path(dir, "tmp");
        fs.delete(dir, true);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{dir});
        fs.mkdirs(tempDir);
        LongWritable tkey = new LongWritable();
        Text tval = new Text();
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)job, (Path)file, LongWritable.class, Text.class, (SequenceFile.CompressionType)compressionType, (CompressionCodec)new DefaultCodec());
        try {
            for (int i = 0; i < 10000; ++i) {
                tkey.set(1234L);
                tval.set("valuevaluevaluevaluevaluevaluevaluevaluevaluevaluevalue");
                writer.append((Writable)tkey, (Writable)tval);
            }
        }
        finally {
            writer.close();
        }
        long fileLength = fs.getFileStatus(file).getLen();
        LOG.info((Object)("With compression = " + compressionType + ": " + "compressed length = " + fileLength));
        SequenceFile.Sorter sorter = new SequenceFile.Sorter((FileSystem)fs, job.getOutputKeyComparator(), job.getMapOutputKeyClass(), job.getMapOutputValueClass(), (Configuration)job);
        Path[] paths = new Path[]{file};
        SequenceFile.Sorter.RawKeyValueIterator rIter = sorter.merge(paths, tempDir, false);
        int count = 0;
        while (rIter.next()) {
            ++count;
        }
        TestSequenceFileMergeProgress.assertEquals((int)10000, (int)count);
        TestSequenceFileMergeProgress.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(rIter.getProgress().get()));
    }
}

