/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TestUserDefinedCounters;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.Utils;
import org.apache.hadoop.mapred.lib.IdentityReducer;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestUserDefinedCounters
extends TestCase {
    private static String TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp")).toURI().toString().replace(' ', '+') + "/" + TestUserDefinedCounters.class.getName();
    private final Path INPUT_DIR = new Path(TEST_ROOT_DIR + "/input");
    private final Path OUTPUT_DIR = new Path(TEST_ROOT_DIR + "/out");
    private final Path INPUT_FILE = new Path(this.INPUT_DIR, "inp");

    private void cleanAndCreateInput(FileSystem fs) throws IOException {
        fs.delete(this.INPUT_DIR, true);
        fs.delete(this.OUTPUT_DIR, true);
        FSDataOutputStream os = fs.create(this.INPUT_FILE);
        OutputStreamWriter wr = new OutputStreamWriter((OutputStream)os);
        wr.write("hello1\n");
        wr.write("hello2\n");
        wr.write("hello3\n");
        wr.write("hello4\n");
        ((Writer)wr).close();
    }

    public void testMapReduceJob() throws Exception {
        JobConf conf = new JobConf(TestUserDefinedCounters.class);
        conf.setJobName("UserDefinedCounters");
        FileSystem fs = FileSystem.get((Configuration)conf);
        this.cleanAndCreateInput(fs);
        conf.setInputFormat(TextInputFormat.class);
        conf.setMapOutputKeyClass(LongWritable.class);
        conf.setMapOutputValueClass(Text.class);
        conf.setOutputFormat(TextOutputFormat.class);
        conf.setOutputKeyClass(LongWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapperClass(CountingMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{this.INPUT_DIR});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)this.OUTPUT_DIR);
        RunningJob runningJob = JobClient.runJob((JobConf)conf);
        Path[] outputFiles = FileUtil.stat2Paths((FileStatus[])fs.listStatus(this.OUTPUT_DIR, (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter()));
        if (outputFiles.length > 0) {
            FSDataInputStream is = fs.open(outputFiles[0]);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is));
            String line = reader.readLine();
            int counter = 0;
            while (line != null) {
                ++counter;
                TestUserDefinedCounters.assertTrue((boolean)line.contains("hello"));
                line = reader.readLine();
            }
            reader.close();
            TestUserDefinedCounters.assertEquals((int)4, (int)counter);
        }
        TestUserDefinedCounters.verifyCounters((RunningJob)runningJob, (int)4);
    }

    public static void verifyCounters(RunningJob runningJob, int expected) throws IOException {
        TestUserDefinedCounters.assertEquals((long)expected, (long)runningJob.getCounters().getCounter((Enum)EnumCounter.MAP_RECORDS));
        TestUserDefinedCounters.assertEquals((long)expected, (long)runningJob.getCounters().getGroup("StringCounter").getCounter("MapRecords"));
    }
}

