/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.SortValidator;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.mapreduce.Cluster;

/*
 * Exception performing whole class analysis ignored.
 */
public class UtilsForTests {
    static final Log LOG = LogFactory.getLog(UtilsForTests.class);
    static final long KB = 1024L;
    static final long MB = 0x100000L;
    static final long GB = 0x40000000L;
    static final long TB = 0x10000000000L;
    static final long PB = 0x4000000000000L;
    static final Object waitLock = new Object();
    static DecimalFormat dfm = new DecimalFormat("####.000");
    static DecimalFormat ifm = new DecimalFormat("###,###,###,###,###");
    static final String regexpSpecials = "[]()?*+|.!^-\\~@";
    static char[] space = new char[300];

    public static String dfmt(double d) {
        return dfm.format(d);
    }

    public static String ifmt(double d) {
        return ifm.format(d);
    }

    public static String formatBytes(long numBytes) {
        StringBuffer buf = new StringBuffer();
        boolean bDetails = true;
        double num = numBytes;
        if (numBytes < 1024L) {
            buf.append(numBytes + " B");
            bDetails = false;
        } else if (numBytes < 0x100000L) {
            buf.append(UtilsForTests.dfmt((double)(num / 1024.0)) + " KB");
        } else if (numBytes < 0x40000000L) {
            buf.append(UtilsForTests.dfmt((double)(num / 1048576.0)) + " MB");
        } else if (numBytes < 0x10000000000L) {
            buf.append(UtilsForTests.dfmt((double)(num / 1.073741824E9)) + " GB");
        } else if (numBytes < 0x4000000000000L) {
            buf.append(UtilsForTests.dfmt((double)(num / 1.099511627776E12)) + " TB");
        } else {
            buf.append(UtilsForTests.dfmt((double)(num / 1.125899906842624E15)) + " PB");
        }
        if (bDetails) {
            buf.append(" (" + UtilsForTests.ifmt((double)numBytes) + " bytes)");
        }
        return buf.toString();
    }

    public static String formatBytes2(long numBytes) {
        StringBuffer buf = new StringBuffer();
        long u = 0L;
        if (numBytes >= 0x10000000000L) {
            u = numBytes / 0x10000000000L;
            numBytes -= u * 0x10000000000L;
            buf.append(u + " TB ");
        }
        if (numBytes >= 0x40000000L) {
            u = numBytes / 0x40000000L;
            numBytes -= u * 0x40000000L;
            buf.append(u + " GB ");
        }
        if (numBytes >= 0x100000L) {
            u = numBytes / 0x100000L;
            numBytes -= u * 0x100000L;
            buf.append(u + " MB ");
        }
        if (numBytes >= 1024L) {
            u = numBytes / 1024L;
            numBytes -= u * 1024L;
            buf.append(u + " KB ");
        }
        buf.append(u + " B");
        return buf.toString();
    }

    public static String regexpEscape(String plain) {
        StringBuffer buf = new StringBuffer();
        char[] ch = plain.toCharArray();
        int csup = ch.length;
        for (int c = 0; c < csup; ++c) {
            if ("[]()?*+|.!^-\\~@".indexOf(ch[c]) != -1) {
                buf.append("\\");
            }
            buf.append(ch[c]);
        }
        return buf.toString();
    }

    public static String safeGetCanonicalPath(File f) {
        try {
            String s = f.getCanonicalPath();
            return s == null ? f.toString() : s;
        }
        catch (IOException io) {
            return f.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String slurp(File f) throws IOException {
        int len = (int)f.length();
        byte[] buf = new byte[len];
        FileInputStream in = new FileInputStream(f);
        String contents = null;
        try {
            in.read(buf, 0, len);
            contents = new String(buf, "UTF-8");
        }
        finally {
            in.close();
        }
        return contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String slurpHadoop(Path p, FileSystem fs) throws IOException {
        int len = (int)fs.getFileStatus(p).getLen();
        byte[] buf = new byte[len];
        FSDataInputStream in = fs.open(p);
        String contents = null;
        try {
            in.read(buf, 0, len);
            contents = new String(buf, "UTF-8");
        }
        finally {
            in.close();
        }
        return contents;
    }

    public static String rjustify(String s, int width) {
        if (s == null) {
            s = "null";
        }
        if (width > s.length()) {
            s = UtilsForTests.getSpace((int)(width - s.length())) + s;
        }
        return s;
    }

    public static String ljustify(String s, int width) {
        if (s == null) {
            s = "null";
        }
        if (width > s.length()) {
            s = s + UtilsForTests.getSpace((int)(width - s.length()));
        }
        return s;
    }

    public static String getSpace(int len) {
        if (len > space.length) {
            space = new char[Math.max(len, 2 * space.length)];
            Arrays.fill(space, ' ');
        }
        return new String(space, 0, len);
    }

    static JobStatus getJobStatus(JobClient jc, JobID id) throws IOException {
        JobStatus[] statuses;
        for (JobStatus jobStatus : statuses = jc.getAllJobs()) {
            if (!jobStatus.getJobID().equals((Object)id)) continue;
            return jobStatus;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitFor(long duration) {
        try {
            Object object = waitLock;
            synchronized (object) {
                waitLock.wait(duration);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static void waitForJobTracker(JobClient jobClient) {
        while (true) {
            try {
                ClusterStatus status = jobClient.getClusterStatus();
                while (status.getJobTrackerStatus() != Cluster.JobTrackerStatus.RUNNING) {
                    UtilsForTests.waitFor((long)100L);
                    status = jobClient.getClusterStatus();
                }
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    static void waitTillDone(JobClient jobClient) throws IOException {
        while (true) {
            boolean shouldWait = false;
            for (JobStatus jobStatuses : jobClient.getAllJobs()) {
                if (jobStatuses.getRunState() == JobStatus.SUCCEEDED || jobStatuses.getRunState() == JobStatus.FAILED || jobStatuses.getRunState() == JobStatus.KILLED) continue;
                shouldWait = true;
                break;
            }
            if (!shouldWait) break;
            UtilsForTests.waitFor((long)100L);
        }
    }

    static void configureWaitingJobConf(JobConf jobConf, Path inDir, Path outputPath, int numMaps, int numRed, String jobName, String mapSignalFilename, String redSignalFilename) throws IOException {
        jobConf.setJobName(jobName);
        jobConf.setInputFormat(SortValidator.RecordStatsChecker.NonSplitableSequenceFileInputFormat.class);
        jobConf.setOutputFormat(SequenceFileOutputFormat.class);
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)jobConf, (Path)outputPath);
        jobConf.setMapperClass(HalfWaitingMapper.class);
        jobConf.setReducerClass(IdentityReducer.class);
        jobConf.setOutputKeyClass(BytesWritable.class);
        jobConf.setOutputValueClass(BytesWritable.class);
        jobConf.setInputFormat(RandomInputFormat.class);
        jobConf.setNumMapTasks(numMaps);
        jobConf.setNumReduceTasks(numRed);
        jobConf.setJar("build/test/mapred/testjar/testjob.jar");
        jobConf.set(UtilsForTests.getTaskSignalParameter((boolean)true), mapSignalFilename);
        jobConf.set(UtilsForTests.getTaskSignalParameter((boolean)false), redSignalFilename);
    }

    static String getTaskSignalParameter(boolean isMap) {
        return isMap ? "test.mapred.map.waiting.target" : "test.mapred.reduce.waiting.target";
    }

    static void signalTasks(MiniDFSCluster dfs, FileSystem fileSys, String mapSignalFile, String reduceSignalFile, int replication) throws IOException, TimeoutException {
        try {
            UtilsForTests.writeFile((NameNode)dfs.getNameNode(), (Configuration)fileSys.getConf(), (Path)new Path(mapSignalFile), (short)((short)replication));
            UtilsForTests.writeFile((NameNode)dfs.getNameNode(), (Configuration)fileSys.getConf(), (Path)new Path(reduceSignalFile), (short)((short)replication));
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
    }

    static void signalTasks(MiniDFSCluster dfs, FileSystem fileSys, boolean isMap, String mapSignalFile, String reduceSignalFile) throws IOException, TimeoutException {
        try {
            UtilsForTests.writeFile((NameNode)dfs.getNameNode(), (Configuration)fileSys.getConf(), (Path)(isMap ? new Path(mapSignalFile) : new Path(reduceSignalFile)), (short)1);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
    }

    static String getSignalFile(Path dir) {
        return new Path(dir, "signal").toString();
    }

    static String getMapSignalFile(Path dir) {
        return new Path(dir, "map-signal").toString();
    }

    static String getReduceSignalFile(Path dir) {
        return new Path(dir, "reduce-signal").toString();
    }

    static void writeFile(NameNode namenode, Configuration conf, Path name, short replication) throws IOException, TimeoutException, InterruptedException {
        FileSystem fileSys = FileSystem.get((Configuration)conf);
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fileSys, (Configuration)conf, (Path)name, BytesWritable.class, BytesWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
        writer.append((Writable)new BytesWritable(), (Writable)new BytesWritable());
        writer.close();
        fileSys.setReplication(name, replication);
        DFSTestUtil.waitReplication((FileSystem)fileSys, (Path)name, (short)replication);
    }

    static RunningJob runJob(JobConf conf, Path inDir, Path outDir) throws IOException {
        return UtilsForTests.runJob((JobConf)conf, (Path)inDir, (Path)outDir, (int)conf.getNumMapTasks(), (int)conf.getNumReduceTasks());
    }

    static RunningJob runJob(JobConf conf, Path inDir, Path outDir, int numMaps, int numReds) throws IOException {
        String input = "The quick brown fox\nhas many silly\nred fox sox\n";
        return UtilsForTests.runJob((JobConf)conf, (Path)inDir, (Path)outDir, (int)numMaps, (int)numReds, (String)input);
    }

    static RunningJob runJob(JobConf conf, Path inDir, Path outDir, int numMaps, int numReds, String input) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (fs.exists(outDir)) {
            fs.delete(outDir, true);
        }
        if (!fs.exists(inDir)) {
            fs.mkdirs(inDir);
        }
        for (int i = 0; i < numMaps; ++i) {
            FSDataOutputStream file = fs.create(new Path(inDir, "part-" + i));
            file.writeBytes(input);
            file.close();
        }
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputKeyClass(LongWritable.class);
        conf.setOutputValueClass(Text.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        conf.setNumMapTasks(numMaps);
        conf.setNumReduceTasks(numReds);
        JobClient jobClient = new JobClient(conf);
        RunningJob job = jobClient.submitJob(conf);
        return job;
    }

    public static RunningJob runJobSucceed(JobConf conf, Path inDir, Path outDir) throws IOException {
        conf.setJobName("test-job-succeed");
        conf.setMapperClass(IdentityMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        RunningJob job = UtilsForTests.runJob((JobConf)conf, (Path)inDir, (Path)outDir);
        long sleepCount = 0L;
        while (!job.isComplete()) {
            try {
                if (sleepCount > 300L) {
                    throw new IOException("Job didn't finish in 30 seconds");
                }
                Thread.sleep(100L);
                ++sleepCount;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return job;
    }

    public static RunningJob runJobFail(JobConf conf, Path inDir, Path outDir) throws IOException {
        conf.setJobName("test-job-fail");
        conf.setMapperClass(FailMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        conf.setMaxMapAttempts(1);
        RunningJob job = UtilsForTests.runJob((JobConf)conf, (Path)inDir, (Path)outDir);
        long sleepCount = 0L;
        while (!job.isComplete()) {
            try {
                if (sleepCount > 300L) {
                    throw new IOException("Job didn't finish in 30 seconds");
                }
                Thread.sleep(100L);
                ++sleepCount;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return job;
    }

    public static RunningJob runJobKill(JobConf conf, Path inDir, Path outDir) throws IOException {
        conf.setJobName("test-job-kill");
        conf.setMapperClass(KillMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        RunningJob job = UtilsForTests.runJob((JobConf)conf, (Path)inDir, (Path)outDir);
        long sleepCount = 0L;
        while (job.getJobState() != JobStatus.RUNNING) {
            try {
                if (sleepCount > 300L) {
                    throw new IOException("Job didn't finish in 30 seconds");
                }
                Thread.sleep(100L);
                ++sleepCount;
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        job.killJob();
        sleepCount = 0L;
        while (job.cleanupProgress() == 0.0f) {
            try {
                if (sleepCount > 2000L) {
                    throw new IOException("Job cleanup didn't start in 20 seconds");
                }
                Thread.sleep(10L);
                ++sleepCount;
            }
            catch (InterruptedException ie) {
                break;
            }
        }
        return job;
    }

    static void setUpConfigFile(Properties confProps, File configFile) throws IOException {
        Configuration config = new Configuration(false);
        FileOutputStream fos = new FileOutputStream(configFile);
        Enumeration<?> e = confProps.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            config.set(key, confProps.getProperty(key));
        }
        config.writeXml((OutputStream)fos);
        fos.close();
    }

    public static DataOutputStream createTmpFileDFS(FileSystem dfs, Path URIPATH, FsPermission permission, String input) throws Exception {
        FSDataOutputStream file = FileSystem.create((FileSystem)dfs, (Path)URIPATH, (FsPermission)permission);
        file.writeBytes(input);
        file.close();
        return file;
    }

    public static String getFQDNofTT(String taskTrackerLong) throws Exception {
        String[] firstSplit = taskTrackerLong.split("_");
        String tmpOutput = firstSplit[1];
        String[] secondSplit = tmpOutput.split(":");
        String tmpTaskTracker = secondSplit[0];
        return tmpTaskTracker;
    }

    static {
        Arrays.fill(space, ' ');
    }
}

