/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.chain;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.lib.chain.ChainMapper;
import org.apache.hadoop.mapreduce.lib.chain.ChainReducer;
import org.apache.hadoop.mapreduce.lib.chain.TestMapReduceChain;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestMapReduceChain
extends HadoopTestCase {
    private static String localPathRoot = System.getProperty("test.build.data", "/tmp");
    private static Path flagDir = new Path(localPathRoot, "testing/chain/flags");

    private static void cleanFlags(Configuration conf) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(flagDir, true);
        fs.mkdirs(flagDir);
    }

    private static void writeFlag(Configuration conf, String flag) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (TestMapReduceChain.getFlag((Configuration)conf, (String)flag)) {
            TestMapReduceChain.fail((String)("Flag " + flag + " already exists"));
        }
        FSDataOutputStream file = fs.create(new Path(flagDir, flag));
        file.close();
    }

    private static boolean getFlag(Configuration conf, String flag) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        return fs.exists(new Path(flagDir, flag));
    }

    public TestMapReduceChain() throws IOException {
        super(1, 4, 1, 1);
    }

    public void testChain() throws Exception {
        Path inDir = new Path(localPathRoot, "testing/chain/input");
        Path outDir = new Path(localPathRoot, "testing/chain/output");
        String input = "1\n2\n";
        String expectedOutput = "0\t1ABCRDEF\n2\t2ABCRDEF\n";
        JobConf conf = this.createJobConf();
        TestMapReduceChain.cleanFlags((Configuration)conf);
        conf.set("a", "X");
        Job job = MapReduceTestUtil.createJob((Configuration)conf, (Path)inDir, (Path)outDir, (int)1, (int)1, (String)input);
        job.setJobName("chain");
        Configuration mapAConf = new Configuration(false);
        mapAConf.set("a", "A");
        ChainMapper.addMapper((Job)job, AMap.class, LongWritable.class, Text.class, LongWritable.class, Text.class, (Configuration)mapAConf);
        ChainMapper.addMapper((Job)job, BMap.class, LongWritable.class, Text.class, LongWritable.class, Text.class, null);
        ChainMapper.addMapper((Job)job, CMap.class, LongWritable.class, Text.class, LongWritable.class, Text.class, null);
        Configuration reduceConf = new Configuration(false);
        reduceConf.set("a", "C");
        ChainReducer.setReducer((Job)job, RReduce.class, LongWritable.class, Text.class, LongWritable.class, Text.class, (Configuration)reduceConf);
        ChainReducer.addMapper((Job)job, DMap.class, LongWritable.class, Text.class, LongWritable.class, Text.class, null);
        Configuration mapEConf = new Configuration(false);
        mapEConf.set("a", "E");
        ChainReducer.addMapper((Job)job, EMap.class, LongWritable.class, Text.class, LongWritable.class, Text.class, (Configuration)mapEConf);
        ChainReducer.addMapper((Job)job, FMap.class, LongWritable.class, Text.class, LongWritable.class, Text.class, null);
        job.waitForCompletion(true);
        TestMapReduceChain.assertTrue((String)"Job failed", (boolean)job.isSuccessful());
        String str = "flag not set";
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, (String)"map.setup.A"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, (String)"map.setup.B"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, (String)"map.setup.C"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, (String)"reduce.setup.R"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, (String)"map.setup.D"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, (String)"map.setup.E"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, (String)"map.setup.F"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, (String)"map.A.value.1"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, (String)"map.A.value.2"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, (String)"map.B.value.1A"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, (String)"map.B.value.2A"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, (String)"map.C.value.1AB"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, (String)"map.C.value.2AB"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, (String)"reduce.R.value.1ABC"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, (String)"reduce.R.value.2ABC"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, (String)"map.D.value.1ABCR"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, (String)"map.D.value.2ABCR"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, (String)"map.E.value.1ABCRD"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, (String)"map.E.value.2ABCRD"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, (String)"map.F.value.1ABCRDE"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, (String)"map.F.value.2ABCRDE"));
        TestMapReduceChain.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, (String)"map.cleanup.A"));
        TestMapReduceChain.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, (String)"map.cleanup.B"));
        TestMapReduceChain.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, (String)"map.cleanup.C"));
        TestMapReduceChain.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, (String)"reduce.cleanup.R"));
        TestMapReduceChain.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, (String)"map.cleanup.D"));
        TestMapReduceChain.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, (String)"map.cleanup.E"));
        TestMapReduceChain.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, (String)"map.cleanup.F"));
        TestMapReduceChain.assertEquals((String)"Outputs doesn't match", (String)expectedOutput, (String)MapReduceTestUtil.readOutput((Path)outDir, (Configuration)conf));
    }

    static /* synthetic */ void access$000(Configuration x0, String x1) throws IOException {
        TestMapReduceChain.writeFlag((Configuration)x0, (String)x1);
    }
}

