/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.MiniMRClientCluster;
import org.apache.hadoop.mapreduce.v2.MiniMRYarnCluster;
import org.apache.hadoop.service.Service;

public class MiniMRYarnClusterAdapter
implements MiniMRClientCluster {
    private MiniMRYarnCluster miniMRYarnCluster;
    private static final Log LOG = LogFactory.getLog(MiniMRYarnClusterAdapter.class);

    public MiniMRYarnClusterAdapter(MiniMRYarnCluster miniMRYarnCluster) {
        this.miniMRYarnCluster = miniMRYarnCluster;
    }

    public Configuration getConfig() {
        return this.miniMRYarnCluster.getConfig();
    }

    public void start() {
        this.miniMRYarnCluster.start();
    }

    public void stop() {
        this.miniMRYarnCluster.stop();
    }

    public void restart() {
        if (!this.miniMRYarnCluster.getServiceState().equals((Object)Service.STATE.STARTED)) {
            LOG.warn((Object)"Cannot restart the mini cluster, start it first");
            return;
        }
        Configuration oldConf = new Configuration(this.getConfig());
        String callerName = oldConf.get("minimrclientcluster.caller.name", this.getClass().getName());
        int noOfNMs = oldConf.getInt("minimrclientcluster.nodemanagers.number", 1);
        oldConf.setBoolean("yarn.minicluster.fixed.ports", true);
        oldConf.setBoolean("mapreduce.jobhistory.minicluster.fixed.ports", true);
        this.stop();
        this.miniMRYarnCluster = new MiniMRYarnCluster(callerName, noOfNMs);
        this.miniMRYarnCluster.init(oldConf);
        this.miniMRYarnCluster.start();
    }
}

