/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapred.IFile;
import org.apache.hadoop.mapred.Merger;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TestReduceTask;
import org.apache.hadoop.util.Progressable;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestReduceTask
extends TestCase {
    private static Pair[][] testCases = new Pair[][]{{new Pair("k1", "v1"), new Pair("k2", "v2"), new Pair("k3", "v3"), new Pair("k3", "v4"), new Pair("k4", "v5"), new Pair("k5", "v6")}, {new Pair("", "v1"), new Pair("k1", "v2"), new Pair("k2", "v3"), new Pair("k2", "v4")}, new Pair[0], {new Pair("k1", "v1"), new Pair("k1", "v2"), new Pair("k1", "v3"), new Pair("k1", "v4")}};

    public void runValueIterator(Path tmpDir, Pair[] vals, Configuration conf, CompressionCodec codec) throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        FileSystem rfs = localFs.getRaw();
        Path path = new Path(tmpDir, "data.in");
        IFile.Writer writer = new IFile.Writer(conf, rfs.create(path), Text.class, Text.class, codec, null);
        for (Pair p : vals) {
            writer.append((Object)new Text(p.key), (Object)new Text(p.value));
        }
        writer.close();
        RawKeyValueIterator rawItr = Merger.merge((Configuration)conf, (FileSystem)rfs, Text.class, Text.class, (CompressionCodec)codec, (Path[])new Path[]{path}, (boolean)false, (int)conf.getInt("mapreduce.task.io.sort.factor", 100), (Path)tmpDir, (RawComparator)new Text.Comparator(), (Progressable)new NullProgress(), null, null, null);
        Task.ValuesIterator valItr = new Task.ValuesIterator(rawItr, (RawComparator)WritableComparator.get(Text.class), Text.class, Text.class, conf, (Progressable)new NullProgress());
        int i = 0;
        while (valItr.more()) {
            Object key = valItr.getKey();
            String keyString = key.toString();
            TestReduceTask.assertEquals((String)vals[i].key, (String)keyString);
            TestReduceTask.assertTrue((boolean)valItr.hasNext());
            while (valItr.hasNext()) {
                String valueString = valItr.next().toString();
                TestReduceTask.assertEquals((String)vals[i].value, (String)valueString);
                TestReduceTask.assertEquals((String)vals[i].key, (String)valItr.getKey().toString());
                ++i;
            }
            TestReduceTask.assertEquals((String)keyString, (String)valItr.getKey().toString());
            valItr.nextKey();
        }
        TestReduceTask.assertEquals((int)vals.length, (int)i);
        TestReduceTask.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(rawItr.getProgress().get()));
    }

    public void testValueIterator() throws Exception {
        Path tmpDir = new Path("build/test/test.reduce.task");
        Configuration conf = new Configuration();
        for (Pair[] testCase : testCases) {
            this.runValueIterator(tmpDir, testCase, conf, null);
        }
    }

    public void testValueIteratorWithCompression() throws Exception {
        Path tmpDir = new Path("build/test/test.reduce.task.compression");
        Configuration conf = new Configuration();
        DefaultCodec codec = new DefaultCodec();
        codec.setConf(conf);
        for (Pair[] testCase : testCases) {
            this.runValueIterator(tmpDir, testCase, conf, (CompressionCodec)codec);
        }
    }
}

