/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.slive.ConfigExtractor;
import org.apache.hadoop.fs.slive.OperationOutput;
import org.apache.hadoop.fs.slive.PathFinder;

abstract class Operation {
    private ConfigExtractor config;
    private PathFinder finder;
    private String type;
    private Random rnd;

    protected Operation(String type, ConfigExtractor cfg, Random rnd) {
        this.config = cfg;
        this.type = type;
        this.rnd = rnd;
        this.finder = new PathFinder(cfg, new Random(rnd.nextInt()));
    }

    protected ConfigExtractor getConfig() {
        return this.config;
    }

    protected Random getRandom() {
        return this.rnd;
    }

    String getType() {
        return this.type;
    }

    protected PathFinder getFinder() {
        return this.finder;
    }

    public String toString() {
        return this.getType();
    }

    List<OperationOutput> run(FileSystem fs) {
        LinkedList<OperationOutput> out = new LinkedList<OperationOutput>();
        out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "op_count", (Object)1L));
        return out;
    }
}

