/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.slive.Formatter;
import org.apache.hadoop.fs.slive.OperationOutput;

class ReportWriter {
    static final String OK_TIME_TAKEN = "milliseconds_taken";
    static final String FAILURES = "failures";
    static final String SUCCESSES = "successes";
    static final String BYTES_WRITTEN = "bytes_written";
    static final String FILES_CREATED = "files_created";
    static final String DIR_ENTRIES = "dir_entries";
    static final String OP_COUNT = "op_count";
    static final String CHUNKS_VERIFIED = "chunks_verified";
    static final String CHUNKS_UNVERIFIED = "chunks_unverified";
    static final String BYTES_READ = "bytes_read";
    static final String NOT_FOUND = "files_not_found";
    static final String BAD_FILES = "bad_files";
    private static final Log LOG = LogFactory.getLog(ReportWriter.class);
    private static final String SECTION_DELIM = "-------------";

    ReportWriter() {
    }

    private String getSectionDelimiter() {
        return SECTION_DELIM;
    }

    private void writeMessage(String msg, PrintWriter os) {
        LOG.info((Object)msg);
        if (os != null) {
            os.println(msg);
        }
    }

    void basicReport(List<OperationOutput> input, PrintWriter os) {
        this.writeMessage("Default report for " + input.size() + " operations ", os);
        this.writeMessage(this.getSectionDelimiter(), os);
        for (OperationOutput data : input) {
            this.writeMessage("Operation \"" + data.getOperationType() + "\" measuring \"" + data.getMeasurementType() + "\" = " + data.getValue(), os);
        }
        this.writeMessage(this.getSectionDelimiter(), os);
    }

    void opReport(String operation, List<OperationOutput> input, PrintWriter os) {
        Long mTaken;
        this.writeMessage("Basic report for operation type " + operation, os);
        this.writeMessage(this.getSectionDelimiter(), os);
        for (OperationOutput operationOutput : input) {
            this.writeMessage("Measurement \"" + operationOutput.getMeasurementType() + "\" = " + operationOutput.getValue(), os);
        }
        TreeMap<String, OperationOutput> combined = new TreeMap<String, OperationOutput>();
        for (OperationOutput data : input) {
            if (combined.containsKey(data.getMeasurementType())) {
                OperationOutput curr = (OperationOutput)combined.get(data.getMeasurementType());
                combined.put(data.getMeasurementType(), OperationOutput.merge((OperationOutput)curr, (OperationOutput)data));
                continue;
            }
            combined.put(data.getMeasurementType(), data);
        }
        OperationOutput operationOutput = (OperationOutput)combined.get(OK_TIME_TAKEN);
        if (operationOutput != null && (mTaken = Long.valueOf(Long.parseLong(operationOutput.getValue().toString()))) > 0L) {
            NumberFormat formatter = Formatter.getDecimalFormatter();
            for (String measurementType : combined.keySet()) {
                Double rate = null;
                String rateType = "";
                if (measurementType.equals(BYTES_WRITTEN)) {
                    Long mbWritten = Long.parseLong(((OperationOutput)combined.get(measurementType)).getValue().toString()) / 0x100000L;
                    rate = (double)mbWritten.longValue() / ((double)mTaken.longValue() / 1000.0);
                    rateType = "MB/sec";
                } else if (measurementType.equals(SUCCESSES)) {
                    Long succ = Long.parseLong(((OperationOutput)combined.get(measurementType)).getValue().toString());
                    rate = (double)succ.longValue() / ((double)mTaken.longValue() / 1000.0);
                    rateType = "successes/sec";
                } else if (measurementType.equals(FILES_CREATED)) {
                    Long filesCreated = Long.parseLong(((OperationOutput)combined.get(measurementType)).getValue().toString());
                    rate = (double)filesCreated.longValue() / ((double)mTaken.longValue() / 1000.0);
                    rateType = "files created/sec";
                } else if (measurementType.equals(DIR_ENTRIES)) {
                    Long entries = Long.parseLong(((OperationOutput)combined.get(measurementType)).getValue().toString());
                    rate = (double)entries.longValue() / ((double)mTaken.longValue() / 1000.0);
                    rateType = "directory entries/sec";
                } else if (measurementType.equals(OP_COUNT)) {
                    Long opCount = Long.parseLong(((OperationOutput)combined.get(measurementType)).getValue().toString());
                    rate = (double)opCount.longValue() / ((double)mTaken.longValue() / 1000.0);
                    rateType = "operations/sec";
                } else if (measurementType.equals(BYTES_READ)) {
                    Long mbRead = Long.parseLong(((OperationOutput)combined.get(measurementType)).getValue().toString()) / 0x100000L;
                    rate = (double)mbRead.longValue() / ((double)mTaken.longValue() / 1000.0);
                    rateType = "MB/sec";
                }
                if (rate == null) continue;
                this.writeMessage("Rate for measurement \"" + measurementType + "\" = " + formatter.format(rate) + " " + rateType, os);
            }
        }
        this.writeMessage(this.getSectionDelimiter(), os);
    }
}

