/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.mapred.IFileInputStream;
import org.apache.hadoop.mapred.IFileOutputStream;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestIFileStreams
extends TestCase {
    public void testIFileStream() throws Exception {
        int DLEN = 100;
        DataOutputBuffer dob = new DataOutputBuffer(104);
        IFileOutputStream ifos = new IFileOutputStream((OutputStream)dob);
        for (int i = 0; i < 100; ++i) {
            ifos.write(i);
        }
        ifos.close();
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(dob.getData(), 104);
        IFileInputStream ifis = new IFileInputStream((InputStream)dib, 104L, new Configuration());
        for (int i = 0; i < 100; ++i) {
            TestIFileStreams.assertEquals((int)i, (int)ifis.read());
        }
        ifis.close();
    }

    public void testBadIFileStream() throws Exception {
        int i;
        int DLEN = 100;
        DataOutputBuffer dob = new DataOutputBuffer(104);
        IFileOutputStream ifos = new IFileOutputStream((OutputStream)dob);
        for (int i2 = 0; i2 < 100; ++i2) {
            ifos.write(i2);
        }
        ifos.close();
        DataInputBuffer dib = new DataInputBuffer();
        byte[] b = dob.getData();
        b[17] = (byte)(b[17] + 1);
        dib.reset(b, 104);
        IFileInputStream ifis = new IFileInputStream((InputStream)dib, 104L, new Configuration());
        try {
            for (i = 0; i < 100; ++i) {
                if (17 == i) {
                    TestIFileStreams.assertEquals((int)18, (int)ifis.read());
                    continue;
                }
                TestIFileStreams.assertEquals((int)i, (int)ifis.read());
            }
            ifis.close();
        }
        catch (ChecksumException e) {
            TestIFileStreams.assertEquals((String)"Unexpected bad checksum", (int)99, (int)i);
            return;
        }
        TestIFileStreams.fail((String)"Did not detect bad data in checksum");
    }

    public void testBadLength() throws Exception {
        int DLEN = 100;
        DataOutputBuffer dob = new DataOutputBuffer(104);
        IFileOutputStream ifos = new IFileOutputStream((OutputStream)dob);
        for (int i = 0; i < 100; ++i) {
            ifos.write(i);
        }
        ifos.close();
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(dob.getData(), 104);
        IFileInputStream ifis = new IFileInputStream((InputStream)dib, 100L, new Configuration());
        int i = 0;
        try {
            while (i < 92) {
                TestIFileStreams.assertEquals((int)i++, (int)ifis.read());
            }
            ifis.close();
        }
        catch (ChecksumException e) {
            TestIFileStreams.assertEquals((String)"Checksum before close", (int)i, (int)92);
            return;
        }
        TestIFileStreams.fail((String)"Did not detect bad data in checksum");
    }
}

