/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import java.nio.ByteBuffer;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.LocalJobRunner;
import org.apache.hadoop.mapred.ResourceMgrDelegate;
import org.apache.hadoop.mapred.YARNRunner;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.TestYarnClientProtocolProvider;
import org.apache.hadoop.mapreduce.protocol.ClientProtocol;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestYarnClientProtocolProvider
extends TestCase {
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClusterWithYarnClientProtocolProvider() throws Exception {
        Configuration conf = new Configuration(false);
        Cluster cluster = null;
        try {
            cluster = new Cluster(conf);
        }
        catch (Exception e) {
            throw new Exception("Failed to initialize a local runner w/o a cluster framework key", e);
        }
        try {
            TestYarnClientProtocolProvider.assertTrue((String)"client is not a LocalJobRunner", (boolean)(cluster.getClient() instanceof LocalJobRunner));
        }
        finally {
            if (cluster != null) {
                cluster.close();
            }
        }
        try {
            conf = new Configuration();
            conf.set("mapreduce.framework.name", "yarn");
            cluster = new Cluster(conf);
            ClientProtocol client = cluster.getClient();
            TestYarnClientProtocolProvider.assertTrue((String)"client is a YARNRunner", (boolean)(client instanceof YARNRunner));
        }
        catch (IOException iOException) {
        }
        finally {
            if (cluster != null) {
                cluster.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClusterGetDelegationToken() throws Exception {
        Configuration conf = new Configuration(false);
        try (Cluster cluster = null;){
            conf = new Configuration();
            conf.set("mapreduce.framework.name", "yarn");
            cluster = new Cluster(conf);
            YARNRunner yrunner = (YARNRunner)cluster.getClient();
            GetDelegationTokenResponse getDTResponse = (GetDelegationTokenResponse)recordFactory.newRecordInstance(GetDelegationTokenResponse.class);
            org.apache.hadoop.yarn.api.records.Token rmDTToken = (org.apache.hadoop.yarn.api.records.Token)recordFactory.newRecordInstance(org.apache.hadoop.yarn.api.records.Token.class);
            rmDTToken.setIdentifier(ByteBuffer.wrap(new byte[2]));
            rmDTToken.setKind("Testclusterkind");
            rmDTToken.setPassword(ByteBuffer.wrap("testcluster".getBytes()));
            rmDTToken.setService("0.0.0.0:8032");
            getDTResponse.setRMDelegationToken(rmDTToken);
            ApplicationClientProtocol cRMProtocol = (ApplicationClientProtocol)Mockito.mock(ApplicationClientProtocol.class);
            Mockito.when((Object)cRMProtocol.getDelegationToken((GetDelegationTokenRequest)Matchers.any(GetDelegationTokenRequest.class))).thenReturn((Object)getDTResponse);
            1 rmgrDelegate = new /* Unavailable Anonymous Inner Class!! */;
            yrunner.setResourceMgrDelegate((ResourceMgrDelegate)rmgrDelegate);
            Token t = cluster.getDelegationToken(new Text(" "));
            TestYarnClientProtocolProvider.assertTrue((String)("Token kind is instead " + t.getKind().toString()), (boolean)"Testclusterkind".equals(t.getKind().toString()));
        }
    }
}

