/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.jobcontrol;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.lib.jobcontrol.ControlledJob;
import org.apache.hadoop.mapreduce.lib.jobcontrol.JobControl;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestMapReduceJobControl
extends HadoopTestCase {
    public static final Log LOG = LogFactory.getLog((String)TestMapReduceJobControl.class.getName());
    static Path rootDataDir = new Path(System.getProperty("test.build.data", "."), "TestData");
    static Path indir = new Path(rootDataDir, "indir");
    static Path outdir_1 = new Path(rootDataDir, "outdir_1");
    static Path outdir_2 = new Path(rootDataDir, "outdir_2");
    static Path outdir_3 = new Path(rootDataDir, "outdir_3");
    static Path outdir_4 = new Path(rootDataDir, "outdir_4");
    static ControlledJob cjob1 = null;
    static ControlledJob cjob2 = null;
    static ControlledJob cjob3 = null;
    static ControlledJob cjob4 = null;

    public TestMapReduceJobControl() throws IOException {
        super(1, 4, 2, 2);
    }

    private void cleanupData(Configuration conf) throws Exception {
        FileSystem fs = FileSystem.get((Configuration)conf);
        MapReduceTestUtil.cleanData((FileSystem)fs, (Path)indir);
        MapReduceTestUtil.generateData((FileSystem)fs, (Path)indir);
        MapReduceTestUtil.cleanData((FileSystem)fs, (Path)outdir_1);
        MapReduceTestUtil.cleanData((FileSystem)fs, (Path)outdir_2);
        MapReduceTestUtil.cleanData((FileSystem)fs, (Path)outdir_3);
        MapReduceTestUtil.cleanData((FileSystem)fs, (Path)outdir_4);
    }

    private JobControl createDependencies(Configuration conf, Job job1) throws Exception {
        ArrayList<ControlledJob> dependingJobs = null;
        cjob1 = new ControlledJob(job1, dependingJobs);
        Job job2 = MapReduceTestUtil.createCopyJob((Configuration)conf, (Path)outdir_2, (Path[])new Path[]{indir});
        cjob2 = new ControlledJob(job2, dependingJobs);
        Job job3 = MapReduceTestUtil.createCopyJob((Configuration)conf, (Path)outdir_3, (Path[])new Path[]{outdir_1, outdir_2});
        dependingJobs = new ArrayList<ControlledJob>();
        dependingJobs.add(cjob1);
        dependingJobs.add(cjob2);
        cjob3 = new ControlledJob(job3, dependingJobs);
        Job job4 = MapReduceTestUtil.createCopyJob((Configuration)conf, (Path)outdir_4, (Path[])new Path[]{outdir_3});
        dependingJobs = new ArrayList();
        dependingJobs.add(cjob3);
        cjob4 = new ControlledJob(job4, dependingJobs);
        JobControl theControl = new JobControl("Test");
        theControl.addJob(cjob1);
        theControl.addJob(cjob2);
        theControl.addJob(cjob3);
        theControl.addJob(cjob4);
        Thread theController = new Thread((Runnable)theControl);
        theController.start();
        return theControl;
    }

    private void waitTillAllFinished(JobControl theControl) {
        while (!theControl.allFinished()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }

    public void testJobControlWithFailJob() throws Exception {
        LOG.info((Object)"Starting testJobControlWithFailJob");
        JobConf conf = this.createJobConf();
        this.cleanupData((Configuration)conf);
        Job job1 = MapReduceTestUtil.createFailJob((Configuration)conf, (Path)outdir_1, (Path[])new Path[]{indir});
        JobControl theControl = this.createDependencies((Configuration)conf, job1);
        this.waitTillAllFinished(theControl);
        TestMapReduceJobControl.assertTrue((cjob1.getJobState() == ControlledJob.State.FAILED ? 1 : 0) != 0);
        TestMapReduceJobControl.assertTrue((cjob2.getJobState() == ControlledJob.State.SUCCESS ? 1 : 0) != 0);
        TestMapReduceJobControl.assertTrue((cjob3.getJobState() == ControlledJob.State.DEPENDENT_FAILED ? 1 : 0) != 0);
        TestMapReduceJobControl.assertTrue((cjob4.getJobState() == ControlledJob.State.DEPENDENT_FAILED ? 1 : 0) != 0);
        theControl.stop();
    }

    public void testJobControlWithKillJob() throws Exception {
        LOG.info((Object)"Starting testJobControlWithKillJob");
        JobConf conf = this.createJobConf();
        this.cleanupData((Configuration)conf);
        Job job1 = MapReduceTestUtil.createKillJob((Configuration)conf, (Path)outdir_1, (Path[])new Path[]{indir});
        JobControl theControl = this.createDependencies((Configuration)conf, job1);
        while (cjob1.getJobState() != ControlledJob.State.RUNNING) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        TestMapReduceJobControl.assertFalse((boolean)cjob1.addDependingJob(cjob2));
        theControl.suspend();
        TestMapReduceJobControl.assertTrue((theControl.getThreadState() == JobControl.ThreadState.SUSPENDED ? 1 : 0) != 0);
        theControl.resume();
        cjob1.killJob();
        this.waitTillAllFinished(theControl);
        TestMapReduceJobControl.assertTrue((cjob1.getJobState() == ControlledJob.State.FAILED ? 1 : 0) != 0);
        TestMapReduceJobControl.assertTrue((cjob2.getJobState() == ControlledJob.State.SUCCESS ? 1 : 0) != 0);
        TestMapReduceJobControl.assertTrue((cjob3.getJobState() == ControlledJob.State.DEPENDENT_FAILED ? 1 : 0) != 0);
        TestMapReduceJobControl.assertTrue((cjob4.getJobState() == ControlledJob.State.DEPENDENT_FAILED ? 1 : 0) != 0);
        theControl.stop();
    }

    public void testJobControl() throws Exception {
        LOG.info((Object)"Starting testJobControl");
        JobConf conf = this.createJobConf();
        this.cleanupData((Configuration)conf);
        Job job1 = MapReduceTestUtil.createCopyJob((Configuration)conf, (Path)outdir_1, (Path[])new Path[]{indir});
        JobControl theControl = this.createDependencies((Configuration)conf, job1);
        this.waitTillAllFinished(theControl);
        TestMapReduceJobControl.assertEquals((String)"Some jobs failed", (int)0, (int)theControl.getFailedJobList().size());
        theControl.stop();
    }

    @Test(timeout=30000L)
    public void testControlledJob() throws Exception {
        LOG.info((Object)"Starting testControlledJob");
        JobConf conf = this.createJobConf();
        this.cleanupData((Configuration)conf);
        Job job1 = MapReduceTestUtil.createCopyJob((Configuration)conf, (Path)outdir_1, (Path[])new Path[]{indir});
        JobControl theControl = this.createDependencies((Configuration)conf, job1);
        while (cjob1.getJobState() != ControlledJob.State.RUNNING) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        Assert.assertNotNull((Object)cjob1.getMapredJobId());
        this.waitTillAllFinished(theControl);
        TestMapReduceJobControl.assertEquals((String)"Some jobs failed", (int)0, (int)theControl.getFailedJobList().size());
        theControl.stop();
    }
}

