/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TestMRCJCFileInputFormat;
import org.apache.hadoop.mapred.TextInputFormat;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestMRCJCFileInputFormat
extends TestCase {
    Configuration conf = new Configuration();
    MiniDFSCluster dfs = null;
    final Path root = new Path("/TestFileInputFormat");
    final Path file1 = new Path(this.root, "file1");
    final Path dir1 = new Path(this.root, "dir1");
    final Path file2 = new Path(this.dir1, "file2");
    static final int BLOCKSIZE = 1024;
    static final byte[] databuf = new byte[1024];
    private static final String[] rack1 = new String[]{"/r1"};
    private static final String[] hosts1 = new String[]{"host1.rack1.com"};

    private MiniDFSCluster newDFSCluster(JobConf conf) throws Exception {
        return new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).racks(new String[]{"/rack0", "/rack0", "/rack1", "/rack1"}).hosts(new String[]{"host0", "host1", "host2", "host3"}).build();
    }

    public void testLocality() throws Exception {
        JobConf job = new JobConf(this.conf);
        this.dfs = this.newDFSCluster(job);
        DistributedFileSystem fs = this.dfs.getFileSystem();
        System.out.println("FileSystem " + fs.getUri());
        Path inputDir = new Path("/foo/");
        String fileName = "part-0000";
        this.createInputs((FileSystem)fs, inputDir, fileName);
        TextInputFormat.addInputPath((JobConf)job, (Path)inputDir);
        TextInputFormat inFormat = new TextInputFormat();
        inFormat.configure(job);
        InputSplit[] splits = inFormat.getSplits(job, 1);
        FileStatus fileStatus = fs.getFileStatus(new Path(inputDir, fileName));
        BlockLocation[] locations = fs.getFileBlockLocations(fileStatus, 0L, fileStatus.getLen());
        System.out.println("Made splits");
        for (int i = 0; i < splits.length; ++i) {
            FileSplit fileSplit = (FileSplit)splits[i];
            System.out.println("File split: " + fileSplit);
            for (String h : fileSplit.getLocations()) {
                System.out.println("Location: " + h);
            }
            System.out.println("Block: " + locations[i]);
            TestMRCJCFileInputFormat.assertEquals((long)locations[i].getOffset(), (long)fileSplit.getStart());
            TestMRCJCFileInputFormat.assertEquals((long)locations[i].getLength(), (long)fileSplit.getLength());
            String[] blockLocs = locations[i].getHosts();
            String[] splitLocs = fileSplit.getLocations();
            TestMRCJCFileInputFormat.assertEquals((int)2, (int)blockLocs.length);
            TestMRCJCFileInputFormat.assertEquals((int)2, (int)splitLocs.length);
            TestMRCJCFileInputFormat.assertTrue((blockLocs[0].equals(splitLocs[0]) && blockLocs[1].equals(splitLocs[1]) || blockLocs[1].equals(splitLocs[0]) && blockLocs[0].equals(splitLocs[1]) ? 1 : 0) != 0);
        }
        TestMRCJCFileInputFormat.assertEquals((String)"Expected value of mapreduce.input.fileinputformat.numinputfiles", (long)1L, (long)job.getLong("mapreduce.input.fileinputformat.numinputfiles", 0L));
    }

    private void createInputs(FileSystem fs, Path inDir, String fileName) throws IOException, TimeoutException, InterruptedException {
        Path path = new Path(inDir, fileName);
        int replication = 2;
        FSDataOutputStream out = fs.create(path, true, 4096, (short)2, 512L, null);
        for (int i = 0; i < 1000; ++i) {
            out.writeChars("Hello\n");
        }
        out.close();
        System.out.println("Wrote file");
        DFSTestUtil.waitReplication((FileSystem)fs, (Path)path, (short)2);
    }

    public void testNumInputs() throws Exception {
        JobConf job = new JobConf(this.conf);
        this.dfs = this.newDFSCluster(job);
        DistributedFileSystem fs = this.dfs.getFileSystem();
        System.out.println("FileSystem " + fs.getUri());
        Path inputDir = new Path("/foo/");
        int numFiles = 10;
        String fileNameBase = "part-0000";
        for (int i = 0; i < 10; ++i) {
            this.createInputs((FileSystem)fs, inputDir, fileNameBase + String.valueOf(i));
        }
        this.createInputs((FileSystem)fs, inputDir, "_meta");
        this.createInputs((FileSystem)fs, inputDir, "_temp");
        TextInputFormat.addInputPath((JobConf)job, (Path)inputDir);
        TextInputFormat inFormat = new TextInputFormat();
        inFormat.configure(job);
        InputSplit[] splits = inFormat.getSplits(job, 1);
        TestMRCJCFileInputFormat.assertEquals((String)"Expected value of mapreduce.input.fileinputformat.numinputfiles", (long)10L, (long)job.getLong("mapreduce.input.fileinputformat.numinputfiles", 0L));
    }

    public void testMultiLevelInput() throws Exception {
        JobConf job = new JobConf(this.conf);
        job.setBoolean("dfs.replication.considerLoad", false);
        this.dfs = new MiniDFSCluster.Builder((Configuration)job).racks(rack1).hosts(hosts1).build();
        this.dfs.waitActive();
        String namenode = this.dfs.getFileSystem().getUri().getHost() + ":" + this.dfs.getFileSystem().getUri().getPort();
        DistributedFileSystem fileSys = this.dfs.getFileSystem();
        if (!fileSys.mkdirs(this.dir1)) {
            throw new IOException("Mkdirs failed to create " + this.root.toString());
        }
        TestMRCJCFileInputFormat.writeFile((Configuration)job, (Path)this.file1, (short)1, (int)1);
        TestMRCJCFileInputFormat.writeFile((Configuration)job, (Path)this.file2, (short)1, (int)1);
        DummyFileInputFormat inFormat = new DummyFileInputFormat(this, null);
        DummyFileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{this.root});
        boolean exceptionThrown = false;
        try {
            InputSplit[] inputSplitArray = inFormat.getSplits(job, 1);
        }
        catch (Exception e) {
            exceptionThrown = true;
        }
        TestMRCJCFileInputFormat.assertTrue((String)"Exception should be thrown by default for scanning a directory with directories inside.", (boolean)exceptionThrown);
        job.setBoolean("mapreduce.input.fileinputformat.input.dir.recursive", true);
        InputSplit[] splits = inFormat.getSplits(job, 1);
        TestMRCJCFileInputFormat.assertEquals((int)splits.length, (int)2);
    }

    public void testLastInputSplitAtSplitBoundary() throws Exception {
        FileInputFormatForTest fif = new FileInputFormatForTest(this, 0x40000000L, 0x8000000L);
        JobConf job = new JobConf();
        InputSplit[] splits = fif.getSplits(job, 8);
        TestMRCJCFileInputFormat.assertEquals((int)8, (int)splits.length);
        for (int i = 0; i < splits.length; ++i) {
            InputSplit split = splits[i];
            TestMRCJCFileInputFormat.assertEquals((String)("host" + i), (String)split.getLocations()[0]);
        }
    }

    public void testLastInputSplitExceedingSplitBoundary() throws Exception {
        FileInputFormatForTest fif = new FileInputFormatForTest(this, 0x40300000L, 0x8000000L);
        JobConf job = new JobConf();
        InputSplit[] splits = fif.getSplits(job, 8);
        TestMRCJCFileInputFormat.assertEquals((int)8, (int)splits.length);
        for (int i = 0; i < splits.length; ++i) {
            InputSplit split = splits[i];
            TestMRCJCFileInputFormat.assertEquals((String)("host" + i), (String)split.getLocations()[0]);
        }
    }

    public void testLastInputSplitSingleSplit() throws Exception {
        FileInputFormatForTest fif = new FileInputFormatForTest(this, 0x6400000L, 0x8000000L);
        JobConf job = new JobConf();
        InputSplit[] splits = fif.getSplits(job, 1);
        TestMRCJCFileInputFormat.assertEquals((int)1, (int)splits.length);
        for (int i = 0; i < splits.length; ++i) {
            InputSplit split = splits[i];
            TestMRCJCFileInputFormat.assertEquals((String)("host" + i), (String)split.getLocations()[0]);
        }
    }

    static void writeFile(Configuration conf, Path name, short replication, int numBlocks) throws IOException, TimeoutException, InterruptedException {
        FileSystem fileSys = FileSystem.get((Configuration)conf);
        FSDataOutputStream stm = fileSys.create(name, true, conf.getInt("io.file.buffer.size", 4096), replication, 1024L);
        for (int i = 0; i < numBlocks; ++i) {
            stm.write(databuf);
        }
        stm.close();
        DFSTestUtil.waitReplication((FileSystem)fileSys, (Path)name, (short)replication);
    }

    public void tearDown() throws Exception {
        if (this.dfs != null) {
            this.dfs.shutdown();
            this.dfs = null;
        }
    }
}

