/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AccumulatingReducer;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.TestDFSIO;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestDFSIO
implements Tool {
    private static final Log LOG = LogFactory.getLog(TestDFSIO.class);
    private static final int DEFAULT_BUFFER_SIZE = 1000000;
    private static final String BASE_FILE_NAME = "test_io_";
    private static final String DEFAULT_RES_FILE_NAME = "TestDFSIO_results.log";
    private static final long MEGA = ByteMultiple.MB.value();
    private static final int DEFAULT_NR_BYTES = 128;
    private static final int DEFAULT_NR_FILES = 4;
    private static final String USAGE = "Usage: " + TestDFSIO.class.getSimpleName() + " [genericOptions]" + " -read [-random | -backward | -skip [-skipSize Size]] |" + " -write | -append | -truncate | -clean" + " [-compression codecClassName]" + " [-nrFiles N]" + " [-size Size[B|KB|MB|GB|TB]]" + " [-resFile resultFileName] [-bufferSize Bytes]" + " [-rootDir]";
    private Configuration config = new Configuration();
    private static MiniDFSCluster cluster;
    private static TestDFSIO bench;

    private static String getBaseDir(Configuration conf) {
        return conf.get("test.build.data", "/benchmarks/TestDFSIO");
    }

    private static Path getControlDir(Configuration conf) {
        return new Path(TestDFSIO.getBaseDir((Configuration)conf), "io_control");
    }

    private static Path getWriteDir(Configuration conf) {
        return new Path(TestDFSIO.getBaseDir((Configuration)conf), "io_write");
    }

    private static Path getReadDir(Configuration conf) {
        return new Path(TestDFSIO.getBaseDir((Configuration)conf), "io_read");
    }

    private static Path getAppendDir(Configuration conf) {
        return new Path(TestDFSIO.getBaseDir((Configuration)conf), "io_append");
    }

    private static Path getRandomReadDir(Configuration conf) {
        return new Path(TestDFSIO.getBaseDir((Configuration)conf), "io_random_read");
    }

    private static Path getTruncateDir(Configuration conf) {
        return new Path(TestDFSIO.getBaseDir((Configuration)conf), "io_truncate");
    }

    private static Path getDataDir(Configuration conf) {
        return new Path(TestDFSIO.getBaseDir((Configuration)conf), "io_data");
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        bench = new TestDFSIO();
        bench.getConf().setBoolean("dfs.support.append", true);
        bench.getConf().setInt("dfs.heartbeat.interval", 1);
        cluster = new MiniDFSCluster.Builder(bench.getConf()).numDataNodes(2).format(true).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        bench.createControlFile((FileSystem)fs, 128L, 4);
        TestDFSIO.testWrite();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        if (cluster == null) {
            return;
        }
        DistributedFileSystem fs = cluster.getFileSystem();
        bench.cleanup((FileSystem)fs);
        cluster.shutdown();
    }

    public static void testWrite() throws Exception {
        DistributedFileSystem fs = cluster.getFileSystem();
        long tStart = System.currentTimeMillis();
        bench.writeTest((FileSystem)fs);
        long execTime = System.currentTimeMillis() - tStart;
        bench.analyzeResult((FileSystem)fs, TestType.TEST_TYPE_WRITE, execTime);
    }

    @Test(timeout=10000L)
    public void testRead() throws Exception {
        DistributedFileSystem fs = cluster.getFileSystem();
        long tStart = System.currentTimeMillis();
        bench.readTest((FileSystem)fs);
        long execTime = System.currentTimeMillis() - tStart;
        bench.analyzeResult((FileSystem)fs, TestType.TEST_TYPE_READ, execTime);
    }

    @Test(timeout=10000L)
    public void testReadRandom() throws Exception {
        DistributedFileSystem fs = cluster.getFileSystem();
        long tStart = System.currentTimeMillis();
        bench.getConf().setLong("test.io.skip.size", 0L);
        bench.randomReadTest((FileSystem)fs);
        long execTime = System.currentTimeMillis() - tStart;
        bench.analyzeResult((FileSystem)fs, TestType.TEST_TYPE_READ_RANDOM, execTime);
    }

    @Test(timeout=10000L)
    public void testReadBackward() throws Exception {
        DistributedFileSystem fs = cluster.getFileSystem();
        long tStart = System.currentTimeMillis();
        bench.getConf().setLong("test.io.skip.size", -1000000L);
        bench.randomReadTest((FileSystem)fs);
        long execTime = System.currentTimeMillis() - tStart;
        bench.analyzeResult((FileSystem)fs, TestType.TEST_TYPE_READ_BACKWARD, execTime);
    }

    @Test(timeout=10000L)
    public void testReadSkip() throws Exception {
        DistributedFileSystem fs = cluster.getFileSystem();
        long tStart = System.currentTimeMillis();
        bench.getConf().setLong("test.io.skip.size", 1L);
        bench.randomReadTest((FileSystem)fs);
        long execTime = System.currentTimeMillis() - tStart;
        bench.analyzeResult((FileSystem)fs, TestType.TEST_TYPE_READ_SKIP, execTime);
    }

    @Test(timeout=10000L)
    public void testAppend() throws Exception {
        DistributedFileSystem fs = cluster.getFileSystem();
        long tStart = System.currentTimeMillis();
        bench.appendTest((FileSystem)fs);
        long execTime = System.currentTimeMillis() - tStart;
        bench.analyzeResult((FileSystem)fs, TestType.TEST_TYPE_APPEND, execTime);
    }

    @Test(timeout=60000L)
    public void testTruncate() throws Exception {
        DistributedFileSystem fs = cluster.getFileSystem();
        bench.createControlFile((FileSystem)fs, 64L, 4);
        long tStart = System.currentTimeMillis();
        bench.truncateTest((FileSystem)fs);
        long execTime = System.currentTimeMillis() - tStart;
        bench.analyzeResult((FileSystem)fs, TestType.TEST_TYPE_TRUNCATE, execTime);
    }

    private void createControlFile(FileSystem fs, long nrBytes, int nrFiles) throws IOException {
        LOG.info((Object)("creating control file: " + nrBytes + " bytes, " + nrFiles + " files"));
        Path controlDir = TestDFSIO.getControlDir((Configuration)this.config);
        fs.delete(controlDir, true);
        for (int i = 0; i < nrFiles; ++i) {
            String name = TestDFSIO.getFileName((int)i);
            Path controlFile = new Path(controlDir, "in_file_" + name);
            SequenceFile.Writer writer = null;
            try {
                writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)this.config, (Path)controlFile, Text.class, LongWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
                writer.append((Writable)new Text(name), (Writable)new LongWritable(nrBytes));
                continue;
            }
            catch (Exception e) {
                throw new IOException(e.getLocalizedMessage());
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
                writer = null;
            }
        }
        LOG.info((Object)("created control files for: " + nrFiles + " files"));
    }

    private static String getFileName(int fIdx) {
        return "test_io_" + Integer.toString(fIdx);
    }

    private void writeTest(FileSystem fs) throws IOException {
        Path writeDir = TestDFSIO.getWriteDir((Configuration)this.config);
        fs.delete(TestDFSIO.getDataDir((Configuration)this.config), true);
        fs.delete(writeDir, true);
        this.runIOTest(WriteMapper.class, writeDir);
    }

    private void runIOTest(Class<? extends Mapper<Text, LongWritable, Text, Text>> mapperClass, Path outputDir) throws IOException {
        JobConf job = new JobConf(this.config, TestDFSIO.class);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{TestDFSIO.getControlDir((Configuration)this.config)});
        job.setInputFormat(SequenceFileInputFormat.class);
        job.setMapperClass(mapperClass);
        job.setReducerClass(AccumulatingReducer.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outputDir);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setNumReduceTasks(1);
        JobClient.runJob((JobConf)job);
    }

    private void appendTest(FileSystem fs) throws IOException {
        Path appendDir = TestDFSIO.getAppendDir((Configuration)this.config);
        fs.delete(appendDir, true);
        this.runIOTest(AppendMapper.class, appendDir);
    }

    private void readTest(FileSystem fs) throws IOException {
        Path readDir = TestDFSIO.getReadDir((Configuration)this.config);
        fs.delete(readDir, true);
        this.runIOTest(ReadMapper.class, readDir);
    }

    private void randomReadTest(FileSystem fs) throws IOException {
        Path readDir = TestDFSIO.getRandomReadDir((Configuration)this.config);
        fs.delete(readDir, true);
        this.runIOTest(RandomReadMapper.class, readDir);
    }

    private void truncateTest(FileSystem fs) throws IOException {
        Path TruncateDir = TestDFSIO.getTruncateDir((Configuration)this.config);
        fs.delete(TruncateDir, true);
        this.runIOTest(TruncateMapper.class, TruncateDir);
    }

    private void sequentialTest(FileSystem fs, TestType testType, long fileSize, int nrFiles) throws IOException {
        ReadMapper ioer = null;
        switch (1.$SwitchMap$org$apache$hadoop$fs$TestDFSIO$TestType[testType.ordinal()]) {
            case 1: {
                ioer = new ReadMapper();
                break;
            }
            case 2: {
                ioer = new WriteMapper();
                break;
            }
            case 3: {
                ioer = new AppendMapper();
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                ioer = new RandomReadMapper();
                break;
            }
            case 7: {
                ioer = new TruncateMapper();
                break;
            }
            default: {
                return;
            }
        }
        for (int i = 0; i < nrFiles; ++i) {
            ioer.doIO(Reporter.NULL, "test_io_" + Integer.toString(i), fileSize);
        }
    }

    public static void main(String[] args) {
        TestDFSIO bench = new TestDFSIO();
        int res = -1;
        try {
            res = ToolRunner.run((Tool)bench, (String[])args);
        }
        catch (Exception e) {
            System.err.print(StringUtils.stringifyException((Throwable)e));
            res = -2;
        }
        if (res == -1) {
            System.err.print(USAGE);
        }
        System.exit(res);
    }

    public int run(String[] args) throws IOException {
        TestType testType = null;
        int bufferSize = 1000000;
        long nrBytes = 1L * MEGA;
        int nrFiles = 1;
        long skipSize = 0L;
        String resFileName = "TestDFSIO_results.log";
        String compressionClass = null;
        boolean isSequential = false;
        String version = TestDFSIO.class.getSimpleName() + ".1.8";
        LOG.info((Object)version);
        if (args.length == 0) {
            System.err.println("Missing arguments.");
            return -1;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-read")) {
                testType = TestType.TEST_TYPE_READ;
                continue;
            }
            if (args[i].equals("-write")) {
                testType = TestType.TEST_TYPE_WRITE;
                continue;
            }
            if (args[i].equals("-append")) {
                testType = TestType.TEST_TYPE_APPEND;
                continue;
            }
            if (args[i].equals("-random")) {
                if (testType != TestType.TEST_TYPE_READ) {
                    return -1;
                }
                testType = TestType.TEST_TYPE_READ_RANDOM;
                continue;
            }
            if (args[i].equals("-backward")) {
                if (testType != TestType.TEST_TYPE_READ) {
                    return -1;
                }
                testType = TestType.TEST_TYPE_READ_BACKWARD;
                continue;
            }
            if (args[i].equals("-skip")) {
                if (testType != TestType.TEST_TYPE_READ) {
                    return -1;
                }
                testType = TestType.TEST_TYPE_READ_SKIP;
                continue;
            }
            if (args[i].equalsIgnoreCase("-truncate")) {
                testType = TestType.TEST_TYPE_TRUNCATE;
                continue;
            }
            if (args[i].equals("-clean")) {
                testType = TestType.TEST_TYPE_CLEANUP;
                continue;
            }
            if (args[i].startsWith("-seq")) {
                isSequential = true;
                continue;
            }
            if (args[i].startsWith("-compression")) {
                compressionClass = args[++i];
                continue;
            }
            if (args[i].equals("-nrFiles")) {
                nrFiles = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-fileSize") || args[i].equals("-size")) {
                nrBytes = TestDFSIO.parseSize((String)args[++i]);
                continue;
            }
            if (args[i].equals("-skipSize")) {
                skipSize = TestDFSIO.parseSize((String)args[++i]);
                continue;
            }
            if (args[i].equals("-bufferSize")) {
                bufferSize = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-resFile")) {
                resFileName = args[++i];
                continue;
            }
            System.err.println("Illegal argument: " + args[i]);
            return -1;
        }
        if (testType == null) {
            return -1;
        }
        if (testType == TestType.TEST_TYPE_READ_BACKWARD) {
            skipSize = -bufferSize;
        } else if (testType == TestType.TEST_TYPE_READ_SKIP && skipSize == 0L) {
            skipSize = bufferSize;
        }
        LOG.info((Object)("nrFiles = " + nrFiles));
        LOG.info((Object)("nrBytes (MB) = " + TestDFSIO.toMB((long)nrBytes)));
        LOG.info((Object)("bufferSize = " + bufferSize));
        if (skipSize > 0L) {
            LOG.info((Object)("skipSize = " + skipSize));
        }
        LOG.info((Object)("baseDir = " + TestDFSIO.getBaseDir((Configuration)this.config)));
        if (compressionClass != null) {
            this.config.set("test.io.compression.class", compressionClass);
            LOG.info((Object)("compressionClass = " + compressionClass));
        }
        this.config.setInt("test.io.file.buffer.size", bufferSize);
        this.config.setLong("test.io.skip.size", skipSize);
        this.config.setBoolean("dfs.support.append", true);
        FileSystem fs = FileSystem.get((Configuration)this.config);
        if (isSequential) {
            long tStart = System.currentTimeMillis();
            this.sequentialTest(fs, testType, nrBytes, nrFiles);
            long execTime = System.currentTimeMillis() - tStart;
            String resultLine = "Seq Test exec time sec: " + (float)execTime / 1000.0f;
            LOG.info((Object)resultLine);
            return 0;
        }
        if (testType == TestType.TEST_TYPE_CLEANUP) {
            this.cleanup(fs);
            return 0;
        }
        this.createControlFile(fs, nrBytes, nrFiles);
        long tStart = System.currentTimeMillis();
        switch (1.$SwitchMap$org$apache$hadoop$fs$TestDFSIO$TestType[testType.ordinal()]) {
            case 2: {
                this.writeTest(fs);
                break;
            }
            case 1: {
                this.readTest(fs);
                break;
            }
            case 3: {
                this.appendTest(fs);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.randomReadTest(fs);
                break;
            }
            case 7: {
                this.truncateTest(fs);
                break;
            }
        }
        long execTime = System.currentTimeMillis() - tStart;
        this.analyzeResult(fs, testType, execTime, resFileName);
        return 0;
    }

    public Configuration getConf() {
        return this.config;
    }

    public void setConf(Configuration conf) {
        this.config = conf;
    }

    static long parseSize(String arg) {
        String[] args = arg.split("\\D", 2);
        assert (args.length <= 2);
        long nrBytes = Long.parseLong(args[0]);
        String bytesMult = arg.substring(args[0].length());
        return nrBytes * ByteMultiple.parseString((String)bytesMult).value();
    }

    static float toMB(long bytes) {
        return (float)bytes / (float)MEGA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeResult(FileSystem fs, TestType testType, long execTime, String resFileName) throws IOException {
        Path reduceFile = this.getReduceFilePath(testType);
        long tasks = 0L;
        long size = 0L;
        long time = 0L;
        float rate = 0.0f;
        float sqrate = 0.0f;
        FilterInputStream in = null;
        BufferedReader lines = null;
        try {
            String line;
            in = new DataInputStream((InputStream)fs.open(reduceFile));
            lines = new BufferedReader(new InputStreamReader(in));
            while ((line = lines.readLine()) != null) {
                StringTokenizer tokens = new StringTokenizer(line, " \t\n\r\f%");
                String attr = tokens.nextToken();
                if (attr.endsWith(":tasks")) {
                    tasks = Long.parseLong(tokens.nextToken());
                    continue;
                }
                if (attr.endsWith(":size")) {
                    size = Long.parseLong(tokens.nextToken());
                    continue;
                }
                if (attr.endsWith(":time")) {
                    time = Long.parseLong(tokens.nextToken());
                    continue;
                }
                if (attr.endsWith(":rate")) {
                    rate = Float.parseFloat(tokens.nextToken());
                    continue;
                }
                if (!attr.endsWith(":sqrate")) continue;
                sqrate = Float.parseFloat(tokens.nextToken());
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (lines != null) {
                lines.close();
            }
        }
        double med = rate / 1000.0f / (float)tasks;
        double stdDev = Math.sqrt(Math.abs((double)(sqrate / 1000.0f / (float)tasks) - med * med));
        String[] resultLines = new String[]{"----- TestDFSIO ----- : " + testType, "           Date & time: " + new Date(System.currentTimeMillis()), "       Number of files: " + tasks, "Total MBytes processed: " + TestDFSIO.toMB((long)size), "     Throughput mb/sec: " + (double)size * 1000.0 / (double)(time * MEGA), "Average IO rate mb/sec: " + med, " IO rate std deviation: " + stdDev, "    Test exec time sec: " + (float)execTime / 1000.0f, ""};
        try (PrintStream res = null;){
            res = new PrintStream(new FileOutputStream(new File(resFileName), true));
            for (int i = 0; i < resultLines.length; ++i) {
                LOG.info((Object)resultLines[i]);
                res.println(resultLines[i]);
            }
        }
    }

    private Path getReduceFilePath(TestType testType) {
        switch (1.$SwitchMap$org$apache$hadoop$fs$TestDFSIO$TestType[testType.ordinal()]) {
            case 2: {
                return new Path(TestDFSIO.getWriteDir((Configuration)this.config), "part-00000");
            }
            case 3: {
                return new Path(TestDFSIO.getAppendDir((Configuration)this.config), "part-00000");
            }
            case 1: {
                return new Path(TestDFSIO.getReadDir((Configuration)this.config), "part-00000");
            }
            case 4: 
            case 5: 
            case 6: {
                return new Path(TestDFSIO.getRandomReadDir((Configuration)this.config), "part-00000");
            }
            case 7: {
                return new Path(TestDFSIO.getTruncateDir((Configuration)this.config), "part-00000");
            }
        }
        return null;
    }

    private void analyzeResult(FileSystem fs, TestType testType, long execTime) throws IOException {
        String dir = System.getProperty("test.build.dir", "target/test-dir");
        this.analyzeResult(fs, testType, execTime, dir + "/" + "TestDFSIO_results.log");
    }

    private void cleanup(FileSystem fs) throws IOException {
        LOG.info((Object)"Cleaning up test files");
        fs.delete(new Path(TestDFSIO.getBaseDir((Configuration)this.config)), true);
    }

    static /* synthetic */ long access$000() {
        return MEGA;
    }

    static /* synthetic */ Log access$100() {
        return LOG;
    }

    static /* synthetic */ Path access$200(Configuration x0) {
        return TestDFSIO.getDataDir((Configuration)x0);
    }

    static {
        Configuration.addDefaultResource((String)"hdfs-default.xml");
        Configuration.addDefaultResource((String)"hdfs-site.xml");
        Configuration.addDefaultResource((String)"mapred-default.xml");
        Configuration.addDefaultResource((String)"mapred-site.xml");
    }
}

