/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.loadGenerator;

import java.io.IOException;
import java.io.PrintStream;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.loadGenerator.LoadGenerator;
import org.apache.hadoop.fs.loadGenerator.LoadGeneratorMR;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class LoadGeneratorMR
extends LoadGenerator {
    public static final Log LOG = LogFactory.getLog(LoadGenerator.class);
    private static int numMapTasks = 1;
    private String mrOutDir;
    private static final String USAGE_CMD = "java LoadGeneratorMR\n";
    private static final String USAGE = "java LoadGeneratorMR\n-mr <numMapJobs> <outputDir> [MUST be first 3 args] \n-readProbability <read probability>\n-writeProbability <write probability>\n-root <root>\n-maxDelayBetweenOps <maxDelayBetweenOpsInMillis>\n-numOfThreads <numOfThreads>\n-elapsedTime <elapsedTimeInSecs>\n-startTime <startTimeInMillis>\n-scriptFile <filename>\n-flagFile <filename>";
    private static final Text OPEN_EXECTIME = new Text("OpenExecutionTime");
    private static final Text NUMOPS_OPEN = new Text("NumOpsOpen");
    private static final Text LIST_EXECTIME = new Text("ListExecutionTime");
    private static final Text NUMOPS_LIST = new Text("NumOpsList");
    private static final Text DELETE_EXECTIME = new Text("DeletionExecutionTime");
    private static final Text NUMOPS_DELETE = new Text("NumOpsDelete");
    private static final Text CREATE_EXECTIME = new Text("CreateExecutionTime");
    private static final Text NUMOPS_CREATE = new Text("NumOpsCreate");
    private static final Text WRITE_CLOSE_EXECTIME = new Text("WriteCloseExecutionTime");
    private static final Text NUMOPS_WRITE_CLOSE = new Text("NumOpsWriteClose");
    private static final Text ELAPSED_TIME = new Text("ElapsedTime");
    private static final Text TOTALOPS = new Text("TotalOps");
    private static final String LG_ROOT = "LG.root";
    private static final String LG_SCRIPTFILE = "LG.scriptFile";
    private static final String LG_MAXDELAYBETWEENOPS = "LG.maxDelayBetweenOps";
    private static final String LG_NUMOFTHREADS = "LG.numOfThreads";
    private static final String LG_READPR = "LG.readPr";
    private static final String LG_WRITEPR = "LG.writePr";
    private static final String LG_SEED = "LG.r";
    private static final String LG_NUMMAPTASKS = "LG.numMapTasks";
    private static final String LG_ELAPSEDTIME = "LG.elapsedTime";
    private static final String LG_STARTTIME = "LG.startTime";
    private static final String LG_FLAGFILE = "LG.flagFile";

    public LoadGeneratorMR() throws IOException, UnknownHostException {
    }

    public LoadGeneratorMR(Configuration conf) throws IOException, UnknownHostException {
        this();
        this.setConf(conf);
    }

    public int run(String[] args) throws Exception {
        int exitCode = this.parseArgsMR(args);
        if (exitCode != 0) {
            return exitCode;
        }
        System.out.println("Running LoadGeneratorMR against fileSystem: " + FileContext.getFileContext().getDefaultFileSystem().getUri());
        return this.submitAsMapReduce();
    }

    private int parseArgsMR(String[] args) throws IOException {
        try {
            if (args.length >= 3 && args[0].equals("-mr")) {
                numMapTasks = Integer.parseInt(args[1]);
                this.mrOutDir = args[2];
                if (this.mrOutDir.startsWith("-")) {
                    System.err.println("Missing output file parameter, instead got: " + this.mrOutDir);
                    System.err.println(USAGE);
                    return -1;
                }
            } else {
                System.err.println(USAGE);
                ToolRunner.printGenericCommandUsage((PrintStream)System.err);
                return -1;
            }
            String[] strippedArgs = new String[args.length - 3];
            for (int i = 0; i < strippedArgs.length; ++i) {
                strippedArgs[i] = args[i + 3];
            }
            super.parseArgs(true, strippedArgs);
        }
        catch (NumberFormatException e) {
            System.err.println("Illegal parameter: " + e.getLocalizedMessage());
            System.err.println(USAGE);
            return -1;
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new LoadGeneratorMR(), (String[])args);
        System.exit(res);
    }

    private int submitAsMapReduce() {
        System.out.println("Running as a MapReduce job with " + numMapTasks + " mapTasks;  Output to file " + this.mrOutDir);
        Configuration conf = new Configuration(this.getConf());
        conf.set(LG_ROOT, root.toString());
        conf.setInt(LG_MAXDELAYBETWEENOPS, maxDelayBetweenOps);
        conf.setInt(LG_NUMOFTHREADS, numOfThreads);
        conf.set(LG_READPR, readProbs[0] + "");
        conf.set(LG_WRITEPR, writeProbs[0] + "");
        conf.setLong(LG_SEED, seed);
        conf.setInt(LG_NUMMAPTASKS, numMapTasks);
        if (scriptFile == null && durations[0] <= 0L) {
            System.err.println("When run as a MapReduce job, elapsed Time or ScriptFile must be specified");
            System.exit(-1);
        }
        conf.setLong(LG_ELAPSEDTIME, durations[0]);
        conf.setLong(LG_STARTTIME, startTime);
        if (scriptFile != null) {
            conf.set(LG_SCRIPTFILE, scriptFile);
        }
        conf.set(LG_FLAGFILE, flagFile.toString());
        JobConf jobConf = new JobConf(conf, LoadGenerator.class);
        jobConf.setJobName("NNLoadGeneratorViaMR");
        jobConf.setNumMapTasks(numMapTasks);
        jobConf.setNumReduceTasks(1);
        jobConf.setOutputKeyClass(Text.class);
        jobConf.setOutputValueClass(IntWritable.class);
        jobConf.setMapperClass(MapperThatRunsNNLoadGenerator.class);
        jobConf.setReducerClass(ReducerThatCollectsLGdata.class);
        jobConf.setInputFormat(DummyInputFormat.class);
        jobConf.setOutputFormat(TextOutputFormat.class);
        jobConf.setMaxMapAttempts(1);
        jobConf.setSpeculativeExecution(false);
        FileOutputFormat.setOutputPath((JobConf)jobConf, (Path)new Path(this.mrOutDir));
        try {
            JobClient.runJob((JobConf)jobConf);
        }
        catch (IOException e) {
            System.err.println("Failed to run job: " + e.getMessage());
            return -1;
        }
        return 0;
    }

    static /* synthetic */ Text access$000() {
        return OPEN_EXECTIME;
    }

    static /* synthetic */ Text access$100() {
        return NUMOPS_OPEN;
    }

    static /* synthetic */ Text access$200() {
        return LIST_EXECTIME;
    }

    static /* synthetic */ Text access$300() {
        return NUMOPS_LIST;
    }

    static /* synthetic */ Text access$400() {
        return DELETE_EXECTIME;
    }

    static /* synthetic */ Text access$500() {
        return NUMOPS_DELETE;
    }

    static /* synthetic */ Text access$600() {
        return CREATE_EXECTIME;
    }

    static /* synthetic */ Text access$700() {
        return NUMOPS_CREATE;
    }

    static /* synthetic */ Text access$800() {
        return WRITE_CLOSE_EXECTIME;
    }

    static /* synthetic */ Text access$900() {
        return NUMOPS_WRITE_CLOSE;
    }

    static /* synthetic */ Text access$1000() {
        return TOTALOPS;
    }

    static /* synthetic */ Text access$1100() {
        return ELAPSED_TIME;
    }

    static /* synthetic */ int access$1202(int x0) {
        numMapTasks = x0;
        return numMapTasks;
    }

    static /* synthetic */ int access$1200() {
        return numMapTasks;
    }
}

