/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import org.apache.commons.cli.Option;

class ConfigOption<T>
extends Option {
    private static final long serialVersionUID = 7218954906367671150L;
    private static final String SLIVE_PREFIX = "slive";
    static final ConfigOption<Integer> MAPS = new ConfigOption("maps", true, "Number of maps", "slive.maps", (Object)10);
    static final ConfigOption<Integer> REDUCES = new ConfigOption("reduces", true, "Number of reduces", "slive.reduces", (Object)1);
    static final ConfigOption<Integer> OPS = new ConfigOption("ops", true, "Max number of operations per map", "slive.map.ops", (Object)1000);
    static final ConfigOption<Integer> DURATION = new ConfigOption("duration", true, "Duration of a map task in seconds (MAX_INT for no limit)", "slive.duration", (Object)Integer.MAX_VALUE);
    static final ConfigOption<Boolean> EXIT_ON_ERROR = new ConfigOption("exitOnError", false, "Exit on first error", "slive.exit.on.error", (Object)false);
    static final ConfigOption<Integer> FILES = new ConfigOption("files", true, "Max total number of files", "slive.total.files", (Object)10);
    static final ConfigOption<Integer> DIR_SIZE = new ConfigOption("dirSize", true, "Max files per directory", "slive.dir.size", (Object)32);
    static final ConfigOption<String> BASE_DIR = new ConfigOption("baseDir", true, "Base directory path", "slive.base.dir", (Object)"/test/slive");
    static final ConfigOption<String> RESULT_FILE = new ConfigOption("resFile", true, "Result file name", "slive.result.file", (Object)"part-0000");
    static final ConfigOption<Short> REPLICATION_AM = new ConfigOption("replication", true, "Min,max value for replication amount", "slive.file.replication", (Object)3);
    static final ConfigOption<Long> BLOCK_SIZE = new ConfigOption("blockSize", true, "Min,max for dfs file block size", "slive.block.size", (Object)0x4000000L);
    static final ConfigOption<Long> READ_SIZE = new ConfigOption("readSize", true, "Min,max for size to read (min=max=MAX_LONG=read entire file)", "slive.op.read.size", null);
    static final ConfigOption<Long> WRITE_SIZE = new ConfigOption("writeSize", true, "Min,max for size to write (min=max=MAX_LONG=blocksize)", "slive.op.write.size", null);
    static final ConfigOption<Long> SLEEP_TIME = new ConfigOption("sleep", true, "Min,max for millisecond of random sleep to perform (between operations)", "slive.op.sleep.range", null);
    static final ConfigOption<Long> APPEND_SIZE = new ConfigOption("appendSize", true, "Min,max for size to append (min=max=MAX_LONG=blocksize)", "slive.op.append.size", null);
    static final ConfigOption<Boolean> TRUNCATE_WAIT = new ConfigOption("truncateWait", true, "Should wait for truncate recovery", "slive.op.truncate.wait", (Object)true);
    static final ConfigOption<Long> TRUNCATE_SIZE = new ConfigOption("truncateSize", true, "Min,max for size to truncate (min=max=MAX_LONG=blocksize)", "slive.op.truncate.size", null);
    static final ConfigOption<Long> RANDOM_SEED = new ConfigOption("seed", true, "Random number seed", "slive.seed", null);
    static final Option HELP = new Option("help", false, "Usage information");
    static final Option CLEANUP = new Option("cleanup", true, "Cleanup & remove directory after reporting");
    static final ConfigOption<String> QUEUE_NAME = new ConfigOption("queue", true, "Queue name", "mapred.job.queue.name", (Object)"default");
    static final ConfigOption<String> PACKET_SIZE = new ConfigOption("packetSize", true, "Dfs write packet size", "dfs.write.packet.size", null);
    private String cfgOption;
    private T defaultValue;

    ConfigOption(String cliOption, boolean hasArg, String description, String cfgOption, T def) {
        super(cliOption, hasArg, description);
        this.cfgOption = cfgOption;
        this.defaultValue = def;
    }

    String getCfgOption() {
        return this.cfgOption;
    }

    T getDefault() {
        return (T)this.defaultValue;
    }
}

