/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.slive.ConfigExtractor;
import org.apache.hadoop.fs.slive.Constants;
import org.apache.hadoop.fs.slive.Formatter;
import org.apache.hadoop.fs.slive.ObserveableOp;
import org.apache.hadoop.fs.slive.Operation;
import org.apache.hadoop.fs.slive.OperationData;
import org.apache.hadoop.fs.slive.OperationFactory;
import org.apache.hadoop.fs.slive.OperationWeight;
import org.apache.hadoop.fs.slive.RouletteSelector;
import org.apache.hadoop.fs.slive.WeightSelector;
import org.apache.hadoop.fs.slive.Weights;

/*
 * Exception performing whole class analysis ignored.
 */
class WeightSelector {
    private static final Log LOG = LogFactory.getLog(WeightSelector.class);
    private Map<Constants.OperationType, OperationInfo> operations;
    private Map<Constants.Distribution, Weightable> weights;
    private RouletteSelector selector;
    private OperationFactory factory;

    WeightSelector(ConfigExtractor cfg, Random rnd) {
        this.selector = new RouletteSelector(rnd);
        this.factory = new OperationFactory(cfg, rnd);
        this.configureOperations(cfg);
        this.configureWeights(cfg);
    }

    protected RouletteSelector getSelector() {
        return this.selector;
    }

    private void configureWeights(ConfigExtractor e) {
        this.weights = new HashMap();
        this.weights.put(Constants.Distribution.UNIFORM, new Weights.UniformWeight());
    }

    static int determineHowMany(int totalAm, OperationData opData, Constants.OperationType type) {
        if (totalAm <= 0) {
            return 0;
        }
        int amLeft = (int)Math.floor(opData.getPercent() * (double)totalAm);
        if (amLeft < 0) {
            throw new IllegalArgumentException("Invalid amount " + amLeft + " determined for operation type " + type.name());
        }
        return amLeft;
    }

    private void configureOperations(ConfigExtractor cfg) {
        int totalAm;
        this.operations = new TreeMap();
        Map opinfo = cfg.getOperations();
        int opsLeft = totalAm = cfg.getOpCount().intValue();
        NumberFormat formatter = Formatter.getPercentFormatter();
        for (Constants.OperationType type : opinfo.keySet()) {
            OperationData opData = (OperationData)opinfo.get(type);
            OperationInfo info = new OperationInfo(null);
            info.distribution = opData.getDistribution();
            int amLeft = WeightSelector.determineHowMany((int)totalAm, (OperationData)opData, (Constants.OperationType)type);
            opsLeft -= amLeft;
            LOG.info((Object)(type.name() + " has " + amLeft + " initial operations out of " + totalAm + " for its ratio " + formatter.format(opData.getPercent())));
            info.amountLeft = amLeft;
            Operation op = this.factory.getOperation(type);
            if (op == null) continue;
            1 fn = new /* Unavailable Anonymous Inner Class!! */;
            info.operation = new ObserveableOp(op, (ObserveableOp.Observer)fn);
            this.operations.put(type, info);
        }
        if (opsLeft > 0) {
            LOG.info((Object)(opsLeft + " left over operations found (due to inability to support partial operations)"));
        }
    }

    Operation select(int elapsed, int duration) {
        ArrayList<OperationWeight> validOps = new ArrayList<OperationWeight>(this.operations.size());
        for (Constants.OperationType type : this.operations.keySet()) {
            OperationInfo opinfo = (OperationInfo)this.operations.get(type);
            if (opinfo == null || opinfo.amountLeft <= 0) continue;
            Weightable weighter = (Weightable)this.weights.get(opinfo.distribution);
            if (weighter != null) {
                OperationWeight weightOp = new OperationWeight(opinfo.operation, weighter.weight(elapsed, duration).doubleValue());
                validOps.add(weightOp);
                continue;
            }
            throw new RuntimeException("Unable to get weight for distribution " + opinfo.distribution);
        }
        if (validOps.isEmpty()) {
            return null;
        }
        return this.getSelector().select(validOps);
    }

    static /* synthetic */ Map access$100(WeightSelector x0) {
        return x0.operations;
    }
}

