/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.mapred.TestResourceMgrDelegate;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.Records;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class TestResourceMgrDelegate {
    @Test
    public void testGetRootQueues() throws IOException, InterruptedException {
        ApplicationClientProtocol applicationsManager = (ApplicationClientProtocol)Mockito.mock(ApplicationClientProtocol.class);
        GetQueueInfoResponse response = (GetQueueInfoResponse)Mockito.mock(GetQueueInfoResponse.class);
        QueueInfo queueInfo = (QueueInfo)Mockito.mock(QueueInfo.class);
        Mockito.when((Object)response.getQueueInfo()).thenReturn((Object)queueInfo);
        try {
            Mockito.when((Object)applicationsManager.getQueueInfo((GetQueueInfoRequest)Mockito.any(GetQueueInfoRequest.class))).thenReturn((Object)response);
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
        1 delegate = new /* Unavailable Anonymous Inner Class!! */;
        delegate.getRootQueues();
        ArgumentCaptor argument = ArgumentCaptor.forClass(GetQueueInfoRequest.class);
        try {
            ((ApplicationClientProtocol)Mockito.verify((Object)applicationsManager)).getQueueInfo((GetQueueInfoRequest)argument.capture());
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
        Assert.assertTrue((String)"Children of root queue not requested", (boolean)((GetQueueInfoRequest)argument.getValue()).getIncludeChildQueues());
        Assert.assertTrue((String)"Request wasn't to recurse through children", (boolean)((GetQueueInfoRequest)argument.getValue()).getRecursive());
    }

    @Test
    public void tesAllJobs() throws Exception {
        ApplicationClientProtocol applicationsManager = (ApplicationClientProtocol)Mockito.mock(ApplicationClientProtocol.class);
        GetApplicationsResponse allApplicationsResponse = (GetApplicationsResponse)Records.newRecord(GetApplicationsResponse.class);
        ArrayList<ApplicationReport> applications = new ArrayList<ApplicationReport>();
        applications.add(this.getApplicationReport(YarnApplicationState.FINISHED, FinalApplicationStatus.FAILED));
        applications.add(this.getApplicationReport(YarnApplicationState.FINISHED, FinalApplicationStatus.SUCCEEDED));
        applications.add(this.getApplicationReport(YarnApplicationState.FINISHED, FinalApplicationStatus.KILLED));
        applications.add(this.getApplicationReport(YarnApplicationState.FAILED, FinalApplicationStatus.FAILED));
        allApplicationsResponse.setApplicationList(applications);
        Mockito.when((Object)applicationsManager.getApplications((GetApplicationsRequest)Mockito.any(GetApplicationsRequest.class))).thenReturn((Object)allApplicationsResponse);
        2 resourceMgrDelegate = new /* Unavailable Anonymous Inner Class!! */;
        JobStatus[] allJobs = resourceMgrDelegate.getAllJobs();
        Assert.assertEquals((Object)JobStatus.State.FAILED, (Object)allJobs[0].getState());
        Assert.assertEquals((Object)JobStatus.State.SUCCEEDED, (Object)allJobs[1].getState());
        Assert.assertEquals((Object)JobStatus.State.KILLED, (Object)allJobs[2].getState());
        Assert.assertEquals((Object)JobStatus.State.FAILED, (Object)allJobs[3].getState());
    }

    private ApplicationReport getApplicationReport(YarnApplicationState yarnApplicationState, FinalApplicationStatus finalApplicationStatus) {
        ApplicationReport appReport = (ApplicationReport)Mockito.mock(ApplicationReport.class);
        ApplicationResourceUsageReport appResources = (ApplicationResourceUsageReport)Mockito.mock(ApplicationResourceUsageReport.class);
        Mockito.when((Object)appReport.getApplicationId()).thenReturn((Object)ApplicationId.newInstance((long)0L, (int)0));
        Mockito.when((Object)appResources.getNeededResources()).thenReturn(Records.newRecord(Resource.class));
        Mockito.when((Object)appResources.getReservedResources()).thenReturn(Records.newRecord(Resource.class));
        Mockito.when((Object)appResources.getUsedResources()).thenReturn(Records.newRecord(Resource.class));
        Mockito.when((Object)appReport.getApplicationResourceUsageReport()).thenReturn((Object)appResources);
        Mockito.when((Object)appReport.getYarnApplicationState()).thenReturn((Object)yarnApplicationState);
        Mockito.when((Object)appReport.getFinalApplicationStatus()).thenReturn((Object)finalApplicationStatus);
        return appReport;
    }
}

