/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import com.google.common.collect.HashMultiset;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.TimeoutException;
import java.util.zip.GZIPOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.input.CombineFileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.CombineFileRecordReader;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TestCombineFileInputFormat;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestCombineFileInputFormat {
    private static final String[] rack1 = new String[]{"/r1"};
    private static final String[] hosts1 = new String[]{"host1.rack1.com"};
    private static final String[] rack2 = new String[]{"/r2"};
    private static final String[] hosts2 = new String[]{"host2.rack2.com"};
    private static final String[] rack3 = new String[]{"/r3"};
    private static final String[] hosts3 = new String[]{"host3.rack3.com"};
    final Path inDir = new Path("/racktesting");
    final Path outputPath = new Path("/output");
    final Path dir1 = new Path(this.inDir, "/dir1");
    final Path dir2 = new Path(this.inDir, "/dir2");
    final Path dir3 = new Path(this.inDir, "/dir3");
    final Path dir4 = new Path(this.inDir, "/dir4");
    final Path dir5 = new Path(this.inDir, "/dir5");
    static final int BLOCKSIZE = 1024;
    static final byte[] databuf = new byte[1024];
    private static final String DUMMY_FS_URI = "dummyfs:///";
    private static final String DUMMY_KEY = "dummy.rr.key";

    @Test
    public void testRecordReaderInit() throws InterruptedException, IOException {
        TaskAttemptID taskId = new TaskAttemptID("jt", 0, TaskType.MAP, 0, 0);
        Configuration conf1 = new Configuration();
        conf1.set("dummy.rr.key", "STATE1");
        TaskAttemptContextImpl context1 = new TaskAttemptContextImpl(conf1, taskId);
        ChildRRInputFormat inputFormat = new ChildRRInputFormat(this, null);
        Path[] files = new Path[]{new Path("file1")};
        long[] lengths = new long[]{1L};
        CombineFileSplit split = new CombineFileSplit(files, lengths);
        RecordReader rr = inputFormat.createRecordReader((InputSplit)split, (TaskAttemptContext)context1);
        Assert.assertTrue((String)"Unexpected RR type!", (boolean)(rr instanceof CombineFileRecordReader));
        Assert.assertEquals((String)"Invalid initial dummy key value", (Object)"STATE1", (Object)rr.getCurrentKey().toString());
        Configuration conf2 = new Configuration();
        conf2.set("dummy.rr.key", "STATE2");
        TaskAttemptContextImpl context2 = new TaskAttemptContextImpl(conf2, taskId);
        rr.initialize((InputSplit)split, (TaskAttemptContext)context2);
        Assert.assertEquals((String)"Invalid secondary dummy key value", (Object)"STATE2", (Object)rr.getCurrentKey().toString());
    }

    @Test
    public void testReinit() throws Exception {
        TaskAttemptID taskId = new TaskAttemptID("jt", 0, TaskType.MAP, 0, 0);
        Configuration conf = new Configuration();
        TaskAttemptContextImpl context = new TaskAttemptContextImpl(conf, taskId);
        ChildRRInputFormat inputFormat = new ChildRRInputFormat(this, null);
        Path[] files = new Path[]{new Path("file1"), new Path("file2")};
        long[] lengths = new long[]{1L, 1L};
        CombineFileSplit split = new CombineFileSplit(files, lengths);
        RecordReader rr = inputFormat.createRecordReader((InputSplit)split, (TaskAttemptContext)context);
        Assert.assertTrue((String)"Unexpected RR type!", (boolean)(rr instanceof CombineFileRecordReader));
        rr.initialize((InputSplit)split, (TaskAttemptContext)context);
        Assert.assertTrue((boolean)rr.nextKeyValue());
        Assert.assertEquals((Object)"file1", (Object)rr.getCurrentValue().toString());
        Assert.assertTrue((boolean)rr.nextKeyValue());
        Assert.assertEquals((Object)"file2", (Object)rr.getCurrentValue().toString());
        Assert.assertFalse((boolean)rr.nextKeyValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitPlacement() throws Exception {
        MiniDFSCluster dfs = null;
        DistributedFileSystem fileSys = null;
        try {
            Configuration conf = new Configuration();
            conf.setBoolean("dfs.replication.considerLoad", false);
            dfs = new MiniDFSCluster.Builder(conf).racks(rack1).hosts(hosts1).build();
            dfs.waitActive();
            fileSys = dfs.getFileSystem();
            if (!fileSys.mkdirs(this.inDir)) {
                throw new IOException("Mkdirs failed to create " + this.inDir.toString());
            }
            Path file1 = new Path(this.dir1 + "/file1");
            TestCombineFileInputFormat.writeFile((Configuration)conf, (Path)file1, (short)1, (int)1);
            Path file5 = new Path(this.dir5 + "/file5");
            TestCombineFileInputFormat.writeFile((Configuration)conf, (Path)file5, (short)1, (int)1);
            DummyInputFormat inFormat = new DummyInputFormat(this, null);
            Job job = Job.getInstance((Configuration)conf);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir5));
            List splits = inFormat.getSplits((JobContext)job);
            System.out.println("Made splits(Test0): " + splits.size());
            for (InputSplit split : splits) {
                System.out.println("File split(Test0): " + split);
            }
            Assert.assertEquals((long)1L, (long)splits.size());
            CombineFileSplit fileSplit = (CombineFileSplit)splits.get(0);
            Assert.assertEquals((long)2L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file1.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)file5.getName(), (Object)fileSplit.getPath(1).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(1));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
            dfs.startDataNodes(conf, 1, true, null, rack2, hosts2, null);
            dfs.waitActive();
            Path file2 = new Path(this.dir2 + "/file2");
            TestCombineFileInputFormat.writeFile((Configuration)conf, (Path)file2, (short)2, (int)2);
            inFormat = new DummyInputFormat(this, null);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2));
            inFormat.setMinSplitSizeRack(1024L);
            splits = inFormat.getSplits((JobContext)job);
            System.out.println("Made splits(Test1): " + splits.size());
            for (Object split : splits) {
                System.out.println("File split(Test1): " + split);
            }
            Assert.assertEquals((long)2L, (long)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            Assert.assertEquals((long)2L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file2.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)file2.getName(), (Object)fileSplit.getPath(1).getName());
            Assert.assertEquals((long)1024L, (long)fileSplit.getOffset(1));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            Assert.assertEquals((Object)hosts2[0], (Object)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file1.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
            dfs.startDataNodes(conf, 1, true, null, rack3, hosts3, null);
            dfs.waitActive();
            Path file3 = new Path(this.dir3 + "/file3");
            TestCombineFileInputFormat.writeFile((Configuration)conf, (Path)new Path(this.dir3 + "/file3"), (short)3, (int)3);
            inFormat = new DummyInputFormat(this, null);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3));
            inFormat.setMinSplitSizeRack(1024L);
            splits = inFormat.getSplits((JobContext)job);
            for (Object split : splits) {
                System.out.println("File split(Test2): " + split);
            }
            Assert.assertEquals((long)3L, (long)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            Assert.assertEquals((long)3L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file3.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)file3.getName(), (Object)fileSplit.getPath(1).getName());
            Assert.assertEquals((long)1024L, (long)fileSplit.getOffset(1));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            Assert.assertEquals((Object)file3.getName(), (Object)fileSplit.getPath(2).getName());
            Assert.assertEquals((long)2048L, (long)fileSplit.getOffset(2));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(2));
            Assert.assertEquals((Object)hosts3[0], (Object)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            Assert.assertEquals((long)2L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file2.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)file2.getName(), (Object)fileSplit.getPath(1).getName());
            Assert.assertEquals((long)1024L, (long)fileSplit.getOffset(1));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            Assert.assertEquals((Object)hosts2[0], (Object)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(2);
            Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file1.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
            Path file4 = new Path(this.dir4 + "/file4");
            TestCombineFileInputFormat.writeFile((Configuration)conf, (Path)file4, (short)3, (int)3);
            inFormat = new DummyInputFormat(this, null);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            inFormat.setMinSplitSizeRack(1024L);
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test3): " + split);
            }
            Assert.assertEquals((long)3L, (long)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            Assert.assertEquals((long)6L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file3.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)file3.getName(), (Object)fileSplit.getPath(1).getName());
            Assert.assertEquals((long)1024L, (long)fileSplit.getOffset(1));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            Assert.assertEquals((Object)file3.getName(), (Object)fileSplit.getPath(2).getName());
            Assert.assertEquals((long)2048L, (long)fileSplit.getOffset(2));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(2));
            Assert.assertEquals((Object)hosts3[0], (Object)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            Assert.assertEquals((long)2L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file2.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)file2.getName(), (Object)fileSplit.getPath(1).getName());
            Assert.assertEquals((long)1024L, (long)fileSplit.getOffset(1));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            Assert.assertEquals((Object)hosts2[0], (Object)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(2);
            Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file1.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
            inFormat = new DummyInputFormat(this, null);
            inFormat.setMinSplitSizeNode(1024L);
            inFormat.setMaxSplitSize(2048L);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test4): " + split);
            }
            Assert.assertEquals((long)5L, (long)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            Assert.assertEquals((long)2L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file3.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)file3.getName(), (Object)fileSplit.getPath(1).getName());
            Assert.assertEquals((long)1024L, (long)fileSplit.getOffset(1));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            Assert.assertEquals((Object)"host3.rack3.com", (Object)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            Assert.assertEquals((Object)file2.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)file2.getName(), (Object)fileSplit.getPath(1).getName());
            Assert.assertEquals((long)1024L, (long)fileSplit.getOffset(1));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            Assert.assertEquals((Object)"host2.rack2.com", (Object)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(2);
            Assert.assertEquals((long)2L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file1.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)file3.getName(), (Object)fileSplit.getPath(1).getName());
            Assert.assertEquals((long)2048L, (long)fileSplit.getOffset(1));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            Assert.assertEquals((Object)"host1.rack1.com", (Object)fileSplit.getLocations()[0]);
            inFormat = new DummyInputFormat(this, null);
            inFormat.setMinSplitSizeNode(1024L);
            inFormat.setMaxSplitSize(3072L);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test5): " + split);
            }
            Assert.assertEquals((long)3L, (long)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            Assert.assertEquals((long)3L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file3.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)file3.getName(), (Object)fileSplit.getPath(1).getName());
            Assert.assertEquals((long)1024L, (long)fileSplit.getOffset(1));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            Assert.assertEquals((Object)file3.getName(), (Object)fileSplit.getPath(2).getName());
            Assert.assertEquals((long)2048L, (long)fileSplit.getOffset(2));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(2));
            Assert.assertEquals((Object)"host3.rack3.com", (Object)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            Assert.assertEquals((Object)file2.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)file2.getName(), (Object)fileSplit.getPath(1).getName());
            Assert.assertEquals((long)1024L, (long)fileSplit.getOffset(1));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            Assert.assertEquals((Object)file4.getName(), (Object)fileSplit.getPath(2).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(2));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(2));
            Assert.assertEquals((Object)"host2.rack2.com", (Object)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(2);
            Assert.assertEquals((long)3L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file1.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)file4.getName(), (Object)fileSplit.getPath(1).getName());
            Assert.assertEquals((long)1024L, (long)fileSplit.getOffset(1));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            Assert.assertEquals((Object)file4.getName(), (Object)fileSplit.getPath(2).getName());
            Assert.assertEquals((long)2048L, (long)fileSplit.getOffset(2));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(2));
            Assert.assertEquals((Object)"host1.rack1.com", (Object)fileSplit.getLocations()[0]);
            inFormat = new DummyInputFormat(this, null);
            inFormat.setMaxSplitSize(4096L);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test6): " + split);
            }
            Assert.assertEquals((long)3L, (long)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            Assert.assertEquals((long)4L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file3.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)file3.getName(), (Object)fileSplit.getPath(1).getName());
            Assert.assertEquals((long)1024L, (long)fileSplit.getOffset(1));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            Assert.assertEquals((Object)file3.getName(), (Object)fileSplit.getPath(2).getName());
            Assert.assertEquals((long)2048L, (long)fileSplit.getOffset(2));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(2));
            Assert.assertEquals((Object)"host3.rack3.com", (Object)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            Assert.assertEquals((long)4L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((Object)file2.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)file2.getName(), (Object)fileSplit.getPath(1).getName());
            Assert.assertEquals((long)1024L, (long)fileSplit.getOffset(1));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            Assert.assertEquals((Object)file4.getName(), (Object)fileSplit.getPath(2).getName());
            Assert.assertEquals((long)1024L, (long)fileSplit.getOffset(2));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(2));
            Assert.assertEquals((Object)file4.getName(), (Object)fileSplit.getPath(3).getName());
            Assert.assertEquals((long)2048L, (long)fileSplit.getOffset(3));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(3));
            Assert.assertEquals((Object)"host2.rack2.com", (Object)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(2);
            Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file1.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
            inFormat = new DummyInputFormat(this, null);
            inFormat.setMaxSplitSize(7168L);
            inFormat.setMinSplitSizeNode(3072L);
            inFormat.setMinSplitSizeRack(3072L);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test7): " + split);
            }
            Assert.assertEquals((long)2L, (long)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            Assert.assertEquals((long)6L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)"host3.rack3.com", (Object)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            Assert.assertEquals((long)3L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)"host1.rack1.com", (Object)fileSplit.getLocations()[0]);
            inFormat = new DummyInputFormat(this, null);
            FileInputFormat.addInputPath((Job)job, (Path)this.inDir);
            inFormat.setMinSplitSizeRack(1L);
            inFormat.createPool(new PathFilter[]{new TestFilter(this.dir1), new TestFilter(this.dir2)});
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test1): " + split);
            }
            Assert.assertEquals((long)3L, (long)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            Assert.assertEquals((long)2L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)hosts2[0], (Object)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(2);
            Assert.assertEquals((long)6L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)hosts3[0], (Object)fileSplit.getLocations()[0]);
            int numPools = 100;
            int numFiles = 1000;
            DummyInputFormat1 inFormat1 = new DummyInputFormat1(this, null);
            for (int i = 0; i < numFiles; ++i) {
                FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{file1});
            }
            inFormat1.setMinSplitSizeRack(1L);
            Path dirNoMatch1 = new Path(this.inDir, "/dirxx");
            Path dirNoMatch2 = new Path(this.inDir, "/diryy");
            for (int i = 0; i < numPools; ++i) {
                inFormat1.createPool(new PathFilter[]{new TestFilter(dirNoMatch1), new TestFilter(dirNoMatch2)});
            }
            long start = System.currentTimeMillis();
            splits = inFormat1.getSplits((JobContext)job);
            long end = System.currentTimeMillis();
            System.out.println("Elapsed time for " + numPools + " pools " + " and " + numFiles + " files is " + (end - start) / 1000L + " seconds.");
            inFormat = new DummyInputFormat(this, null);
            inFormat.setMaxSplitSize(512L);
            FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{this.dir3});
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test8): " + split);
            }
            Assert.assertEquals((long)splits.size(), (long)6L);
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
        }
    }

    static void writeFile(Configuration conf, Path name, short replication, int numBlocks) throws IOException, TimeoutException, InterruptedException {
        FileSystem fileSys = FileSystem.get((Configuration)conf);
        FSDataOutputStream stm = fileSys.create(name, true, conf.getInt("io.file.buffer.size", 4096), replication, 1024L);
        TestCombineFileInputFormat.writeDataAndSetReplication((FileSystem)fileSys, (Path)name, (OutputStream)stm, (short)replication, (int)numBlocks);
    }

    static FileStatus writeGzipFile(Configuration conf, Path name, short replication, int numBlocks) throws IOException, TimeoutException, InterruptedException {
        FileSystem fileSys = FileSystem.get((Configuration)conf);
        GZIPOutputStream out = new GZIPOutputStream((OutputStream)fileSys.create(name, true, conf.getInt("io.file.buffer.size", 4096), replication, 1024L));
        TestCombineFileInputFormat.writeDataAndSetReplication((FileSystem)fileSys, (Path)name, (OutputStream)out, (short)replication, (int)numBlocks);
        return fileSys.getFileStatus(name);
    }

    private static void writeDataAndSetReplication(FileSystem fileSys, Path name, OutputStream out, short replication, int numBlocks) throws IOException, TimeoutException, InterruptedException {
        for (int i = 0; i < numBlocks; ++i) {
            out.write(databuf);
        }
        out.close();
        DFSTestUtil.waitReplication((FileSystem)fileSys, (Path)name, (short)replication);
    }

    @Test
    public void testNodeDistribution() throws IOException, InterruptedException {
        DummyInputFormat inFormat = new DummyInputFormat(this, null);
        int numBlocks = 60;
        long totLength = 0L;
        long blockSize = 100L;
        int numNodes = 10;
        long minSizeNode = 50L;
        long minSizeRack = 50L;
        int maxSplitSize = 200;
        String[] locations = new String[numNodes];
        for (int i = 0; i < numNodes; ++i) {
            locations[i] = "h" + i;
        }
        String[] racks = new String[]{};
        Path path = new Path("hdfs://file");
        CombineFileInputFormat.OneBlockInfo[] blocks = new CombineFileInputFormat.OneBlockInfo[numBlocks];
        int hostCountBase = 0;
        for (int i = 0; i < numBlocks; ++i) {
            int localHostCount = hostCountBase;
            String[] blockHosts = new String[3];
            for (int j = 0; j < 3; ++j) {
                int hostNum = localHostCount % numNodes;
                blockHosts[j] = "h" + hostNum;
                ++localHostCount;
            }
            ++hostCountBase;
            blocks[i] = new CombineFileInputFormat.OneBlockInfo(path, (long)i * blockSize, blockSize, blockHosts, racks);
            totLength += blockSize;
        }
        ArrayList splits = new ArrayList();
        HashMap rackToNodes = new HashMap();
        HashMap rackToBlocks = new HashMap();
        HashMap blockToNodes = new HashMap();
        TreeMap nodeToBlocks = new TreeMap();
        CombineFileInputFormat.OneFileInfo.populateBlockInfo((CombineFileInputFormat.OneBlockInfo[])blocks, rackToBlocks, blockToNodes, nodeToBlocks, rackToNodes);
        inFormat.createSplits(nodeToBlocks, blockToNodes, rackToBlocks, totLength, (long)maxSplitSize, minSizeNode, minSizeRack, splits);
        int expectedSplitCount = (int)(totLength / (long)maxSplitSize);
        Assert.assertEquals((long)expectedSplitCount, (long)splits.size());
        int numLocalSplits = 0;
        for (InputSplit inputSplit : splits) {
            Assert.assertEquals((long)maxSplitSize, (long)inputSplit.getLength());
            if (inputSplit.getLocations().length != 1) continue;
            ++numLocalSplits;
        }
        Assert.assertTrue(((double)numLocalSplits >= 0.9 * (double)splits.size() ? 1 : 0) != 0);
    }

    @Test
    public void testNodeInputSplit() throws IOException, InterruptedException {
        DummyInputFormat inFormat = new DummyInputFormat(this, null);
        int numBlocks = 12;
        long totLength = 0L;
        long blockSize = 100L;
        long maxSize = 200L;
        long minSizeNode = 50L;
        long minSizeRack = 50L;
        String[] locations = new String[]{"h1", "h2"};
        String[] racks = new String[]{};
        Path path = new Path("hdfs://file");
        CombineFileInputFormat.OneBlockInfo[] blocks = new CombineFileInputFormat.OneBlockInfo[numBlocks];
        for (int i = 0; i < numBlocks; ++i) {
            blocks[i] = new CombineFileInputFormat.OneBlockInfo(path, (long)i * blockSize, blockSize, locations, racks);
            totLength += blockSize;
        }
        ArrayList splits = new ArrayList();
        HashMap rackToNodes = new HashMap();
        HashMap rackToBlocks = new HashMap();
        HashMap blockToNodes = new HashMap();
        HashMap nodeToBlocks = new HashMap();
        CombineFileInputFormat.OneFileInfo.populateBlockInfo((CombineFileInputFormat.OneBlockInfo[])blocks, rackToBlocks, blockToNodes, nodeToBlocks, rackToNodes);
        inFormat.createSplits(nodeToBlocks, blockToNodes, rackToBlocks, totLength, maxSize, minSizeNode, minSizeRack, splits);
        int expectedSplitCount = (int)(totLength / maxSize);
        Assert.assertEquals((long)expectedSplitCount, (long)splits.size());
        HashMultiset nodeSplits = HashMultiset.create();
        for (int i = 0; i < expectedSplitCount; ++i) {
            InputSplit inSplit = (InputSplit)splits.get(i);
            Assert.assertEquals((long)maxSize, (long)inSplit.getLength());
            Assert.assertEquals((long)1L, (long)inSplit.getLocations().length);
            nodeSplits.add((Object)inSplit.getLocations()[0]);
        }
        Assert.assertEquals((long)3L, (long)nodeSplits.count((Object)locations[0]));
        Assert.assertEquals((long)3L, (long)nodeSplits.count((Object)locations[1]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitPlacementForCompressedFiles() throws Exception {
        MiniDFSCluster dfs = null;
        DistributedFileSystem fileSys = null;
        try {
            Configuration conf = new Configuration();
            conf.setBoolean("dfs.replication.considerLoad", false);
            dfs = new MiniDFSCluster.Builder(conf).racks(rack1).hosts(hosts1).build();
            dfs.waitActive();
            fileSys = dfs.getFileSystem();
            if (!fileSys.mkdirs(this.inDir)) {
                throw new IOException("Mkdirs failed to create " + this.inDir.toString());
            }
            Path file1 = new Path(this.dir1 + "/file1.gz");
            FileStatus f1 = TestCombineFileInputFormat.writeGzipFile((Configuration)conf, (Path)file1, (short)1, (int)1);
            Path file5 = new Path(this.dir5 + "/file5.gz");
            FileStatus f5 = TestCombineFileInputFormat.writeGzipFile((Configuration)conf, (Path)file5, (short)1, (int)1);
            DummyInputFormat inFormat = new DummyInputFormat(this, null);
            Job job = Job.getInstance((Configuration)conf);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir5));
            List splits = inFormat.getSplits((JobContext)job);
            System.out.println("Made splits(Test0): " + splits.size());
            for (InputSplit split : splits) {
                System.out.println("File split(Test0): " + split);
            }
            Assert.assertEquals((long)1L, (long)splits.size());
            CombineFileSplit fileSplit = (CombineFileSplit)splits.get(0);
            Assert.assertEquals((long)2L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file1.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)f1.getLen(), (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)file5.getName(), (Object)fileSplit.getPath(1).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(1));
            Assert.assertEquals((long)f5.getLen(), (long)fileSplit.getLength(1));
            Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
            dfs.startDataNodes(conf, 1, true, null, rack2, hosts2, null);
            dfs.waitActive();
            Path file2 = new Path(this.dir2 + "/file2.gz");
            FileStatus f2 = TestCombineFileInputFormat.writeGzipFile((Configuration)conf, (Path)file2, (short)2, (int)2);
            inFormat = new DummyInputFormat(this, null);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2));
            inFormat.setMinSplitSizeRack(f1.getLen());
            splits = inFormat.getSplits((JobContext)job);
            System.out.println("Made splits(Test1): " + splits.size());
            for (InputSplit split : splits) {
                System.out.println("File split(Test1): " + split);
            }
            Assert.assertEquals((long)2L, (long)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file2.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)f2.getLen(), (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)hosts2[0], (Object)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file1.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)f1.getLen(), (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
            dfs.startDataNodes(conf, 1, true, null, rack3, hosts3, null);
            dfs.waitActive();
            Path file3 = new Path(this.dir3 + "/file3.gz");
            FileStatus f3 = TestCombineFileInputFormat.writeGzipFile((Configuration)conf, (Path)file3, (short)3, (int)3);
            inFormat = new DummyInputFormat(this, null);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3));
            inFormat.setMinSplitSizeRack(f1.getLen());
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test2): " + split);
            }
            Assert.assertEquals((long)3L, (long)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file3.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)f3.getLen(), (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)hosts3[0], (Object)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file2.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)f2.getLen(), (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)hosts2[0], (Object)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(2);
            Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file1.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)f1.getLen(), (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
            Path file4 = new Path(this.dir4 + "/file4.gz");
            FileStatus f4 = TestCombineFileInputFormat.writeGzipFile((Configuration)conf, (Path)file4, (short)3, (int)3);
            inFormat = new DummyInputFormat(this, null);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            inFormat.setMinSplitSizeRack(f1.getLen());
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test3): " + split);
            }
            Assert.assertEquals((long)3L, (long)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            Assert.assertEquals((long)2L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file3.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)f3.getLen(), (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)file4.getName(), (Object)fileSplit.getPath(1).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(1));
            Assert.assertEquals((long)f4.getLen(), (long)fileSplit.getLength(1));
            Assert.assertEquals((Object)hosts3[0], (Object)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file2.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)f2.getLen(), (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)hosts2[0], (Object)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(2);
            Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file1.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)f1.getLen(), (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
            inFormat = new DummyInputFormat(this, null);
            inFormat.setMinSplitSizeNode(f1.getLen());
            inFormat.setMaxSplitSize(f1.getLen());
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test4): " + split);
            }
            Assert.assertEquals((long)4L, (long)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file3.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)f3.getLen(), (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)hosts3[0], (Object)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            Assert.assertEquals((Object)file2.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)f2.getLen(), (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)hosts2[0], (Object)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(2);
            Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file1.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)f1.getLen(), (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(3);
            Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file4.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)f4.getLen(), (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)hosts3[0], (Object)fileSplit.getLocations()[0]);
            inFormat = new DummyInputFormat(this, null);
            inFormat.setMinSplitSizeNode(f1.getLen());
            inFormat.setMaxSplitSize(2L * f1.getLen());
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test5): " + split);
            }
            Assert.assertEquals((long)3L, (long)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            Assert.assertEquals((long)2L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file3.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)f3.getLen(), (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)file4.getName(), (Object)fileSplit.getPath(1).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(1));
            Assert.assertEquals((long)f4.getLen(), (long)fileSplit.getLength(1));
            Assert.assertEquals((Object)hosts3[0], (Object)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file2.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)f2.getLen(), (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)hosts2[0], (Object)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(2);
            Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file1.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)f1.getLen(), (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
            inFormat = new DummyInputFormat(this, null);
            inFormat.setMinSplitSizeNode(2L * f1.getLen());
            inFormat.setMaxSplitSize(4L * f1.getLen());
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test6): " + split);
            }
            Assert.assertEquals((long)2L, (long)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            Assert.assertEquals((long)2L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file3.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)f3.getLen(), (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)file4.getName(), (Object)fileSplit.getPath(1).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(1));
            Assert.assertEquals((long)f4.getLen(), (long)fileSplit.getLength(1));
            Assert.assertEquals((Object)hosts3[0], (Object)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            Assert.assertEquals((long)2L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((Object)file1.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)f1.getLen(), (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)file2.getName(), (Object)fileSplit.getPath(1).getName());
            Assert.assertEquals((float)0.0f, (float)fileSplit.getOffset(1), (float)1024.0f);
            Assert.assertEquals((long)f2.getLen(), (long)fileSplit.getLength(1));
            Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
            inFormat = new DummyInputFormat(this, null);
            inFormat.setMaxSplitSize(4L * f1.getLen());
            inFormat.setMinSplitSizeRack(4L * f1.getLen());
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test7): " + split);
            }
            Assert.assertEquals((long)1L, (long)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            Assert.assertEquals((long)4L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
            inFormat = new DummyInputFormat(this, null);
            inFormat.setMinSplitSizeNode(4L * f1.getLen());
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test8): " + split);
            }
            Assert.assertEquals((long)1L, (long)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            Assert.assertEquals((long)4L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
            inFormat = new DummyInputFormat(this, null);
            FileInputFormat.addInputPath((Job)job, (Path)this.inDir);
            inFormat.setMinSplitSizeRack(1L);
            inFormat.createPool(new PathFilter[]{new TestFilter(this.dir1), new TestFilter(this.dir2)});
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test9): " + split);
            }
            Assert.assertEquals((long)3L, (long)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)hosts2[0], (Object)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(2);
            Assert.assertEquals((long)2L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)hosts3[0], (Object)fileSplit.getLocations()[0]);
            int numPools = 100;
            int numFiles = 1000;
            DummyInputFormat1 inFormat1 = new DummyInputFormat1(this, null);
            for (int i = 0; i < numFiles; ++i) {
                FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{file1});
            }
            inFormat1.setMinSplitSizeRack(1L);
            Path dirNoMatch1 = new Path(this.inDir, "/dirxx");
            Path dirNoMatch2 = new Path(this.inDir, "/diryy");
            for (int i = 0; i < numPools; ++i) {
                inFormat1.createPool(new PathFilter[]{new TestFilter(dirNoMatch1), new TestFilter(dirNoMatch2)});
            }
            long start = System.currentTimeMillis();
            splits = inFormat1.getSplits((JobContext)job);
            long end = System.currentTimeMillis();
            System.out.println("Elapsed time for " + numPools + " pools " + " and " + numFiles + " files is " + (end - start) + " milli seconds.");
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMissingBlocks() throws Exception {
        String namenode = null;
        MiniDFSCluster dfs = null;
        DistributedFileSystem fileSys = null;
        String testName = "testMissingBlocks";
        try {
            Configuration conf = new Configuration();
            conf.set("fs.hdfs.impl", MissingBlockFileSystem.class.getName());
            conf.setBoolean("dfs.replication.considerLoad", false);
            dfs = new MiniDFSCluster.Builder(conf).racks(rack1).hosts(hosts1).build();
            dfs.waitActive();
            namenode = dfs.getFileSystem().getUri().getHost() + ":" + dfs.getFileSystem().getUri().getPort();
            fileSys = dfs.getFileSystem();
            if (!fileSys.mkdirs(this.inDir)) {
                throw new IOException("Mkdirs failed to create " + this.inDir.toString());
            }
            Path file1 = new Path(this.dir1 + "/file1");
            TestCombineFileInputFormat.writeFile((Configuration)conf, (Path)file1, (short)1, (int)1);
            Path file5 = new Path(this.dir5 + "/file5");
            TestCombineFileInputFormat.writeFile((Configuration)conf, (Path)file5, (short)1, (int)1);
            ((MissingBlockFileSystem)fileSys).setFileWithMissingBlocks(file1.toUri().getPath());
            DummyInputFormat inFormat = new DummyInputFormat(this, null);
            Job job = Job.getInstance((Configuration)conf);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir5));
            List splits = inFormat.getSplits((JobContext)job);
            System.out.println("Made splits(Test0): " + splits.size());
            for (InputSplit split : splits) {
                System.out.println("File split(Test0): " + split);
            }
            Assert.assertEquals((long)splits.size(), (long)1L);
            CombineFileSplit fileSplit = (CombineFileSplit)splits.get(0);
            Assert.assertEquals((long)2L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file1.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)file5.getName(), (Object)fileSplit.getPath(1).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(1));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
        }
    }

    @Test
    public void testForEmptyFile() throws Exception {
        Configuration conf = new Configuration();
        FileSystem fileSys = FileSystem.get((Configuration)conf);
        Path file = new Path("test/file");
        FSDataOutputStream out = fileSys.create(file, true, conf.getInt("io.file.buffer.size", 4096), (short)1, 1024L);
        out.write(new byte[0]);
        out.close();
        DummyInputFormat inFormat = new DummyInputFormat(this, null);
        Job job = Job.getInstance((Configuration)conf);
        FileInputFormat.setInputPaths((Job)job, (String)"test");
        List splits = inFormat.getSplits((JobContext)job);
        Assert.assertEquals((long)1L, (long)splits.size());
        CombineFileSplit fileSplit = (CombineFileSplit)splits.get(0);
        Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
        Assert.assertEquals((Object)file.getName(), (Object)fileSplit.getPath(0).getName());
        Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
        Assert.assertEquals((long)0L, (long)fileSplit.getLength(0));
        fileSys.delete(file.getParent(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetSplitsWithDirectory() throws Exception {
        MiniDFSCluster dfs = null;
        try {
            Configuration conf = new Configuration();
            dfs = new MiniDFSCluster.Builder(conf).racks(rack1).hosts(hosts1).build();
            dfs.waitActive();
            DistributedFileSystem fileSys = dfs.getFileSystem();
            Path dir1 = new Path("/dir1");
            Path file = new Path("/dir1/file1");
            Path dir2 = new Path("/dir1/dir2");
            if (!fileSys.mkdirs(dir1)) {
                throw new IOException("Mkdirs failed to create " + dir1.toString());
            }
            FSDataOutputStream out = fileSys.create(file);
            out.write(new byte[0]);
            out.close();
            if (!fileSys.mkdirs(dir2)) {
                throw new IOException("Mkdirs failed to create " + dir2.toString());
            }
            DummyInputFormat inFormat = new DummyInputFormat(this, null);
            Job job = Job.getInstance((Configuration)conf);
            FileInputFormat.setInputPaths((Job)job, (String)"/dir1");
            List splits = inFormat.getSplits((JobContext)job);
            Assert.assertEquals((long)1L, (long)splits.size());
            CombineFileSplit fileSplit = (CombineFileSplit)splits.get(0);
            Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((Object)file.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)0L, (long)fileSplit.getLength(0));
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
        }
    }

    @Test
    public void testForNonDefaultFileSystem() throws Throwable {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "dummyfs:///");
        Assert.assertEquals((Object)"dummyfs:///", (Object)FileSystem.getDefaultUri((Configuration)conf).toString());
        Path localPath = new Path("testFile1");
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        FSDataOutputStream dos = lfs.create(localPath);
        dos.writeChars("Local file for CFIF");
        dos.close();
        Job job = Job.getInstance((Configuration)conf);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{lfs.makeQualified(localPath)});
        DummyInputFormat inFormat = new DummyInputFormat(this, null);
        List splits = inFormat.getSplits((JobContext)job);
        Assert.assertTrue((splits.size() > 0 ? 1 : 0) != 0);
        for (InputSplit s : splits) {
            CombineFileSplit cfs = (CombineFileSplit)s;
            for (Path p : cfs.getPaths()) {
                Assert.assertEquals((Object)p.toUri().getScheme(), (Object)"file");
            }
        }
    }

    private void splitRealFiles(String[] args) throws IOException {
        Configuration conf = new Configuration();
        Job job = Job.getInstance();
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (!(fs instanceof DistributedFileSystem)) {
            throw new IOException("Wrong file system: " + fs.getClass().getName());
        }
        long blockSize = fs.getDefaultBlockSize();
        DummyInputFormat inFormat = new DummyInputFormat(this, null);
        for (int i = 0; i < args.length; ++i) {
            FileInputFormat.addInputPaths((Job)job, (String)args[i]);
        }
        inFormat.setMinSplitSizeRack(blockSize);
        inFormat.setMaxSplitSize(10L * blockSize);
        List splits = inFormat.getSplits((JobContext)job);
        System.out.println("Total number of splits " + splits.size());
        for (int i = 0; i < splits.size(); ++i) {
            CombineFileSplit fileSplit = (CombineFileSplit)splits.get(i);
            System.out.println("Split[" + i + "] " + fileSplit);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 0) {
            TestCombineFileInputFormat test = new TestCombineFileInputFormat();
            test.splitRealFiles(args);
        } else {
            TestCombineFileInputFormat test = new TestCombineFileInputFormat();
            test.testSplitPlacement();
        }
    }
}

