/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobHistoryFileReplayMapperV1;
import org.apache.hadoop.mapreduce.SimpleEntityWriterV1;
import org.apache.hadoop.mapreduce.SleepJob;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TimelineServicePerformance
extends Configured
implements Tool {
    static final int NUM_MAPS_DEFAULT = 1;
    static final int SIMPLE_ENTITY_WRITER = 1;
    static final int JOB_HISTORY_FILE_REPLAY_MAPPER = 2;
    static int mapperType = 1;
    static final int TIMELINE_SERVICE_VERSION_1 = 1;
    static final int TIMELINE_SERVICE_VERSION_2 = 2;
    static int timeline_service_version = 1;

    protected static int printUsage() {
        System.err.println("Usage: [-m <maps>] number of mappers (default: 1)\n     [-v] timeline service version\n     [-mtype <mapper type in integer>]\n          1. simple entity write mapper\n          2. jobhistory files replay mapper\n     [-s <(KBs)test>] number of KB per put (mtype=1, default: 1 KB)\n     [-t] package sending iterations per mapper (mtype=1, default: 100)\n     [-d <path>] root path of job history files (mtype=2)\n     [-r <replay mode>] (mtype=2)\n          1. write all entities for a job in one put (default)\n          2. write one entity at a time\n");
        GenericOptionsParser.printGenericCommandUsage((PrintStream)System.err);
        return -1;
    }

    public static boolean parseArgs(String[] args, Job job) throws IOException {
        Configuration conf = job.getConfiguration();
        conf.setInt("mapreduce.job.maps", 1);
        for (int i = 0; i < args.length; ++i) {
            if (args.length == i + 1) {
                System.out.println("ERROR: Required parameter missing from " + args[i]);
                return TimelineServicePerformance.printUsage() == 0;
            }
            try {
                if ("-v".equals(args[i])) {
                    timeline_service_version = Integer.parseInt(args[++i]);
                }
                if ("-m".equals(args[i])) {
                    if (Integer.parseInt(args[++i]) > 0) {
                        job.getConfiguration().setInt("mapreduce.job.maps", Integer.parseInt(args[i]));
                    }
                    continue;
                }
                if ("-mtype".equals(args[i])) {
                    mapperType = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-s".equals(args[i])) {
                    if (Integer.parseInt(args[++i]) > 0) {
                        conf.setInt("kbs sent", Integer.parseInt(args[i]));
                    }
                    continue;
                }
                if ("-t".equals(args[i])) {
                    if (Integer.parseInt(args[++i]) > 0) {
                        conf.setInt("testtimes", Integer.parseInt(args[i]));
                    }
                    continue;
                }
                if ("-d".equals(args[i])) {
                    conf.set("processing path", args[++i]);
                    continue;
                }
                if ("-r".equals(args[i])) {
                    conf.setInt("replay mode", Integer.parseInt(args[++i]));
                    continue;
                }
                System.out.println("Unexpected argument: " + args[i]);
                return TimelineServicePerformance.printUsage() == 0;
            }
            catch (NumberFormatException except) {
                System.out.println("ERROR: Integer expected instead of " + args[i]);
                return TimelineServicePerformance.printUsage() == 0;
            }
            catch (Exception e) {
                throw (IOException)new IOException().initCause(e);
            }
        }
        switch (timeline_service_version) {
            default: 
        }
        switch (mapperType) {
            case 2: {
                job.setMapperClass(JobHistoryFileReplayMapperV1.class);
                String processingPath = conf.get("processing path");
                if (processingPath != null && !processingPath.isEmpty()) break;
                System.out.println("processing path is missing while mtype = 2");
                return TimelineServicePerformance.printUsage() == 0;
            }
            default: {
                job.setMapperClass(SimpleEntityWriterV1.class);
                conf.setLong("timeline.server.performance.run.id", System.currentTimeMillis());
            }
        }
        return true;
    }

    public int run(String[] args) throws Exception {
        Job job = Job.getInstance((Configuration)this.getConf());
        job.setJarByClass(TimelineServicePerformance.class);
        job.setMapperClass(SimpleEntityWriterV1.class);
        job.setInputFormatClass(SleepJob.SleepInputFormat.class);
        job.setOutputFormatClass(NullOutputFormat.class);
        job.setNumReduceTasks(0);
        if (!TimelineServicePerformance.parseArgs(args, job)) {
            return -1;
        }
        Date startTime = new Date();
        System.out.println("Job started: " + startTime);
        int ret = job.waitForCompletion(true) ? 0 : 1;
        Counters counters = job.getCounters();
        long writetime = counters.findCounter((Enum)PerfCounters.TIMELINE_SERVICE_WRITE_TIME).getValue();
        long writecounts = counters.findCounter((Enum)PerfCounters.TIMELINE_SERVICE_WRITE_COUNTER).getValue();
        long writesize = counters.findCounter((Enum)PerfCounters.TIMELINE_SERVICE_WRITE_KBS).getValue();
        double transacrate = (double)(writecounts * 1000L) / (double)writetime;
        double iorate = (double)(writesize * 1000L) / (double)writetime;
        int numMaps = Integer.parseInt(job.getConfiguration().get("mapreduce.job.maps"));
        System.out.println("TRANSACTION RATE (per mapper): " + transacrate + " ops/s");
        System.out.println("IO RATE (per mapper): " + iorate + " KB/s");
        System.out.println("TRANSACTION RATE (total): " + transacrate * (double)numMaps + " ops/s");
        System.out.println("IO RATE (total): " + iorate * (double)numMaps + " KB/s");
        return ret;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new TimelineServicePerformance(), (String[])args);
        System.exit(res);
    }

    static enum PerfCounters {
        TIMELINE_SERVICE_WRITE_TIME,
        TIMELINE_SERVICE_WRITE_COUNTER,
        TIMELINE_SERVICE_WRITE_FAILURES,
        TIMELINE_SERVICE_WRITE_KBS;

    }
}

