/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.hadoop.mapred.JobQueueInfo;
import org.apache.hadoop.mapred.QueueConfigurationParser;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestQueueConfigurationParser {
    @Test(timeout=5000L)
    public void testQueueConfigurationParser() throws ParserConfigurationException, Exception {
        JobQueueInfo info = new JobQueueInfo("root", "rootInfo");
        JobQueueInfo infoChild1 = new JobQueueInfo("child1", "child1Info");
        JobQueueInfo infoChild2 = new JobQueueInfo("child2", "child1Info");
        info.addChild(infoChild1);
        info.addChild(infoChild2);
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element e = QueueConfigurationParser.getQueueElement((Document)document, (JobQueueInfo)info);
        DOMSource domSource = new DOMSource(e);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.transform(domSource, result);
        String str = writer.toString();
        Assert.assertTrue((boolean)str.endsWith("<queue><name>root</name><properties/><state>running</state><queue><name>child1</name><properties/><state>running</state></queue><queue><name>child2</name><properties/><state>running</state></queue></queue>"));
    }
}

