/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.lib.LongSumReducer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(TestFileSystem.class);
    private static Configuration conf = new Configuration();
    private static int BUFFER_SIZE = conf.getInt("io.file.buffer.size", 4096);
    private static final long MEGA = 0x100000L;
    private static final int SEEKS_PER_FILE = 4;
    private static String ROOT = System.getProperty("test.build.data", "fs_test");
    private static Path CONTROL_DIR = new Path(ROOT, "fs_control");
    private static Path WRITE_DIR = new Path(ROOT, "fs_write");
    private static Path READ_DIR = new Path(ROOT, "fs_read");
    private static Path DATA_DIR = new Path(ROOT, "fs_data");

    @Test
    public void testFs() throws Exception {
        TestFileSystem.testFs(0xA00000L, 100, 0L);
    }

    public static void testFs(long megaBytes, int numFiles, long seed) throws Exception {
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (seed == 0L) {
            seed = new Random().nextLong();
        }
        LOG.info("seed = " + seed);
        TestFileSystem.createControlFile(fs, megaBytes, numFiles, seed);
        TestFileSystem.writeTest(fs, false);
        TestFileSystem.readTest(fs, false);
        TestFileSystem.seekTest(fs, false);
        fs.delete(CONTROL_DIR, true);
        fs.delete(DATA_DIR, true);
        fs.delete(WRITE_DIR, true);
        fs.delete(READ_DIR, true);
    }

    @Test
    public void testCommandFormat() throws Exception {
        CommandFormat cf = new CommandFormat("copyToLocal", 2, 2, new String[]{"crc", "ignoreCrc"});
        Assert.assertEquals(cf.parse(new String[]{"-get", "file", "-"}, 1).get(1), (Object)"-");
        try {
            cf.parse(new String[]{"-get", "file", "-ignoreCrc", "/foo"}, 1);
            Assert.fail((String)"Expected parsing to fail as it should stop at first non-option");
        }
        catch (Exception exception) {
            // empty catch block
        }
        cf = new CommandFormat("tail", 1, 1, new String[]{"f"});
        Assert.assertEquals(cf.parse(new String[]{"-tail", "fileName"}, 1).get(0), (Object)"fileName");
        Assert.assertEquals(cf.parse(new String[]{"-tail", "-f", "fileName"}, 1).get(0), (Object)"fileName");
        cf = new CommandFormat("setrep", 2, 2, new String[]{"R", "w"});
        Assert.assertEquals(cf.parse(new String[]{"-setrep", "-R", "2", "/foo/bar"}, 1).get(1), (Object)"/foo/bar");
        cf = new CommandFormat("put", 2, 10000, new String[0]);
        Assert.assertEquals(cf.parse(new String[]{"-put", "-", "dest"}, 1).get(1), (Object)"dest");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createControlFile(FileSystem fs, long megaBytes, int numFiles, long seed) throws Exception {
        long totalSize;
        LOG.info("creating control file: " + megaBytes + " bytes, " + numFiles + " files");
        Path controlFile = new Path(CONTROL_DIR, "files");
        fs.delete(controlFile, true);
        Random random = new Random(seed);
        long maxSize = megaBytes / (long)numFiles * 2L + 1L;
        try (SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)controlFile, Text.class, LongWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);){
            long size;
            for (totalSize = 0L; totalSize < megaBytes; totalSize += size) {
                Text name = new Text(Long.toString(random.nextLong()));
                size = random.nextLong();
                if (size < 0L) {
                    size = -size;
                }
                writer.append((Writable)name, (Writable)new LongWritable(size %= maxSize));
            }
        }
        LOG.info("created control file for: " + totalSize + " bytes");
    }

    public static void writeTest(FileSystem fs, boolean fastCheck) throws Exception {
        fs.delete(DATA_DIR, true);
        fs.delete(WRITE_DIR, true);
        JobConf job = new JobConf(conf, TestFileSystem.class);
        job.setBoolean("fs.test.fastCheck", fastCheck);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{CONTROL_DIR});
        job.setInputFormat(SequenceFileInputFormat.class);
        job.setMapperClass(WriteMapper.class);
        job.setReducerClass(LongSumReducer.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)WRITE_DIR);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(LongWritable.class);
        job.setNumReduceTasks(1);
        JobClient.runJob((JobConf)job);
    }

    public static void readTest(FileSystem fs, boolean fastCheck) throws Exception {
        fs.delete(READ_DIR, true);
        JobConf job = new JobConf(conf, TestFileSystem.class);
        job.setBoolean("fs.test.fastCheck", fastCheck);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{CONTROL_DIR});
        job.setInputFormat(SequenceFileInputFormat.class);
        job.setMapperClass(ReadMapper.class);
        job.setReducerClass(LongSumReducer.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)READ_DIR);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(LongWritable.class);
        job.setNumReduceTasks(1);
        JobClient.runJob((JobConf)job);
    }

    public static void seekTest(FileSystem fs, boolean fastCheck) throws Exception {
        fs.delete(READ_DIR, true);
        JobConf job = new JobConf(conf, TestFileSystem.class);
        job.setBoolean("fs.test.fastCheck", fastCheck);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{CONTROL_DIR});
        job.setInputFormat(SequenceFileInputFormat.class);
        job.setMapperClass(SeekMapper.class);
        job.setReducerClass(LongSumReducer.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)READ_DIR);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(LongWritable.class);
        job.setNumReduceTasks(1);
        JobClient.runJob((JobConf)job);
    }

    public static void main(String[] args) throws Exception {
        int megaBytes = 10;
        int files = 100;
        boolean noRead = false;
        boolean noWrite = false;
        boolean noSeek = false;
        boolean fastCheck = false;
        long seed = new Random().nextLong();
        String usage = "Usage: TestFileSystem -files N -megaBytes M [-noread] [-nowrite] [-noseek] [-fastcheck]";
        if (args.length == 0) {
            System.err.println(usage);
            System.exit(-1);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-files")) {
                files = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-megaBytes")) {
                megaBytes = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-noread")) {
                noRead = true;
                continue;
            }
            if (args[i].equals("-nowrite")) {
                noWrite = true;
                continue;
            }
            if (args[i].equals("-noseek")) {
                noSeek = true;
                continue;
            }
            if (!args[i].equals("-fastcheck")) continue;
            fastCheck = true;
        }
        LOG.info("seed = " + seed);
        LOG.info("files = " + files);
        LOG.info("megaBytes = " + megaBytes);
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (!noWrite) {
            TestFileSystem.createControlFile(fs, (long)megaBytes * 0x100000L, files, seed);
            TestFileSystem.writeTest(fs, fastCheck);
        }
        if (!noRead) {
            TestFileSystem.readTest(fs, fastCheck);
        }
        if (!noSeek) {
            TestFileSystem.seekTest(fs, fastCheck);
        }
    }

    @Test
    public void testFsCache() throws Exception {
        long now = System.currentTimeMillis();
        String[] users = new String[]{"foo", "bar"};
        final Configuration conf = new Configuration();
        FileSystem[] fs = new FileSystem[users.length];
        for (int i = 0; i < users.length; ++i) {
            UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)users[i]);
            fs[i] = (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws IOException {
                    return FileSystem.get((Configuration)conf);
                }
            });
            for (int j = 0; j < i; ++j) {
                Assert.assertFalse((fs[j] == fs[i] ? 1 : 0) != 0);
            }
        }
        FileSystem.closeAll();
        try {
            TestFileSystem.runTestCache(8020);
        }
        catch (BindException be) {
            LOG.warn("Cannot test HdfsClientConfigKeys.DFS_NAMENODE_RPC_PORT_DEFAULT (=8020)", (Throwable)be);
        }
        TestFileSystem.runTestCache(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runTestCache(int port) throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).nameNodePort(port).numDataNodes(2).build();
            URI uri = cluster.getFileSystem().getUri();
            LOG.info("uri=" + uri);
            FileSystem fs = FileSystem.get((URI)uri, (Configuration)new Configuration());
            TestFileSystem.checkPath(cluster, fs);
            for (int i = 0; i < 100; ++i) {
                Assert.assertTrue((fs == FileSystem.get((URI)uri, (Configuration)new Configuration()) ? 1 : 0) != 0);
            }
            if (port == 8020) {
                URI uri2 = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), 8020, uri.getPath(), uri.getQuery(), uri.getFragment());
                LOG.info("uri2=" + uri2);
                FileSystem fs2 = FileSystem.get((URI)uri2, (Configuration)conf);
                TestFileSystem.checkPath(cluster, fs2);
                for (int i = 0; i < 100; ++i) {
                    Assert.assertTrue((fs2 == FileSystem.get((URI)uri2, (Configuration)new Configuration()) ? 1 : 0) != 0);
                }
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    static void checkPath(MiniDFSCluster cluster, FileSystem fileSys) throws IOException {
        InetSocketAddress add = cluster.getNameNode().getNameNodeAddress();
        fileSys.checkPath(new Path("hdfs://" + StringUtils.toUpperCase((String)add.getHostName()) + ":" + add.getPort()));
    }

    @Test
    public void testFsClose() throws Exception {
        Configuration conf = new Configuration();
        new Path("file:///").getFileSystem(conf);
        FileSystem.closeAll();
    }

    @Test
    public void testFsShutdownHook() throws Exception {
        Set<FileSystem> closed = Collections.synchronizedSet(new HashSet());
        Configuration conf = new Configuration();
        Configuration confNoAuto = new Configuration();
        conf.setClass("fs.test.impl", TestShutdownFileSystem.class, FileSystem.class);
        confNoAuto.setClass("fs.test.impl", TestShutdownFileSystem.class, FileSystem.class);
        confNoAuto.setBoolean("fs.automatic.close", false);
        TestShutdownFileSystem fsWithAuto = (TestShutdownFileSystem)new Path("test://a/").getFileSystem(conf);
        TestShutdownFileSystem fsWithoutAuto = (TestShutdownFileSystem)new Path("test://b/").getFileSystem(confNoAuto);
        fsWithAuto.setClosedSet(closed);
        fsWithoutAuto.setClosedSet(closed);
        Assert.assertNotSame((Object)((Object)fsWithAuto), (Object)((Object)fsWithoutAuto));
        FileSystem.CACHE.closeAll(true);
        Assert.assertEquals((long)1L, (long)closed.size());
        Assert.assertTrue((boolean)closed.contains((Object)fsWithAuto));
        closed.clear();
        FileSystem.closeAll();
        Assert.assertEquals((long)1L, (long)closed.size());
        Assert.assertTrue((boolean)closed.contains((Object)fsWithoutAuto));
    }

    @Test
    public void testCacheKeysAreCaseInsensitive() throws Exception {
        Configuration conf = new Configuration();
        FileSystem.Cache.Key lowercaseCachekey1 = new FileSystem.Cache.Key(new URI("hdfs://localhost:12345/"), conf);
        FileSystem.Cache.Key lowercaseCachekey2 = new FileSystem.Cache.Key(new URI("hdfs://localhost:12345/"), conf);
        Assert.assertEquals((Object)lowercaseCachekey1, (Object)lowercaseCachekey2);
        FileSystem.Cache.Key uppercaseCachekey = new FileSystem.Cache.Key(new URI("HDFS://Localhost:12345/"), conf);
        Assert.assertEquals((Object)lowercaseCachekey2, (Object)uppercaseCachekey);
        ArrayList<FileSystem.Cache.Key> list = new ArrayList<FileSystem.Cache.Key>();
        list.add(uppercaseCachekey);
        Assert.assertTrue((boolean)list.contains(uppercaseCachekey));
        Assert.assertTrue((boolean)list.contains(lowercaseCachekey2));
        HashSet<FileSystem.Cache.Key> set = new HashSet<FileSystem.Cache.Key>();
        set.add(uppercaseCachekey);
        Assert.assertTrue((boolean)set.contains(uppercaseCachekey));
        Assert.assertTrue((boolean)set.contains(lowercaseCachekey2));
        HashMap<FileSystem.Cache.Key, String> map = new HashMap<FileSystem.Cache.Key, String>();
        map.put(uppercaseCachekey, "");
        Assert.assertTrue((boolean)map.containsKey(uppercaseCachekey));
        Assert.assertTrue((boolean)map.containsKey(lowercaseCachekey2));
    }

    public static void testFsUniqueness(long megaBytes, int numFiles, long seed) throws Exception {
        FileSystem fs2;
        FileSystem fs1 = FileSystem.get((Configuration)conf);
        Assert.assertTrue((fs1 == (fs2 = FileSystem.get((Configuration)conf)) ? 1 : 0) != 0);
        fs1 = FileSystem.newInstance((Configuration)conf);
        fs2 = FileSystem.newInstance((Configuration)conf);
        Assert.assertTrue((fs1 != fs2 && !fs1.equals(fs2) ? 1 : 0) != 0);
        fs1.close();
        fs2.close();
    }

    static /* synthetic */ int access$000() {
        return BUFFER_SIZE;
    }

    public static class TestShutdownFileSystem
    extends RawLocalFileSystem {
        private Set<FileSystem> closedSet;

        public void setClosedSet(Set<FileSystem> closedSet) {
            this.closedSet = closedSet;
        }

        public void close() throws IOException {
            if (this.closedSet != null) {
                this.closedSet.add((FileSystem)this);
            }
            super.close();
        }
    }

    public static class SeekMapper<K>
    extends Configured
    implements Mapper<Text, LongWritable, K, LongWritable> {
        private Random random = new Random();
        private byte[] check = new byte[TestFileSystem.access$000()];
        private FileSystem fs;
        private boolean fastCheck;

        public SeekMapper() {
            super(null);
            try {
                this.fs = FileSystem.get((Configuration)conf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public SeekMapper(Configuration conf) {
            super(conf);
            try {
                this.fs = FileSystem.get((Configuration)conf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void configure(JobConf job) {
            this.setConf((Configuration)job);
            this.fastCheck = job.getBoolean("fs.test.fastCheck", false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void map(Text key, LongWritable value, OutputCollector<K, LongWritable> collector, Reporter reporter) throws IOException {
            String name = key.toString();
            long size = value.get();
            long seed = Long.parseLong(name);
            if (size == 0L) {
                return;
            }
            reporter.setStatus("opening " + name);
            try (FSDataInputStream in = this.fs.open(new Path(DATA_DIR, name));){
                for (int i = 0; i < 4; ++i) {
                    long position = Math.abs(this.random.nextLong()) % size;
                    reporter.setStatus("seeking " + name);
                    in.seek(position);
                    byte b = in.readByte();
                    int checkByte = 0;
                    this.random.setSeed(seed);
                    int p = 0;
                    while ((long)p <= position) {
                        reporter.setStatus("generating data for " + name);
                        if (this.fastCheck) {
                            checkByte = (byte)this.random.nextInt(127);
                        } else {
                            this.random.nextBytes(this.check);
                            checkByte = this.check[(int)(position % (long)this.check.length)];
                        }
                        p += this.check.length;
                    }
                    Assert.assertEquals((long)b, (long)checkByte);
                }
            }
        }

        public void close() {
        }
    }

    public static class ReadMapper
    extends Configured
    implements Mapper<Text, LongWritable, Text, LongWritable> {
        private Random random = new Random();
        private byte[] buffer = new byte[TestFileSystem.access$000()];
        private byte[] check = new byte[TestFileSystem.access$000()];
        private FileSystem fs;
        private boolean fastCheck;

        public ReadMapper() {
            super(null);
            try {
                this.fs = FileSystem.get((Configuration)conf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public ReadMapper(Configuration conf) {
            super(conf);
            try {
                this.fs = FileSystem.get((Configuration)conf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void configure(JobConf job) {
            this.setConf((Configuration)job);
            this.fastCheck = job.getBoolean("fs.test.fastCheck", false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void map(Text key, LongWritable value, OutputCollector<Text, LongWritable> collector, Reporter reporter) throws IOException {
            String name = key.toString();
            long size = value.get();
            long seed = Long.parseLong(name);
            this.random.setSeed(seed);
            reporter.setStatus("opening " + name);
            long read = 0L;
            try (DataInputStream in = new DataInputStream((InputStream)this.fs.open(new Path(DATA_DIR, name)));){
                while (read < size) {
                    long remains = size - read;
                    int n = remains <= (long)this.buffer.length ? (int)remains : this.buffer.length;
                    in.readFully(this.buffer, 0, n);
                    read += (long)n;
                    if (this.fastCheck) {
                        Arrays.fill(this.check, (byte)this.random.nextInt(127));
                    } else {
                        this.random.nextBytes(this.check);
                    }
                    if (n != this.buffer.length) {
                        Arrays.fill(this.buffer, n, this.buffer.length, (byte)0);
                        Arrays.fill(this.check, n, this.check.length, (byte)0);
                    }
                    Assert.assertTrue((boolean)Arrays.equals(this.buffer, this.check));
                    reporter.setStatus("reading " + name + "@" + read + "/" + size);
                }
            }
            collector.collect((Object)new Text("bytes"), (Object)new LongWritable(read));
            reporter.setStatus("read " + name);
        }

        public void close() {
        }
    }

    public static class WriteMapper
    extends Configured
    implements Mapper<Text, LongWritable, Text, LongWritable> {
        private Random random = new Random();
        private byte[] buffer = new byte[TestFileSystem.access$000()];
        private FileSystem fs;
        private boolean fastCheck;
        private String suffix = "-" + this.random.nextLong();

        public WriteMapper() {
            super(null);
            try {
                this.fs = FileSystem.get((Configuration)conf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public WriteMapper(Configuration conf) {
            super(conf);
            try {
                this.fs = FileSystem.get((Configuration)conf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void configure(JobConf job) {
            this.setConf((Configuration)job);
            this.fastCheck = job.getBoolean("fs.test.fastCheck", false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void map(Text key, LongWritable value, OutputCollector<Text, LongWritable> collector, Reporter reporter) throws IOException {
            String name = key.toString();
            long size = value.get();
            long seed = Long.parseLong(name);
            this.random.setSeed(seed);
            reporter.setStatus("creating " + name);
            Path tempFile = new Path(DATA_DIR, name + this.suffix);
            long written = 0L;
            try (FSDataOutputStream out = this.fs.create(tempFile);){
                while (written < size) {
                    if (this.fastCheck) {
                        Arrays.fill(this.buffer, (byte)this.random.nextInt(127));
                    } else {
                        this.random.nextBytes(this.buffer);
                    }
                    long remains = size - written;
                    int length = remains <= (long)this.buffer.length ? (int)remains : this.buffer.length;
                    out.write(this.buffer, 0, length);
                    reporter.setStatus("writing " + name + "@" + (written += (long)length) + "/" + size);
                }
            }
            this.fs.rename(tempFile, new Path(DATA_DIR, name));
            collector.collect((Object)new Text("bytes"), (Object)new LongWritable(written));
            reporter.setStatus("wrote " + name);
        }

        public void close() {
        }
    }
}

