/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.maven.plugin.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.Mojo;

public class Exec {
    private Mojo mojo;

    public Exec(Mojo mojo) {
        this.mojo = mojo;
    }

    public int run(List<String> command, List<String> output) {
        return this.run(command, output, null);
    }

    public int run(List<String> command, List<String> output, List<String> errors) {
        int retCode = 1;
        ProcessBuilder pb = new ProcessBuilder(command);
        try {
            Process p = pb.start();
            OutputBufferThread stdOut = new OutputBufferThread(p.getInputStream());
            OutputBufferThread stdErr = new OutputBufferThread(p.getErrorStream());
            stdOut.start();
            stdErr.start();
            retCode = p.waitFor();
            if (retCode != 0) {
                this.mojo.getLog().warn((CharSequence)(command + " failed with error code " + retCode));
                for (String s : stdErr.getOutput()) {
                    this.mojo.getLog().debug((CharSequence)s);
                }
            }
            stdOut.join();
            stdErr.join();
            output.addAll(stdOut.getOutput());
            if (errors != null) {
                errors.addAll(stdErr.getOutput());
            }
        }
        catch (Exception ex) {
            this.mojo.getLog().warn((CharSequence)(command + " failed: " + ex.toString()));
        }
        return retCode;
    }

    public static void addEnvironment(ProcessBuilder pb, Map<String, String> env) {
        if (env == null) {
            return;
        }
        Map<String, String> processEnv = pb.environment();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            String val = entry.getValue();
            if (val == null) {
                val = "";
            }
            processEnv.put(entry.getKey(), val);
        }
    }

    public static String envToString(Map<String, String> env) {
        StringBuilder bld = new StringBuilder();
        bld.append("{");
        if (env != null) {
            for (Map.Entry<String, String> entry : env.entrySet()) {
                String val = entry.getValue();
                if (val == null) {
                    val = "";
                }
                bld.append("\n  ").append(entry.getKey()).append(" = '").append(val).append("'\n");
            }
        }
        bld.append("}");
        return bld.toString();
    }

    public static class OutputBufferThread
    extends Thread {
        private List<String> output;
        private BufferedReader reader;

        public OutputBufferThread(InputStream is) {
            this.setDaemon(true);
            this.output = new ArrayList<String>();
            try {
                this.reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Unsupported encoding " + e.toString());
            }
        }

        @Override
        public void run() {
            try {
                String line = this.reader.readLine();
                while (line != null) {
                    this.output.add(line);
                    line = this.reader.readLine();
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("make failed with error code " + ex.toString());
            }
        }

        public List<String> getOutput() {
            return this.output;
        }
    }
}

