/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3.response;

import java.nio.ByteBuffer;
import org.apache.hadoop.nfs.nfs3.Nfs3FileAttributes;
import org.apache.hadoop.nfs.nfs3.response.NFS3Response;
import org.apache.hadoop.oncrpc.XDR;

public class READ3Response
extends NFS3Response {
    private final Nfs3FileAttributes postOpAttr;
    private final int count;
    private final boolean eof;
    private final ByteBuffer data;

    public READ3Response(int status) {
        this(status, new Nfs3FileAttributes(), 0, false, null);
    }

    public READ3Response(int status, Nfs3FileAttributes postOpAttr, int count, boolean eof, ByteBuffer data) {
        super(status);
        this.postOpAttr = postOpAttr;
        this.count = count;
        this.eof = eof;
        this.data = data;
    }

    public Nfs3FileAttributes getPostOpAttr() {
        return this.postOpAttr;
    }

    public int getCount() {
        return this.count;
    }

    public boolean isEof() {
        return this.eof;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    @Override
    public XDR send(XDR out, int xid) {
        super.send(out, xid);
        out.writeBoolean(true);
        this.postOpAttr.serialize(out);
        if (this.getStatus() == 0) {
            out.writeInt(this.count);
            out.writeBoolean(this.eof);
            out.writeInt(this.count);
            out.writeFixedOpaque(this.data.array(), this.count);
        }
        return out;
    }
}

