/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3.response;

import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.Nfs3FileAttributes;
import org.apache.hadoop.nfs.nfs3.response.NFS3Response;
import org.apache.hadoop.nfs.nfs3.response.WccData;
import org.apache.hadoop.oncrpc.XDR;

public class SYMLINK3Response
extends NFS3Response {
    private final FileHandle objFileHandle;
    private final Nfs3FileAttributes objPostOpAttr;
    private final WccData dirWcc;

    public SYMLINK3Response(int status) {
        this(status, null, null, new WccData(null, null));
    }

    public SYMLINK3Response(int status, FileHandle handle, Nfs3FileAttributes attrs, WccData dirWcc) {
        super(status);
        this.objFileHandle = handle;
        this.objPostOpAttr = attrs;
        this.dirWcc = dirWcc;
    }

    public FileHandle getObjFileHandle() {
        return this.objFileHandle;
    }

    public Nfs3FileAttributes getObjPostOpAttr() {
        return this.objPostOpAttr;
    }

    public WccData getDirWcc() {
        return this.dirWcc;
    }

    @Override
    public XDR send(XDR out, int xid) {
        super.send(out, xid);
        if (this.getStatus() == 0) {
            out.writeBoolean(true);
            this.objFileHandle.serialize(out);
            out.writeBoolean(true);
            this.objPostOpAttr.serialize(out);
        }
        this.dirWcc.serialize(out);
        return out;
    }
}

