/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import org.apache.hadoop.oncrpc.RpcMessage;
import org.apache.hadoop.oncrpc.RpcReply;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.RpcAuthInfo;
import org.apache.hadoop.oncrpc.security.Verifier;

public class RpcAcceptedReply
extends RpcReply {
    private final RpcAuthInfo verifier;
    private final AcceptState acceptState;

    RpcAcceptedReply(int xid, RpcMessage.Type messageType, RpcReply.ReplyState state, RpcAuthInfo verifier, AcceptState acceptState) {
        super(xid, messageType, state);
        this.verifier = verifier;
        this.acceptState = acceptState;
    }

    public static RpcAcceptedReply read(int xid, RpcMessage.Type messageType, RpcReply.ReplyState replyState, XDR xdr) {
        Verifier verifier = Verifier.readFlavorAndVerifier(xdr);
        AcceptState acceptState = AcceptState.fromValue(xdr.readInt());
        return new RpcAcceptedReply(xid, messageType, replyState, verifier, acceptState);
    }

    public RpcAuthInfo getVerifier() {
        return this.verifier;
    }

    public AcceptState getAcceptState() {
        return this.acceptState;
    }

    public static XDR voidReply(XDR xdr, int xid) {
        return RpcAcceptedReply.voidReply(xdr, xid, AcceptState.SUCCESS);
    }

    public static XDR voidReply(XDR xdr, int xid, AcceptState acceptState) {
        xdr.writeInt(xid);
        xdr.writeInt(RpcMessage.Type.RPC_REPLY.getValue());
        xdr.writeInt(RpcReply.ReplyState.MSG_ACCEPTED.getValue());
        xdr.writeInt(RpcAuthInfo.AuthFlavor.AUTH_NONE.getValue());
        xdr.writeVariableOpaque(new byte[0]);
        xdr.writeInt(acceptState.getValue());
        return xdr;
    }

    public static enum AcceptState {
        SUCCESS,
        PROG_UNAVAIL,
        PROG_MISMATCH,
        PROC_UNAVAIL,
        GARBAGE_ARGS,
        SYSTEM_ERR;


        public static AcceptState fromValue(int value) {
            return AcceptState.values()[value];
        }

        public int getValue() {
            return this.ordinal();
        }
    }
}

