/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import org.apache.hadoop.oncrpc.RpcMessage;
import org.apache.hadoop.oncrpc.RpcReply;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.RpcAuthInfo;

public class RpcDeniedReply
extends RpcReply {
    private final RejectState rejectState;

    RpcDeniedReply(int xid, RpcMessage.Type messageType, RpcReply.ReplyState replyState, RejectState rejectState) {
        super(xid, messageType, replyState);
        this.rejectState = rejectState;
    }

    public static RpcDeniedReply read(int xid, RpcMessage.Type messageType, RpcReply.ReplyState replyState, XDR xdr) {
        RejectState rejectState = RejectState.fromValue(xdr.readInt());
        return new RpcDeniedReply(xid, messageType, replyState, rejectState);
    }

    public RejectState getRejectState() {
        return this.rejectState;
    }

    public String toString() {
        return new StringBuffer().append("xid:").append(this.xid).append(",messageType:").append((Object)this.messageType).append("rejectState:").append((Object)this.rejectState).toString();
    }

    public static XDR voidReply(XDR xdr, int xid, RpcReply.ReplyState msgAccepted, RejectState rejectState) {
        xdr.writeInt(xid);
        xdr.writeInt(RpcMessage.Type.RPC_REPLY.getValue());
        xdr.writeInt(msgAccepted.getValue());
        xdr.writeInt(RpcAuthInfo.AuthFlavor.AUTH_NONE.getValue());
        xdr.writeVariableOpaque(new byte[0]);
        xdr.writeInt(rejectState.getValue());
        return xdr;
    }

    public static enum RejectState {
        RPC_MISMATCH,
        AUTH_ERROR;


        int getValue() {
            return this.ordinal();
        }

        static RejectState fromValue(int value) {
            return RejectState.values()[value];
        }
    }
}

