/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.oncrpc.RpcAcceptedReply;
import org.apache.hadoop.oncrpc.RpcCall;
import org.apache.hadoop.oncrpc.RpcCallCache;
import org.apache.hadoop.oncrpc.SimpleUdpClient;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.portmap.PortmapMapping;
import org.apache.hadoop.portmap.PortmapRequest;
import org.jboss.netty.channel.Channel;

public abstract class RpcProgram {
    private static final Log LOG = LogFactory.getLog(RpcProgram.class);
    public static final int RPCB_PORT = 111;
    private final String program;
    private final String host;
    private final int port;
    private final int progNumber;
    private final int lowProgVersion;
    private final int highProgVersion;
    private final RpcCallCache rpcCallCache;

    protected RpcProgram(String program, String host, int port, int progNumber, int lowProgVersion, int highProgVersion, int cacheSize) {
        this.program = program;
        this.host = host;
        this.port = port;
        this.progNumber = progNumber;
        this.lowProgVersion = lowProgVersion;
        this.highProgVersion = highProgVersion;
        this.rpcCallCache = cacheSize > 0 ? new RpcCallCache(program, cacheSize) : null;
    }

    public void register(int transport) {
        for (int vers = this.lowProgVersion; vers <= this.highProgVersion; ++vers) {
            this.register(vers, transport);
        }
    }

    private void register(int progVersion, int transport) {
        PortmapMapping mapEntry = new PortmapMapping(this.progNumber, progVersion, transport, this.port);
        this.register(mapEntry);
    }

    protected void register(PortmapMapping mapEntry) {
        XDR mappingRequest = PortmapRequest.create(mapEntry);
        SimpleUdpClient registrationClient = new SimpleUdpClient(this.host, 111, mappingRequest);
        try {
            registrationClient.run();
        }
        catch (IOException e) {
            LOG.error((Object)("Registration failure with " + this.host + ":" + this.port + ", portmap entry: " + mapEntry));
            throw new RuntimeException("Registration failure");
        }
    }

    protected abstract XDR handleInternal(RpcCall var1, XDR var2, XDR var3, InetAddress var4, Channel var5);

    public XDR handle(XDR xdr, InetAddress client, Channel channel) {
        XDR response;
        RpcCallCache.CacheEntry entry;
        boolean idempotent;
        XDR out = new XDR();
        RpcCall rpcCall = RpcCall.read(xdr);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this.program + " procedure #" + rpcCall.getProcedure()));
        }
        if (!this.checkProgram(rpcCall.getProgram())) {
            return this.programMismatch(out, rpcCall);
        }
        if (!this.checkProgramVersion(rpcCall.getVersion())) {
            return this.programVersionMismatch(out, rpcCall);
        }
        boolean bl = idempotent = this.rpcCallCache != null && !this.isIdempotent(rpcCall);
        if (idempotent && (entry = this.rpcCallCache.checkOrAddToCache(client, rpcCall.getXid())) != null) {
            if (entry.isCompleted()) {
                LOG.info((Object)("Sending the cached reply to retransmitted request " + rpcCall.getXid()));
                return entry.getResponse();
            }
            LOG.info((Object)("Retransmitted request, transaction still in progress " + rpcCall.getXid()));
        }
        if ((response = this.handleInternal(rpcCall, xdr, out, client, channel)).size() == 0 && LOG.isDebugEnabled()) {
            LOG.debug((Object)("No sync response, expect an async response for request XID=" + rpcCall.getXid()));
        }
        if (idempotent) {
            this.rpcCallCache.callCompleted(client, rpcCall.getXid(), response);
        }
        return response;
    }

    private XDR programMismatch(XDR out, RpcCall call) {
        LOG.warn((Object)("Invalid RPC call program " + call.getProgram()));
        RpcAcceptedReply.voidReply(out, call.getXid(), RpcAcceptedReply.AcceptState.PROG_UNAVAIL);
        return out;
    }

    private XDR programVersionMismatch(XDR out, RpcCall call) {
        LOG.warn((Object)("Invalid RPC call version " + call.getVersion()));
        RpcAcceptedReply.voidReply(out, call.getXid(), RpcAcceptedReply.AcceptState.PROG_MISMATCH);
        out.writeInt(this.lowProgVersion);
        out.writeInt(this.highProgVersion);
        return out;
    }

    private boolean checkProgram(int progNumber) {
        return this.progNumber == progNumber;
    }

    private boolean checkProgramVersion(int programVersion) {
        return programVersion >= this.lowProgVersion && programVersion <= this.highProgVersion;
    }

    public String toString() {
        return "Rpc program: " + this.program + " at " + this.host + ":" + this.port;
    }

    protected abstract boolean isIdempotent(RpcCall var1);

    public int getPort() {
        return this.port;
    }
}

