/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.oncrpc.RpcProgram;
import org.apache.hadoop.oncrpc.XDR;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;

public class SimpleUdpServerHandler
extends SimpleChannelHandler {
    public static final Log LOG = LogFactory.getLog(SimpleUdpServerHandler.class);
    private final RpcProgram rpcProgram;

    public SimpleUdpServerHandler(RpcProgram rpcProgram) {
        this.rpcProgram = rpcProgram;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        ChannelBuffer buf = (ChannelBuffer)e.getMessage();
        XDR request = new XDR();
        request.writeFixedOpaque(buf.array());
        InetAddress remoteInetAddr = ((InetSocketAddress)e.getRemoteAddress()).getAddress();
        XDR response = this.rpcProgram.handle(request, remoteInetAddr, null);
        e.getChannel().write((Object)XDR.writeMessageUdp(response), e.getRemoteAddress());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        LOG.warn((Object)"Encountered ", e.getCause());
        e.getChannel().close();
    }
}

