/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc.security;

import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.RpcAuthInfo;
import org.apache.hadoop.oncrpc.security.VerifierGSS;
import org.apache.hadoop.oncrpc.security.VerifierNone;

public abstract class Verifier
extends RpcAuthInfo {
    protected Verifier(RpcAuthInfo.AuthFlavor flavor) {
        super(flavor);
    }

    public static Verifier readFlavorAndVerifier(XDR xdr) {
        Verifier verifer;
        RpcAuthInfo.AuthFlavor flavor = RpcAuthInfo.AuthFlavor.fromValue(xdr.readInt());
        if (flavor == RpcAuthInfo.AuthFlavor.AUTH_NONE) {
            verifer = new VerifierNone();
        } else if (flavor == RpcAuthInfo.AuthFlavor.RPCSEC_GSS) {
            verifer = new VerifierGSS();
        } else {
            throw new UnsupportedOperationException("Unsupported verifier flavor" + (Object)((Object)flavor));
        }
        ((RpcAuthInfo)verifer).read(xdr);
        return verifer;
    }
}

