/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.portmap;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.oncrpc.RpcAcceptedReply;
import org.apache.hadoop.oncrpc.RpcCall;
import org.apache.hadoop.oncrpc.RpcProgram;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.portmap.PortmapInterface;
import org.apache.hadoop.portmap.PortmapMapping;
import org.apache.hadoop.portmap.PortmapRequest;
import org.apache.hadoop.portmap.PortmapResponse;
import org.jboss.netty.channel.Channel;

public class RpcProgramPortmap
extends RpcProgram
implements PortmapInterface {
    public static final int PROGRAM = 100000;
    public static final int VERSION = 2;
    private static final Log LOG = LogFactory.getLog(RpcProgramPortmap.class);
    private final HashMap<String, PortmapMapping> map = new HashMap(256);

    public RpcProgramPortmap() {
        super("portmap", "localhost", 111, 100000, 2, 2, 0);
    }

    private synchronized void dumpRpcServices() {
        Set<Map.Entry<String, PortmapMapping>> entrySet = this.map.entrySet();
        for (Map.Entry<String, PortmapMapping> entry : entrySet) {
            LOG.info((Object)("Service: " + entry.getKey() + " portmapping: " + entry.getValue()));
        }
    }

    @Override
    public XDR nullOp(int xid, XDR in, XDR out) {
        return PortmapResponse.voidReply(out, xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XDR set(int xid, XDR in, XDR out) {
        PortmapMapping mapping = PortmapRequest.mapping(in);
        String key = PortmapMapping.key(mapping);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Portmap set key=" + key));
        }
        PortmapMapping value = null;
        RpcProgramPortmap rpcProgramPortmap = this;
        synchronized (rpcProgramPortmap) {
            this.map.put(key, mapping);
            this.dumpRpcServices();
            value = this.map.get(key);
        }
        return PortmapResponse.intReply(out, xid, value.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized XDR unset(int xid, XDR in, XDR out) {
        PortmapMapping mapping = PortmapRequest.mapping(in);
        RpcProgramPortmap rpcProgramPortmap = this;
        synchronized (rpcProgramPortmap) {
            this.map.remove(PortmapMapping.key(mapping));
        }
        return PortmapResponse.booleanReply(out, xid, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized XDR getport(int xid, XDR in, XDR out) {
        PortmapMapping mapping = PortmapRequest.mapping(in);
        String key = PortmapMapping.key(mapping);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Portmap GETPORT key=" + key + " " + mapping));
        }
        PortmapMapping value = null;
        RpcProgramPortmap rpcProgramPortmap = this;
        synchronized (rpcProgramPortmap) {
            value = this.map.get(key);
        }
        int res = 0;
        if (value != null) {
            res = value.getPort();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found mapping for key: " + key + " port:" + res));
            }
        } else {
            LOG.warn((Object)("Warning, no mapping for key: " + key));
        }
        return PortmapResponse.intReply(out, xid, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized XDR dump(int xid, XDR in, XDR out) {
        PortmapMapping[] pmapList = null;
        RpcProgramPortmap rpcProgramPortmap = this;
        synchronized (rpcProgramPortmap) {
            pmapList = new PortmapMapping[this.map.values().size()];
            this.map.values().toArray(pmapList);
        }
        return PortmapResponse.pmapList(out, xid, pmapList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(PortmapMapping mapping) {
        String key = PortmapMapping.key(mapping);
        RpcProgramPortmap rpcProgramPortmap = this;
        synchronized (rpcProgramPortmap) {
            this.map.put(key, mapping);
        }
    }

    @Override
    public XDR handleInternal(RpcCall rpcCall, XDR in, XDR out, InetAddress client, Channel channel) {
        PortmapInterface.Procedure portmapProc = PortmapInterface.Procedure.fromValue(rpcCall.getProcedure());
        int xid = rpcCall.getXid();
        if (portmapProc == PortmapInterface.Procedure.PMAPPROC_NULL) {
            out = this.nullOp(xid, in, out);
        } else if (portmapProc == PortmapInterface.Procedure.PMAPPROC_SET) {
            out = this.set(xid, in, out);
        } else if (portmapProc == PortmapInterface.Procedure.PMAPPROC_UNSET) {
            out = this.unset(xid, in, out);
        } else if (portmapProc == PortmapInterface.Procedure.PMAPPROC_DUMP) {
            out = this.dump(xid, in, out);
        } else if (portmapProc == PortmapInterface.Procedure.PMAPPROC_GETPORT) {
            out = this.getport(xid, in, out);
        } else if (portmapProc == PortmapInterface.Procedure.PMAPPROC_GETVERSADDR) {
            out = this.getport(xid, in, out);
        } else {
            LOG.info((Object)("PortmapHandler unknown rpc procedure=" + (Object)((Object)portmapProc)));
            RpcAcceptedReply.voidReply(out, xid, RpcAcceptedReply.AcceptState.PROC_UNAVAIL);
        }
        return out;
    }

    @Override
    protected boolean isIdempotent(RpcCall call) {
        return false;
    }
}

