/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.nfs.nfs3.Nfs3Base;
import org.apache.hadoop.oncrpc.RpcProgram;
import org.apache.hadoop.oncrpc.SimpleTcpServer;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.ShutdownHookManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Nfs3Base {
    public static final Logger LOG = LoggerFactory.getLogger(Nfs3Base.class);
    private final RpcProgram rpcProgram;
    private int nfsBoundPort;
    public static final int SHUTDOWN_HOOK_PRIORITY = 10;

    public RpcProgram getRpcProgram() {
        return this.rpcProgram;
    }

    protected Nfs3Base(RpcProgram rpcProgram, Configuration conf) {
        this.rpcProgram = rpcProgram;
        LOG.info("NFS server port set to: " + rpcProgram.getPort());
    }

    public void start(boolean register) {
        this.startTCPServer();
        if (register) {
            ShutdownHookManager.get().addShutdownHook((Runnable)new NfsShutdownHook(this, null), 10);
            try {
                this.rpcProgram.register(6, this.nfsBoundPort);
            }
            catch (Throwable e) {
                LOG.error("Failed to register the NFSv3 service.", e);
                ExitUtil.terminate((int)1, (Throwable)e);
            }
        }
    }

    private void startTCPServer() {
        SimpleTcpServer tcpServer = new SimpleTcpServer(this.rpcProgram.getPort(), this.rpcProgram, 0);
        this.rpcProgram.startDaemons();
        try {
            tcpServer.run();
        }
        catch (Throwable e) {
            LOG.error("Failed to start the TCP server.", e);
            if (tcpServer.getBoundPort() > 0) {
                this.rpcProgram.unregister(6, tcpServer.getBoundPort());
            }
            tcpServer.shutdown();
            ExitUtil.terminate((int)1, (Throwable)e);
        }
        this.nfsBoundPort = tcpServer.getBoundPort();
    }

    static /* synthetic */ int access$100(Nfs3Base x0) {
        return x0.nfsBoundPort;
    }

    static /* synthetic */ RpcProgram access$200(Nfs3Base x0) {
        return x0.rpcProgram;
    }
}

